/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DataSource;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;

public class ListDataSourcesIterable
implements SdkIterable<ListDataSourcesResponse> {
    private final QuickSightClient client;
    private final ListDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourcesIterable(QuickSightClient client, ListDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourcesResponseFetcher();
    }

    public Iterator<ListDataSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSource> dataSources() {
        Function<ListDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSources() != null) {
                return response.dataSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSourcesResponseFetcher
    implements SyncPageFetcher<ListDataSourcesResponse> {
        private ListDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSourcesResponse nextPage(ListDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourcesIterable.this.client.listDataSources(ListDataSourcesIterable.this.firstRequest);
            }
            return ListDataSourcesIterable.this.client.listDataSources((ListDataSourcesRequest)((Object)ListDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

