/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSourcePermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateDataSourcePermissionsResponse> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceArn").getter(UpdateDataSourcePermissionsResponse.getter(UpdateDataSourcePermissionsResponse::dataSourceArn)).setter(UpdateDataSourcePermissionsResponse.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(UpdateDataSourcePermissionsResponse.getter(UpdateDataSourcePermissionsResponse::dataSourceId)).setter(UpdateDataSourcePermissionsResponse.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateDataSourcePermissionsResponse.getter(UpdateDataSourcePermissionsResponse::requestId)).setter(UpdateDataSourcePermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateDataSourcePermissionsResponse.getter(UpdateDataSourcePermissionsResponse::status)).setter(UpdateDataSourcePermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD, DATA_SOURCE_ID_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String dataSourceArn;
    private final String dataSourceId;
    private final String requestId;
    private final Integer status;

    private UpdateDataSourcePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceArn = builder.dataSourceArn;
        this.dataSourceId = builder.dataSourceId;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String dataSourceArn() {
        return this.dataSourceArn;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourcePermissionsResponse)) {
            return false;
        }
        UpdateDataSourcePermissionsResponse other = (UpdateDataSourcePermissionsResponse)((Object)obj);
        return Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataSourcePermissionsResponse").add("DataSourceArn", (Object)this.dataSourceArn()).add("DataSourceId", (Object)this.dataSourceId()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourcePermissionsResponse, T> g) {
        return obj -> g.apply((UpdateDataSourcePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String dataSourceArn;
        private String dataSourceId;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourcePermissionsResponse model) {
            super(model);
            this.dataSourceArn(model.dataSourceArn);
            this.dataSourceId(model.dataSourceId);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateDataSourcePermissionsResponse build() {
            return new UpdateDataSourcePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSourcePermissionsResponse> {
        public Builder dataSourceArn(String var1);

        public Builder dataSourceId(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

