/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterSliderControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterSliderControl.Builder, ParameterSliderControl> {
    private static final SdkField<String> PARAMETER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterControlId").getter(getter(ParameterSliderControl::parameterControlId))
            .setter(setter(Builder::parameterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControlId").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ParameterSliderControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(ParameterSliderControl::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<SliderControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<SliderControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(ParameterSliderControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(SliderControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<Double> MAXIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaximumValue").getter(getter(ParameterSliderControl::maximumValue))
            .setter(setter(Builder::maximumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()).build();

    private static final SdkField<Double> MINIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinimumValue").getter(getter(ParameterSliderControl::minimumValue))
            .setter(setter(Builder::minimumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()).build();

    private static final SdkField<Double> STEP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StepSize").getter(getter(ParameterSliderControl::stepSize)).setter(setter(Builder::stepSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_PARAMETER_NAME_FIELD, DISPLAY_OPTIONS_FIELD, MAXIMUM_VALUE_FIELD, MINIMUM_VALUE_FIELD,
            STEP_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterControlId;

    private final String title;

    private final String sourceParameterName;

    private final SliderControlDisplayOptions displayOptions;

    private final Double maximumValue;

    private final Double minimumValue;

    private final Double stepSize;

    private ParameterSliderControl(BuilderImpl builder) {
        this.parameterControlId = builder.parameterControlId;
        this.title = builder.title;
        this.sourceParameterName = builder.sourceParameterName;
        this.displayOptions = builder.displayOptions;
        this.maximumValue = builder.maximumValue;
        this.minimumValue = builder.minimumValue;
        this.stepSize = builder.stepSize;
    }

    /**
     * <p>
     * The ID of the <code>ParameterSliderControl</code>.
     * </p>
     * 
     * @return The ID of the <code>ParameterSliderControl</code>.
     */
    public final String parameterControlId() {
        return parameterControlId;
    }

    /**
     * <p>
     * The title of the <code>ParameterSliderControl</code>.
     * </p>
     * 
     * @return The title of the <code>ParameterSliderControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source parameter name of the <code>ParameterSliderControl</code>.
     * </p>
     * 
     * @return The source parameter name of the <code>ParameterSliderControl</code>.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final SliderControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The smaller value that is displayed at the left of the slider.
     * </p>
     * 
     * @return The smaller value that is displayed at the left of the slider.
     */
    public final Double maximumValue() {
        return maximumValue;
    }

    /**
     * <p>
     * The larger value that is displayed at the right of the slider.
     * </p>
     * 
     * @return The larger value that is displayed at the right of the slider.
     */
    public final Double minimumValue() {
        return minimumValue;
    }

    /**
     * <p>
     * The number of increments that the slider bar is divided into.
     * </p>
     * 
     * @return The number of increments that the slider bar is divided into.
     */
    public final Double stepSize() {
        return stepSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(stepSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterSliderControl)) {
            return false;
        }
        ParameterSliderControl other = (ParameterSliderControl) obj;
        return Objects.equals(parameterControlId(), other.parameterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(displayOptions(), other.displayOptions())
                && Objects.equals(maximumValue(), other.maximumValue()) && Objects.equals(minimumValue(), other.minimumValue())
                && Objects.equals(stepSize(), other.stepSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterSliderControl").add("ParameterControlId", parameterControlId()).add("Title", title())
                .add("SourceParameterName", sourceParameterName()).add("DisplayOptions", displayOptions())
                .add("MaximumValue", maximumValue()).add("MinimumValue", minimumValue()).add("StepSize", stepSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterControlId":
            return Optional.ofNullable(clazz.cast(parameterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "MaximumValue":
            return Optional.ofNullable(clazz.cast(maximumValue()));
        case "MinimumValue":
            return Optional.ofNullable(clazz.cast(minimumValue()));
        case "StepSize":
            return Optional.ofNullable(clazz.cast(stepSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterSliderControl, T> g) {
        return obj -> g.apply((ParameterSliderControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterSliderControl> {
        /**
         * <p>
         * The ID of the <code>ParameterSliderControl</code>.
         * </p>
         * 
         * @param parameterControlId
         *        The ID of the <code>ParameterSliderControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControlId(String parameterControlId);

        /**
         * <p>
         * The title of the <code>ParameterSliderControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>ParameterSliderControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source parameter name of the <code>ParameterSliderControl</code>.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the <code>ParameterSliderControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(SliderControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link SliderControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link SliderControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SliderControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(SliderControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link SliderControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(SliderControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<SliderControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(SliderControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The smaller value that is displayed at the left of the slider.
         * </p>
         * 
         * @param maximumValue
         *        The smaller value that is displayed at the left of the slider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumValue(Double maximumValue);

        /**
         * <p>
         * The larger value that is displayed at the right of the slider.
         * </p>
         * 
         * @param minimumValue
         *        The larger value that is displayed at the right of the slider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumValue(Double minimumValue);

        /**
         * <p>
         * The number of increments that the slider bar is divided into.
         * </p>
         * 
         * @param stepSize
         *        The number of increments that the slider bar is divided into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepSize(Double stepSize);
    }

    static final class BuilderImpl implements Builder {
        private String parameterControlId;

        private String title;

        private String sourceParameterName;

        private SliderControlDisplayOptions displayOptions;

        private Double maximumValue;

        private Double minimumValue;

        private Double stepSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterSliderControl model) {
            parameterControlId(model.parameterControlId);
            title(model.title);
            sourceParameterName(model.sourceParameterName);
            displayOptions(model.displayOptions);
            maximumValue(model.maximumValue);
            minimumValue(model.minimumValue);
            stepSize(model.stepSize);
        }

        public final String getParameterControlId() {
            return parameterControlId;
        }

        public final void setParameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
        }

        @Override
        public final Builder parameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final SliderControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(SliderControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(SliderControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final Double getMaximumValue() {
            return maximumValue;
        }

        public final void setMaximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Double getMinimumValue() {
            return minimumValue;
        }

        public final void setMinimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Double getStepSize() {
            return stepSize;
        }

        public final void setStepSize(Double stepSize) {
            this.stepSize = stepSize;
        }

        @Override
        public final Builder stepSize(Double stepSize) {
            this.stepSize = stepSize;
            return this;
        }

        @Override
        public ParameterSliderControl build() {
            return new ParameterSliderControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
