/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateVersionSummary;

public class ListTemplateVersionsIterable
implements SdkIterable<ListTemplateVersionsResponse> {
    private final QuickSightClient client;
    private final ListTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateVersionsIterable(QuickSightClient client, ListTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTemplateVersionsResponseFetcher();
    }

    public Iterator<ListTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateVersionSummary> templateVersionSummaryList() {
        Function<ListTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateVersionSummaryList() != null) {
                return response.templateVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateVersionsResponseFetcher
    implements SyncPageFetcher<ListTemplateVersionsResponse> {
        private ListTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateVersionsResponse nextPage(ListTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateVersionsIterable.this.client.listTemplateVersions(ListTemplateVersionsIterable.this.firstRequest);
            }
            return ListTemplateVersionsIterable.this.client.listTemplateVersions((ListTemplateVersionsRequest)((Object)ListTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

