/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ExceptionResourceType;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LimitExceededException
extends QuickSightException
implements ToCopyableBuilder<Builder, LimitExceededException> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(LimitExceededException.getter(LimitExceededException::resourceTypeAsString)).setter(LimitExceededException.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> QUICKSIGHT_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quicksightRequestId").getter(LimitExceededException.getter(LimitExceededException::quicksightRequestId)).setter(LimitExceededException.setter(Builder::quicksightRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, QUICKSIGHT_REQUEST_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String quicksightRequestId;

    private LimitExceededException(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.quicksightRequestId = builder.quicksightRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ExceptionResourceType resourceType() {
        return ExceptionResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String quicksightRequestId() {
        return this.quicksightRequestId;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LimitExceededException, T> g) {
        return obj -> g.apply((LimitExceededException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightException.BuilderImpl
    implements Builder {
        private String resourceType;
        private String quicksightRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitExceededException model) {
            super(model);
            this.resourceType(model.resourceType);
            this.quicksightRequestId(model.quicksightRequestId);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ExceptionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getQuicksightRequestId() {
            return this.quicksightRequestId;
        }

        public final void setQuicksightRequestId(String quicksightRequestId) {
            this.quicksightRequestId = quicksightRequestId;
        }

        @Override
        @Transient
        public final Builder quicksightRequestId(String quicksightRequestId) {
            this.quicksightRequestId = quicksightRequestId;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public LimitExceededException build() {
            return new LimitExceededException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LimitExceededException>,
    QuickSightException.Builder {
        public Builder resourceType(String var1);

        public Builder resourceType(ExceptionResourceType var1);

        public Builder quicksightRequestId(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

