/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FolderMemberListCopier;
import software.amazon.awssdk.services.quicksight.model.MemberIdArnPair;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFolderMembersResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListFolderMembersResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListFolderMembersResponse.getter(ListFolderMembersResponse::status)).setter(ListFolderMembersResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<List<MemberIdArnPair>> FOLDER_MEMBER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderMemberList").getter(ListFolderMembersResponse.getter(ListFolderMembersResponse::folderMemberList)).setter(ListFolderMembersResponse.setter(Builder::folderMemberList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderMemberList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberIdArnPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFolderMembersResponse.getter(ListFolderMembersResponse::nextToken)).setter(ListFolderMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListFolderMembersResponse.getter(ListFolderMembersResponse::requestId)).setter(ListFolderMembersResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FOLDER_MEMBER_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final List<MemberIdArnPair> folderMemberList;
    private final String nextToken;
    private final String requestId;

    private ListFolderMembersResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folderMemberList = builder.folderMemberList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final boolean hasFolderMemberList() {
        return this.folderMemberList != null && !(this.folderMemberList instanceof SdkAutoConstructList);
    }

    public final List<MemberIdArnPair> folderMemberList() {
        return this.folderMemberList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderMemberList() ? this.folderMemberList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFolderMembersResponse)) {
            return false;
        }
        ListFolderMembersResponse other = (ListFolderMembersResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasFolderMemberList() == other.hasFolderMemberList() && Objects.equals(this.folderMemberList(), other.folderMemberList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListFolderMembersResponse").add("Status", (Object)this.status()).add("FolderMemberList", this.hasFolderMemberList() ? this.folderMemberList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FolderMemberList": {
                return Optional.ofNullable(clazz.cast(this.folderMemberList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFolderMembersResponse, T> g) {
        return obj -> g.apply((ListFolderMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private List<MemberIdArnPair> folderMemberList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFolderMembersResponse model) {
            super(model);
            this.status(model.status);
            this.folderMemberList(model.folderMemberList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final List<MemberIdArnPair.Builder> getFolderMemberList() {
            List<MemberIdArnPair.Builder> result = FolderMemberListCopier.copyToBuilder(this.folderMemberList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder folderMemberList(Collection<MemberIdArnPair> folderMemberList) {
            this.folderMemberList = FolderMemberListCopier.copy(folderMemberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderMemberList(MemberIdArnPair ... folderMemberList) {
            this.folderMemberList(Arrays.asList(folderMemberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderMemberList(Consumer<MemberIdArnPair.Builder> ... folderMemberList) {
            this.folderMemberList(Stream.of(folderMemberList).map(c -> (MemberIdArnPair)((MemberIdArnPair.Builder)MemberIdArnPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFolderMemberList(Collection<MemberIdArnPair.BuilderImpl> folderMemberList) {
            this.folderMemberList = FolderMemberListCopier.copyFromBuilder(folderMemberList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public ListFolderMembersResponse build() {
            return new ListFolderMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFolderMembersResponse> {
        public Builder status(Integer var1);

        public Builder folderMemberList(Collection<MemberIdArnPair> var1);

        public Builder folderMemberList(MemberIdArnPair ... var1);

        public Builder folderMemberList(Consumer<MemberIdArnPair.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);
    }
}

