/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EmbeddingIdentityType {
    IAM("IAM"),
    QUICKSIGHT("QUICKSIGHT"),
    ANONYMOUS("ANONYMOUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EmbeddingIdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EmbeddingIdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EmbeddingIdentityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EmbeddingIdentityType> knownValues() {
        return Stream.of(EmbeddingIdentityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

