/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputColumnDataType {
    STRING("STRING"),
    INTEGER("INTEGER"),
    DECIMAL("DECIMAL"),
    DATETIME("DATETIME"),
    BIT("BIT"),
    BOOLEAN("BOOLEAN"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputColumnDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputColumnDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputColumnDataType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputColumnDataType> knownValues() {
        return Stream.of(InputColumnDataType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

