/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TileLayoutStyle;
import software.amazon.awssdk.services.quicksight.model.TileStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetStyle> {
    private static final SdkField<TileStyle> TILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SheetStyle.getter(SheetStyle::tile)).setter(SheetStyle.setter(Builder::tile)).constructor(TileStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tile").build()}).build();
    private static final SdkField<TileLayoutStyle> TILE_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SheetStyle.getter(SheetStyle::tileLayout)).setter(SheetStyle.setter(Builder::tileLayout)).constructor(TileLayoutStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileLayout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TILE_FIELD, TILE_LAYOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final TileStyle tile;
    private final TileLayoutStyle tileLayout;

    private SheetStyle(BuilderImpl builder) {
        this.tile = builder.tile;
        this.tileLayout = builder.tileLayout;
    }

    public TileStyle tile() {
        return this.tile;
    }

    public TileLayoutStyle tileLayout() {
        return this.tileLayout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tile());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileLayout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetStyle)) {
            return false;
        }
        SheetStyle other = (SheetStyle)obj;
        return Objects.equals(this.tile(), other.tile()) && Objects.equals(this.tileLayout(), other.tileLayout());
    }

    public String toString() {
        return ToString.builder((String)"SheetStyle").add("Tile", (Object)this.tile()).add("TileLayout", (Object)this.tileLayout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tile": {
                return Optional.ofNullable(clazz.cast(this.tile()));
            }
            case "TileLayout": {
                return Optional.ofNullable(clazz.cast(this.tileLayout()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SheetStyle, T> g) {
        return obj -> g.apply((SheetStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TileStyle tile;
        private TileLayoutStyle tileLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetStyle model) {
            this.tile(model.tile);
            this.tileLayout(model.tileLayout);
        }

        public final TileStyle.Builder getTile() {
            return this.tile != null ? this.tile.toBuilder() : null;
        }

        @Override
        public final Builder tile(TileStyle tile) {
            this.tile = tile;
            return this;
        }

        public final void setTile(TileStyle.BuilderImpl tile) {
            this.tile = tile != null ? tile.build() : null;
        }

        public final TileLayoutStyle.Builder getTileLayout() {
            return this.tileLayout != null ? this.tileLayout.toBuilder() : null;
        }

        @Override
        public final Builder tileLayout(TileLayoutStyle tileLayout) {
            this.tileLayout = tileLayout;
            return this;
        }

        public final void setTileLayout(TileLayoutStyle.BuilderImpl tileLayout) {
            this.tileLayout = tileLayout != null ? tileLayout.build() : null;
        }

        public SheetStyle build() {
            return new SheetStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetStyle> {
        public Builder tile(TileStyle var1);

        default public Builder tile(Consumer<TileStyle.Builder> tile) {
            return this.tile((TileStyle)((TileStyle.Builder)TileStyle.builder().applyMutation(tile)).build());
        }

        public Builder tileLayout(TileLayoutStyle var1);

        default public Builder tileLayout(Consumer<TileLayoutStyle.Builder> tileLayout) {
            return this.tileLayout((TileLayoutStyle)((TileLayoutStyle.Builder)TileLayoutStyle.builder().applyMutation(tileLayout)).build());
        }
    }
}

