/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldbsession.model.AbortTransactionRequest;
import software.amazon.awssdk.services.qldbsession.model.CommitTransactionRequest;
import software.amazon.awssdk.services.qldbsession.model.EndSessionRequest;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.qldbsession.model.FetchPageRequest;
import software.amazon.awssdk.services.qldbsession.model.QldbSessionRequest;
import software.amazon.awssdk.services.qldbsession.model.StartSessionRequest;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendCommandRequest
extends QldbSessionRequest
implements ToCopyableBuilder<Builder, SendCommandRequest> {
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionToken").getter(SendCommandRequest.getter(SendCommandRequest::sessionToken)).setter(SendCommandRequest.setter(Builder::sessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionToken").build()}).build();
    private static final SdkField<StartSessionRequest> START_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartSession").getter(SendCommandRequest.getter(SendCommandRequest::startSession)).setter(SendCommandRequest.setter(Builder::startSession)).constructor(StartSessionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSession").build()}).build();
    private static final SdkField<StartTransactionRequest> START_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTransaction").getter(SendCommandRequest.getter(SendCommandRequest::startTransaction)).setter(SendCommandRequest.setter(Builder::startTransaction)).constructor(StartTransactionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTransaction").build()}).build();
    private static final SdkField<EndSessionRequest> END_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndSession").getter(SendCommandRequest.getter(SendCommandRequest::endSession)).setter(SendCommandRequest.setter(Builder::endSession)).constructor(EndSessionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndSession").build()}).build();
    private static final SdkField<CommitTransactionRequest> COMMIT_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommitTransaction").getter(SendCommandRequest.getter(SendCommandRequest::commitTransaction)).setter(SendCommandRequest.setter(Builder::commitTransaction)).constructor(CommitTransactionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitTransaction").build()}).build();
    private static final SdkField<AbortTransactionRequest> ABORT_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbortTransaction").getter(SendCommandRequest.getter(SendCommandRequest::abortTransaction)).setter(SendCommandRequest.setter(Builder::abortTransaction)).constructor(AbortTransactionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortTransaction").build()}).build();
    private static final SdkField<ExecuteStatementRequest> EXECUTE_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecuteStatement").getter(SendCommandRequest.getter(SendCommandRequest::executeStatement)).setter(SendCommandRequest.setter(Builder::executeStatement)).constructor(ExecuteStatementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteStatement").build()}).build();
    private static final SdkField<FetchPageRequest> FETCH_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FetchPage").getter(SendCommandRequest.getter(SendCommandRequest::fetchPage)).setter(SendCommandRequest.setter(Builder::fetchPage)).constructor(FetchPageRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FetchPage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_TOKEN_FIELD, START_SESSION_FIELD, START_TRANSACTION_FIELD, END_SESSION_FIELD, COMMIT_TRANSACTION_FIELD, ABORT_TRANSACTION_FIELD, EXECUTE_STATEMENT_FIELD, FETCH_PAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendCommandRequest.memberNameToFieldInitializer();
    private final String sessionToken;
    private final StartSessionRequest startSession;
    private final StartTransactionRequest startTransaction;
    private final EndSessionRequest endSession;
    private final CommitTransactionRequest commitTransaction;
    private final AbortTransactionRequest abortTransaction;
    private final ExecuteStatementRequest executeStatement;
    private final FetchPageRequest fetchPage;

    private SendCommandRequest(BuilderImpl builder) {
        super(builder);
        this.sessionToken = builder.sessionToken;
        this.startSession = builder.startSession;
        this.startTransaction = builder.startTransaction;
        this.endSession = builder.endSession;
        this.commitTransaction = builder.commitTransaction;
        this.abortTransaction = builder.abortTransaction;
        this.executeStatement = builder.executeStatement;
        this.fetchPage = builder.fetchPage;
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    public final StartSessionRequest startSession() {
        return this.startSession;
    }

    public final StartTransactionRequest startTransaction() {
        return this.startTransaction;
    }

    public final EndSessionRequest endSession() {
        return this.endSession;
    }

    public final CommitTransactionRequest commitTransaction() {
        return this.commitTransaction;
    }

    public final AbortTransactionRequest abortTransaction() {
        return this.abortTransaction;
    }

    public final ExecuteStatementRequest executeStatement() {
        return this.executeStatement;
    }

    public final FetchPageRequest fetchPage() {
        return this.fetchPage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.fetchPage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest)((Object)obj);
        return Objects.equals(this.sessionToken(), other.sessionToken()) && Objects.equals(this.startSession(), other.startSession()) && Objects.equals(this.startTransaction(), other.startTransaction()) && Objects.equals(this.endSession(), other.endSession()) && Objects.equals(this.commitTransaction(), other.commitTransaction()) && Objects.equals(this.abortTransaction(), other.abortTransaction()) && Objects.equals(this.executeStatement(), other.executeStatement()) && Objects.equals(this.fetchPage(), other.fetchPage());
    }

    public final String toString() {
        return ToString.builder((String)"SendCommandRequest").add("SessionToken", (Object)this.sessionToken()).add("StartSession", (Object)this.startSession()).add("StartTransaction", (Object)this.startTransaction()).add("EndSession", (Object)this.endSession()).add("CommitTransaction", (Object)this.commitTransaction()).add("AbortTransaction", (Object)this.abortTransaction()).add("ExecuteStatement", (Object)this.executeStatement()).add("FetchPage", (Object)this.fetchPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
            case "StartSession": {
                return Optional.ofNullable(clazz.cast(this.startSession()));
            }
            case "StartTransaction": {
                return Optional.ofNullable(clazz.cast(this.startTransaction()));
            }
            case "EndSession": {
                return Optional.ofNullable(clazz.cast(this.endSession()));
            }
            case "CommitTransaction": {
                return Optional.ofNullable(clazz.cast(this.commitTransaction()));
            }
            case "AbortTransaction": {
                return Optional.ofNullable(clazz.cast(this.abortTransaction()));
            }
            case "ExecuteStatement": {
                return Optional.ofNullable(clazz.cast(this.executeStatement()));
            }
            case "FetchPage": {
                return Optional.ofNullable(clazz.cast(this.fetchPage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionToken", SESSION_TOKEN_FIELD);
        map.put("StartSession", START_SESSION_FIELD);
        map.put("StartTransaction", START_TRANSACTION_FIELD);
        map.put("EndSession", END_SESSION_FIELD);
        map.put("CommitTransaction", COMMIT_TRANSACTION_FIELD);
        map.put("AbortTransaction", ABORT_TRANSACTION_FIELD);
        map.put("ExecuteStatement", EXECUTE_STATEMENT_FIELD);
        map.put("FetchPage", FETCH_PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendCommandRequest, T> g) {
        return obj -> g.apply((SendCommandRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbSessionRequest.BuilderImpl
    implements Builder {
        private String sessionToken;
        private StartSessionRequest startSession;
        private StartTransactionRequest startTransaction;
        private EndSessionRequest endSession;
        private CommitTransactionRequest commitTransaction;
        private AbortTransactionRequest abortTransaction;
        private ExecuteStatementRequest executeStatement;
        private FetchPageRequest fetchPage;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            super(model);
            this.sessionToken(model.sessionToken);
            this.startSession(model.startSession);
            this.startTransaction(model.startTransaction);
            this.endSession(model.endSession);
            this.commitTransaction(model.commitTransaction);
            this.abortTransaction(model.abortTransaction);
            this.executeStatement(model.executeStatement);
            this.fetchPage(model.fetchPage);
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final StartSessionRequest.Builder getStartSession() {
            return this.startSession != null ? this.startSession.toBuilder() : null;
        }

        public final void setStartSession(StartSessionRequest.BuilderImpl startSession) {
            this.startSession = startSession != null ? startSession.build() : null;
        }

        @Override
        public final Builder startSession(StartSessionRequest startSession) {
            this.startSession = startSession;
            return this;
        }

        public final StartTransactionRequest.Builder getStartTransaction() {
            return this.startTransaction != null ? this.startTransaction.toBuilder() : null;
        }

        public final void setStartTransaction(StartTransactionRequest.BuilderImpl startTransaction) {
            this.startTransaction = startTransaction != null ? startTransaction.build() : null;
        }

        @Override
        public final Builder startTransaction(StartTransactionRequest startTransaction) {
            this.startTransaction = startTransaction;
            return this;
        }

        public final EndSessionRequest.Builder getEndSession() {
            return this.endSession != null ? this.endSession.toBuilder() : null;
        }

        public final void setEndSession(EndSessionRequest.BuilderImpl endSession) {
            this.endSession = endSession != null ? endSession.build() : null;
        }

        @Override
        public final Builder endSession(EndSessionRequest endSession) {
            this.endSession = endSession;
            return this;
        }

        public final CommitTransactionRequest.Builder getCommitTransaction() {
            return this.commitTransaction != null ? this.commitTransaction.toBuilder() : null;
        }

        public final void setCommitTransaction(CommitTransactionRequest.BuilderImpl commitTransaction) {
            this.commitTransaction = commitTransaction != null ? commitTransaction.build() : null;
        }

        @Override
        public final Builder commitTransaction(CommitTransactionRequest commitTransaction) {
            this.commitTransaction = commitTransaction;
            return this;
        }

        public final AbortTransactionRequest.Builder getAbortTransaction() {
            return this.abortTransaction != null ? this.abortTransaction.toBuilder() : null;
        }

        public final void setAbortTransaction(AbortTransactionRequest.BuilderImpl abortTransaction) {
            this.abortTransaction = abortTransaction != null ? abortTransaction.build() : null;
        }

        @Override
        public final Builder abortTransaction(AbortTransactionRequest abortTransaction) {
            this.abortTransaction = abortTransaction;
            return this;
        }

        public final ExecuteStatementRequest.Builder getExecuteStatement() {
            return this.executeStatement != null ? this.executeStatement.toBuilder() : null;
        }

        public final void setExecuteStatement(ExecuteStatementRequest.BuilderImpl executeStatement) {
            this.executeStatement = executeStatement != null ? executeStatement.build() : null;
        }

        @Override
        public final Builder executeStatement(ExecuteStatementRequest executeStatement) {
            this.executeStatement = executeStatement;
            return this;
        }

        public final FetchPageRequest.Builder getFetchPage() {
            return this.fetchPage != null ? this.fetchPage.toBuilder() : null;
        }

        public final void setFetchPage(FetchPageRequest.BuilderImpl fetchPage) {
            this.fetchPage = fetchPage != null ? fetchPage.build() : null;
        }

        @Override
        public final Builder fetchPage(FetchPageRequest fetchPage) {
            this.fetchPage = fetchPage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QldbSessionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendCommandRequest> {
        public Builder sessionToken(String var1);

        public Builder startSession(StartSessionRequest var1);

        default public Builder startSession(Consumer<StartSessionRequest.Builder> startSession) {
            return this.startSession((StartSessionRequest)((StartSessionRequest.Builder)StartSessionRequest.builder().applyMutation(startSession)).build());
        }

        public Builder startTransaction(StartTransactionRequest var1);

        default public Builder startTransaction(Consumer<StartTransactionRequest.Builder> startTransaction) {
            return this.startTransaction((StartTransactionRequest)((StartTransactionRequest.Builder)StartTransactionRequest.builder().applyMutation(startTransaction)).build());
        }

        public Builder endSession(EndSessionRequest var1);

        default public Builder endSession(Consumer<EndSessionRequest.Builder> endSession) {
            return this.endSession((EndSessionRequest)((EndSessionRequest.Builder)EndSessionRequest.builder().applyMutation(endSession)).build());
        }

        public Builder commitTransaction(CommitTransactionRequest var1);

        default public Builder commitTransaction(Consumer<CommitTransactionRequest.Builder> commitTransaction) {
            return this.commitTransaction((CommitTransactionRequest)((CommitTransactionRequest.Builder)CommitTransactionRequest.builder().applyMutation(commitTransaction)).build());
        }

        public Builder abortTransaction(AbortTransactionRequest var1);

        default public Builder abortTransaction(Consumer<AbortTransactionRequest.Builder> abortTransaction) {
            return this.abortTransaction((AbortTransactionRequest)((AbortTransactionRequest.Builder)AbortTransactionRequest.builder().applyMutation(abortTransaction)).build());
        }

        public Builder executeStatement(ExecuteStatementRequest var1);

        default public Builder executeStatement(Consumer<ExecuteStatementRequest.Builder> executeStatement) {
            return this.executeStatement((ExecuteStatementRequest)((ExecuteStatementRequest.Builder)ExecuteStatementRequest.builder().applyMutation(executeStatement)).build());
        }

        public Builder fetchPage(FetchPageRequest var1);

        default public Builder fetchPage(Consumer<FetchPageRequest.Builder> fetchPage) {
            return this.fetchPage((FetchPageRequest)((FetchPageRequest.Builder)FetchPageRequest.builder().applyMutation(fetchPage)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

