/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldbsession.model.IOUsage;
import software.amazon.awssdk.services.qldbsession.model.TimingInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitTransactionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommitTransactionResult> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(CommitTransactionResult.getter(CommitTransactionResult::transactionId)).setter(CommitTransactionResult.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<SdkBytes> COMMIT_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CommitDigest").getter(CommitTransactionResult.getter(CommitTransactionResult::commitDigest)).setter(CommitTransactionResult.setter(Builder::commitDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDigest").build()}).build();
    private static final SdkField<TimingInformation> TIMING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimingInformation").getter(CommitTransactionResult.getter(CommitTransactionResult::timingInformation)).setter(CommitTransactionResult.setter(Builder::timingInformation)).constructor(TimingInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingInformation").build()}).build();
    private static final SdkField<IOUsage> CONSUMED_I_OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumedIOs").getter(CommitTransactionResult.getter(CommitTransactionResult::consumedIOs)).setter(CommitTransactionResult.setter(Builder::consumedIOs)).constructor(IOUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedIOs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD, COMMIT_DIGEST_FIELD, TIMING_INFORMATION_FIELD, CONSUMED_I_OS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transactionId;
    private final SdkBytes commitDigest;
    private final TimingInformation timingInformation;
    private final IOUsage consumedIOs;

    private CommitTransactionResult(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.commitDigest = builder.commitDigest;
        this.timingInformation = builder.timingInformation;
        this.consumedIOs = builder.consumedIOs;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final SdkBytes commitDigest() {
        return this.commitDigest;
    }

    public final TimingInformation timingInformation() {
        return this.timingInformation;
    }

    public final IOUsage consumedIOs() {
        return this.consumedIOs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.timingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedIOs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionResult)) {
            return false;
        }
        CommitTransactionResult other = (CommitTransactionResult)obj;
        return Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.commitDigest(), other.commitDigest()) && Objects.equals(this.timingInformation(), other.timingInformation()) && Objects.equals(this.consumedIOs(), other.consumedIOs());
    }

    public final String toString() {
        return ToString.builder((String)"CommitTransactionResult").add("TransactionId", (Object)this.transactionId()).add("CommitDigest", (Object)this.commitDigest()).add("TimingInformation", (Object)this.timingInformation()).add("ConsumedIOs", (Object)this.consumedIOs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "CommitDigest": {
                return Optional.ofNullable(clazz.cast(this.commitDigest()));
            }
            case "TimingInformation": {
                return Optional.ofNullable(clazz.cast(this.timingInformation()));
            }
            case "ConsumedIOs": {
                return Optional.ofNullable(clazz.cast(this.consumedIOs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionResult, T> g) {
        return obj -> g.apply((CommitTransactionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionId;
        private SdkBytes commitDigest;
        private TimingInformation timingInformation;
        private IOUsage consumedIOs;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionResult model) {
            this.transactionId(model.transactionId);
            this.commitDigest(model.commitDigest);
            this.timingInformation(model.timingInformation);
            this.consumedIOs(model.consumedIOs);
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final ByteBuffer getCommitDigest() {
            return this.commitDigest == null ? null : this.commitDigest.asByteBuffer();
        }

        @Override
        public final Builder commitDigest(SdkBytes commitDigest) {
            this.commitDigest = StandardMemberCopier.copy((SdkBytes)commitDigest);
            return this;
        }

        public final void setCommitDigest(ByteBuffer commitDigest) {
            this.commitDigest(commitDigest == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)commitDigest));
        }

        public final TimingInformation.Builder getTimingInformation() {
            return this.timingInformation != null ? this.timingInformation.toBuilder() : null;
        }

        @Override
        public final Builder timingInformation(TimingInformation timingInformation) {
            this.timingInformation = timingInformation;
            return this;
        }

        public final void setTimingInformation(TimingInformation.BuilderImpl timingInformation) {
            this.timingInformation = timingInformation != null ? timingInformation.build() : null;
        }

        public final IOUsage.Builder getConsumedIOs() {
            return this.consumedIOs != null ? this.consumedIOs.toBuilder() : null;
        }

        @Override
        public final Builder consumedIOs(IOUsage consumedIOs) {
            this.consumedIOs = consumedIOs;
            return this;
        }

        public final void setConsumedIOs(IOUsage.BuilderImpl consumedIOs) {
            this.consumedIOs = consumedIOs != null ? consumedIOs.build() : null;
        }

        public CommitTransactionResult build() {
            return new CommitTransactionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommitTransactionResult> {
        public Builder transactionId(String var1);

        public Builder commitDigest(SdkBytes var1);

        public Builder timingInformation(TimingInformation var1);

        default public Builder timingInformation(Consumer<TimingInformation.Builder> timingInformation) {
            return this.timingInformation((TimingInformation)((TimingInformation.Builder)TimingInformation.builder().applyMutation(timingInformation)).build());
        }

        public Builder consumedIOs(IOUsage var1);

        default public Builder consumedIOs(Consumer<IOUsage.Builder> consumedIOs) {
            return this.consumedIOs((IOUsage)((IOUsage.Builder)IOUsage.builder().applyMutation(consumedIOs)).build());
        }
    }
}

