/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qldbsession.model.StatementParametersCopier;
import software.amazon.awssdk.services.qldbsession.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecuteStatementRequest> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::transactionId)).setter(ExecuteStatementRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<String> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statement").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::statement)).setter(ExecuteStatementRequest.setter(Builder::statement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()}).build();
    private static final SdkField<List<ValueHolder>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::parameters)).setter(ExecuteStatementRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD, STATEMENT_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transactionId;
    private final String statement;
    private final List<ValueHolder> parameters;

    private ExecuteStatementRequest(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.statement = builder.statement;
        this.parameters = builder.parameters;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final String statement() {
        return this.statement;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ValueHolder> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)obj;
        return Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.statement(), other.statement()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteStatementRequest").add("TransactionId", (Object)this.transactionId()).add("Statement", (Object)this.statement()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "Statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionId;
        private String statement;
        private List<ValueHolder> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            this.transactionId(model.transactionId);
            this.statement(model.statement);
            this.parameters(model.parameters);
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final String getStatement() {
            return this.statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        public final Collection<ValueHolder.Builder> getParameters() {
            if (this.parameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parameters != null ? (Collection)this.parameters.stream().map(ValueHolder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ValueHolder> parameters) {
            this.parameters = StatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ValueHolder ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ValueHolder.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<ValueHolder.BuilderImpl> parameters) {
            this.parameters = StatementParametersCopier.copyFromBuilder(parameters);
        }

        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementRequest> {
        public Builder transactionId(String var1);

        public Builder statement(String var1);

        public Builder parameters(Collection<ValueHolder> var1);

        public Builder parameters(ValueHolder ... var1);

        public Builder parameters(Consumer<ValueHolder.Builder> ... var1);
    }
}

