/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.services.qldb.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRevisionResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, GetRevisionResponse> {
    private static final SdkField<ValueHolder> PROOF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Proof").getter(GetRevisionResponse.getter(GetRevisionResponse::proof)).setter(GetRevisionResponse.setter(Builder::proof)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proof").build()}).build();
    private static final SdkField<ValueHolder> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Revision").getter(GetRevisionResponse.getter(GetRevisionResponse::revision)).setter(GetRevisionResponse.setter(Builder::revision)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROOF_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRevisionResponse.memberNameToFieldInitializer();
    private final ValueHolder proof;
    private final ValueHolder revision;

    private GetRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.proof = builder.proof;
        this.revision = builder.revision;
    }

    public final ValueHolder proof() {
        return this.proof;
    }

    public final ValueHolder revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proof());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevisionResponse)) {
            return false;
        }
        GetRevisionResponse other = (GetRevisionResponse)((Object)obj);
        return Objects.equals(this.proof(), other.proof()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"GetRevisionResponse").add("Proof", (Object)(this.proof() == null ? null : "*** Sensitive Data Redacted ***")).add("Revision", (Object)(this.revision() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Proof": {
                return Optional.ofNullable(clazz.cast(this.proof()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ValueHolder>> map = new HashMap<String, SdkField<ValueHolder>>();
        map.put("Proof", PROOF_FIELD);
        map.put("Revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRevisionResponse, T> g) {
        return obj -> g.apply((GetRevisionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private ValueHolder proof;
        private ValueHolder revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevisionResponse model) {
            super(model);
            this.proof(model.proof);
            this.revision(model.revision);
        }

        public final ValueHolder.Builder getProof() {
            return this.proof != null ? this.proof.toBuilder() : null;
        }

        public final void setProof(ValueHolder.BuilderImpl proof) {
            this.proof = proof != null ? proof.build() : null;
        }

        @Override
        public final Builder proof(ValueHolder proof) {
            this.proof = proof;
            return this;
        }

        public final ValueHolder.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        public final void setRevision(ValueHolder.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(ValueHolder revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public GetRevisionResponse build() {
            return new GetRevisionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRevisionResponse> {
        public Builder proof(ValueHolder var1);

        default public Builder proof(Consumer<ValueHolder.Builder> proof) {
            return this.proof((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(proof)).build());
        }

        public Builder revision(ValueHolder var1);

        default public Builder revision(Consumer<ValueHolder.Builder> revision) {
            return this.revision((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(revision)).build());
        }
    }
}

