/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJournalToS3Request extends QldbRequest implements
        ToCopyableBuilder<ExportJournalToS3Request.Builder, ExportJournalToS3Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJournalToS3Request::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExportJournalToS3Request::inclusiveStartTime)).setter(setter(Builder::inclusiveStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build())
            .build();

    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExportJournalToS3Request::exclusiveEndTime)).setter(setter(Builder::exclusiveEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()).build();

    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField
            .<S3ExportConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportJournalToS3Request::s3ExportConfiguration)).setter(setter(Builder::s3ExportConfiguration))
            .constructor(S3ExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJournalToS3Request::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, S3_EXPORT_CONFIGURATION_FIELD, ROLE_ARN_FIELD));

    private final String name;

    private final Instant inclusiveStartTime;

    private final Instant exclusiveEndTime;

    private final S3ExportConfiguration s3ExportConfiguration;

    private final String roleArn;

    private ExportJournalToS3Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The inclusive start date and time for the range of journal contents that you want to export.
     * </p>
     * <p>
     * The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
     * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     * </p>
     * <p>
     * The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.
     * </p>
     * <p>
     * If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>,
     * Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.
     * </p>
     * 
     * @return The inclusive start date and time for the range of journal contents that you want to export.</p>
     *         <p>
     *         The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in
     *         Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     *         </p>
     *         <p>
     *         The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.
     *         </p>
     *         <p>
     *         If you provide an <code>InclusiveStartTime</code> that is before the ledger's
     *         <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.
     */
    public Instant inclusiveStartTime() {
        return inclusiveStartTime;
    }

    /**
     * <p>
     * The exclusive end date and time for the range of journal contents that you want to export.
     * </p>
     * <p>
     * The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
     * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     * </p>
     * <p>
     * The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.
     * </p>
     * 
     * @return The exclusive end date and time for the range of journal contents that you want to export.</p>
     *         <p>
     *         The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
     *         Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     *         </p>
     *         <p>
     *         The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.
     */
    public Instant exclusiveEndTime() {
        return exclusiveEndTime;
    }

    /**
     * <p>
     * The configuration settings of the Amazon S3 bucket destination for your export request.
     * </p>
     * 
     * @return The configuration settings of the Amazon S3 bucket destination for your export request.
     */
    public S3ExportConfiguration s3ExportConfiguration() {
        return s3ExportConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side encryption
     * of your exported data.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to
     *         do the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
     *         encryption of your exported data.
     *         </p>
     *         </li>
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJournalToS3Request)) {
            return false;
        }
        ExportJournalToS3Request other = (ExportJournalToS3Request) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(inclusiveStartTime(), other.inclusiveStartTime())
                && Objects.equals(exclusiveEndTime(), other.exclusiveEndTime())
                && Objects.equals(s3ExportConfiguration(), other.s3ExportConfiguration())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportJournalToS3Request").add("Name", name()).add("InclusiveStartTime", inclusiveStartTime())
                .add("ExclusiveEndTime", exclusiveEndTime()).add("S3ExportConfiguration", s3ExportConfiguration())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InclusiveStartTime":
            return Optional.ofNullable(clazz.cast(inclusiveStartTime()));
        case "ExclusiveEndTime":
            return Optional.ofNullable(clazz.cast(exclusiveEndTime()));
        case "S3ExportConfiguration":
            return Optional.ofNullable(clazz.cast(s3ExportConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJournalToS3Request, T> g) {
        return obj -> g.apply((ExportJournalToS3Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExportJournalToS3Request> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The inclusive start date and time for the range of journal contents that you want to export.
         * </p>
         * <p>
         * The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
         * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         * </p>
         * <p>
         * The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.
         * </p>
         * <p>
         * If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>,
         * Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.
         * </p>
         * 
         * @param inclusiveStartTime
         *        The inclusive start date and time for the range of journal contents that you want to export.</p>
         *        <p>
         *        The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in
         *        Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         *        </p>
         *        <p>
         *        The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.
         *        </p>
         *        <p>
         *        If you provide an <code>InclusiveStartTime</code> that is before the ledger's
         *        <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusiveStartTime(Instant inclusiveStartTime);

        /**
         * <p>
         * The exclusive end date and time for the range of journal contents that you want to export.
         * </p>
         * <p>
         * The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
         * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         * </p>
         * <p>
         * The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.
         * </p>
         * 
         * @param exclusiveEndTime
         *        The exclusive end date and time for the range of journal contents that you want to export.</p>
         *        <p>
         *        The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in
         *        Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         *        </p>
         *        <p>
         *        The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveEndTime(Instant exclusiveEndTime);

        /**
         * <p>
         * The configuration settings of the Amazon S3 bucket destination for your export request.
         * </p>
         * 
         * @param s3ExportConfiguration
         *        The configuration settings of the Amazon S3 bucket destination for your export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration);

        /**
         * <p>
         * The configuration settings of the Amazon S3 bucket destination for your export request.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ExportConfiguration.Builder} avoiding the need
         * to create one manually via {@link S3ExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ExportConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ExportConfiguration(S3ExportConfiguration)}.
         * 
         * @param s3ExportConfiguration
         *        a consumer that will call methods on {@link S3ExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportConfiguration(S3ExportConfiguration)
         */
        default Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return s3ExportConfiguration(S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do
         * the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
         * encryption of your exported data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job
         *        to do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
         *        encryption of your exported data.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String name;

        private Instant inclusiveStartTime;

        private Instant exclusiveEndTime;

        private S3ExportConfiguration s3ExportConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJournalToS3Request model) {
            super(model);
            name(model.name);
            inclusiveStartTime(model.inclusiveStartTime);
            exclusiveEndTime(model.exclusiveEndTime);
            s3ExportConfiguration(model.s3ExportConfiguration);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getInclusiveStartTime() {
            return inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        public final Instant getExclusiveEndTime() {
            return exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return s3ExportConfiguration != null ? s3ExportConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportJournalToS3Request build() {
            return new ExportJournalToS3Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
