/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest;
import software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse;
import software.amazon.awssdk.services.qldb.model.CreateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.CreateLedgerResponse;
import software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest;
import software.amazon.awssdk.services.qldb.model.DeleteLedgerResponse;
import software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamRequest;
import software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse;
import software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest;
import software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request;
import software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response;
import software.amazon.awssdk.services.qldb.model.GetBlockRequest;
import software.amazon.awssdk.services.qldb.model.GetBlockResponse;
import software.amazon.awssdk.services.qldb.model.GetDigestRequest;
import software.amazon.awssdk.services.qldb.model.GetDigestResponse;
import software.amazon.awssdk.services.qldb.model.GetRevisionRequest;
import software.amazon.awssdk.services.qldb.model.GetRevisionResponse;
import software.amazon.awssdk.services.qldb.model.InvalidParameterException;
import software.amazon.awssdk.services.qldb.model.LimitExceededException;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse;
import software.amazon.awssdk.services.qldb.model.ListLedgersRequest;
import software.amazon.awssdk.services.qldb.model.ListLedgersResponse;
import software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qldb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qldb.model.QldbException;
import software.amazon.awssdk.services.qldb.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.qldb.model.ResourceInUseException;
import software.amazon.awssdk.services.qldb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qldb.model.ResourcePreconditionNotMetException;
import software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest;
import software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse;
import software.amazon.awssdk.services.qldb.model.TagResourceRequest;
import software.amazon.awssdk.services.qldb.model.TagResourceResponse;
import software.amazon.awssdk.services.qldb.model.UntagResourceRequest;
import software.amazon.awssdk.services.qldb.model.UntagResourceResponse;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerResponse;
import software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable;
import software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable;
import software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable;
import software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable;

/**
 * Service client for accessing QLDB. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The control plane for Amazon QLDB
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QldbClient extends SdkClient {
    String SERVICE_NAME = "qldb";

    /**
     * Create a {@link QldbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QldbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QldbClient}.
     */
    static QldbClientBuilder builder() {
        return new DefaultQldbClientBuilder();
    }

    /**
     * <p>
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be
     * <code>ACTIVE</code>.
     * </p>
     * <p>
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention
     * period, so they are automatically deleted after this limit expires.
     * </p>
     *
     * @param cancelJournalKinesisStreamRequest
     * @return Result of the CancelJournalKinesisStream operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.CancelJournalKinesisStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CancelJournalKinesisStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelJournalKinesisStreamResponse cancelJournalKinesisStream(
            CancelJournalKinesisStreamRequest cancelJournalKinesisStreamRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be
     * <code>ACTIVE</code>.
     * </p>
     * <p>
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention
     * period, so they are automatically deleted after this limit expires.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJournalKinesisStreamRequest.Builder} avoiding
     * the need to create one manually via {@link CancelJournalKinesisStreamRequest#builder()}
     * </p>
     *
     * @param cancelJournalKinesisStreamRequest
     *        A {@link Consumer} that will call methods on {@link CancelJournalKinesisStreamRequest.Builder} to create a
     *        request.
     * @return Result of the CancelJournalKinesisStream operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.CancelJournalKinesisStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CancelJournalKinesisStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelJournalKinesisStreamResponse cancelJournalKinesisStream(
            Consumer<CancelJournalKinesisStreamRequest.Builder> cancelJournalKinesisStreamRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        return cancelJournalKinesisStream(CancelJournalKinesisStreamRequest.builder()
                .applyMutation(cancelJournalKinesisStreamRequest).build());
    }

    /**
     * <p>
     * Creates a new ledger in your AWS account.
     * </p>
     *
     * @param createLedgerRequest
     * @return Result of the CreateLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         You have reached the limit on the maximum number of resources allowed.
     * @throws ResourceInUseException
     *         The specified resource can't be modified at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.CreateLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CreateLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLedgerResponse createLedger(CreateLedgerRequest createLedgerRequest) throws InvalidParameterException,
            ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ledger in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLedgerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLedgerRequest#builder()}
     * </p>
     *
     * @param createLedgerRequest
     *        A {@link Consumer} that will call methods on {@link CreateLedgerRequest.Builder} to create a request.
     * @return Result of the CreateLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         You have reached the limit on the maximum number of resources allowed.
     * @throws ResourceInUseException
     *         The specified resource can't be modified at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.CreateLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CreateLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLedgerResponse createLedger(Consumer<CreateLedgerRequest.Builder> createLedgerRequest)
            throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, QldbException {
        return createLedger(CreateLedgerRequest.builder().applyMutation(createLedgerRequest).build());
    }

    /**
     * <p>
     * Deletes a ledger and all of its contents. This action is irreversible.
     * </p>
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger using the QLDB API
     * or the AWS Command Line Interface (AWS CLI). You can disable it by calling the <code>UpdateLedger</code>
     * operation to set the flag to <code>false</code>. The QLDB console disables deletion protection for you when you
     * use it to delete a ledger.
     * </p>
     *
     * @param deleteLedgerRequest
     * @return Result of the DeleteLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceInUseException
     *         The specified resource can't be modified at this time.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DeleteLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DeleteLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLedgerResponse deleteLedger(DeleteLedgerRequest deleteLedgerRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourceInUseException, ResourcePreconditionNotMetException, AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a ledger and all of its contents. This action is irreversible.
     * </p>
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger using the QLDB API
     * or the AWS Command Line Interface (AWS CLI). You can disable it by calling the <code>UpdateLedger</code>
     * operation to set the flag to <code>false</code>. The QLDB console disables deletion protection for you when you
     * use it to delete a ledger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLedgerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLedgerRequest#builder()}
     * </p>
     *
     * @param deleteLedgerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLedgerRequest.Builder} to create a request.
     * @return Result of the DeleteLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceInUseException
     *         The specified resource can't be modified at this time.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DeleteLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DeleteLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLedgerResponse deleteLedger(Consumer<DeleteLedgerRequest.Builder> deleteLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourceInUseException,
            ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        return deleteLedger(DeleteLedgerRequest.builder().applyMutation(deleteLedgerRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource
     * Name (ARN), stream name, current status, creation time, and the parameters of your original stream creation
     * request.
     * </p>
     *
     * @param describeJournalKinesisStreamRequest
     * @return Result of the DescribeJournalKinesisStream operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeJournalKinesisStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalKinesisStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeJournalKinesisStreamResponse describeJournalKinesisStream(
            DescribeJournalKinesisStreamRequest describeJournalKinesisStreamRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource
     * Name (ARN), stream name, current status, creation time, and the parameters of your original stream creation
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJournalKinesisStreamRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeJournalKinesisStreamRequest#builder()}
     * </p>
     *
     * @param describeJournalKinesisStreamRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJournalKinesisStreamRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeJournalKinesisStream operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeJournalKinesisStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalKinesisStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeJournalKinesisStreamResponse describeJournalKinesisStream(
            Consumer<DescribeJournalKinesisStreamRequest.Builder> describeJournalKinesisStreamRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        return describeJournalKinesisStream(DescribeJournalKinesisStreamRequest.builder()
                .applyMutation(describeJournalKinesisStreamRequest).build());
    }

    /**
     * <p>
     * Returns information about a journal export job, including the ledger name, export ID, when it was created,
     * current status, and its start and end time export parameters.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <p>
     * If the export job with the given <code>ExportId</code> doesn't exist, then throws
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.
     * </p>
     *
     * @param describeJournalS3ExportRequest
     * @return Result of the DescribeJournalS3Export operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeJournalS3Export
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalS3Export" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeJournalS3ExportResponse describeJournalS3Export(DescribeJournalS3ExportRequest describeJournalS3ExportRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a journal export job, including the ledger name, export ID, when it was created,
     * current status, and its start and end time export parameters.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <p>
     * If the export job with the given <code>ExportId</code> doesn't exist, then throws
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJournalS3ExportRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeJournalS3ExportRequest#builder()}
     * </p>
     *
     * @param describeJournalS3ExportRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJournalS3ExportRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeJournalS3Export operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeJournalS3Export
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalS3Export" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeJournalS3ExportResponse describeJournalS3Export(
            Consumer<DescribeJournalS3ExportRequest.Builder> describeJournalS3ExportRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, QldbException {
        return describeJournalS3Export(DescribeJournalS3ExportRequest.builder().applyMutation(describeJournalS3ExportRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a ledger, including its state and when it was created.
     * </p>
     *
     * @param describeLedgerRequest
     * @return Result of the DescribeLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLedgerResponse describeLedger(DescribeLedgerRequest describeLedgerRequest) throws InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a ledger, including its state and when it was created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLedgerRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLedgerRequest#builder()}
     * </p>
     *
     * @param describeLedgerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLedgerRequest.Builder} to create a request.
     * @return Result of the DescribeLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.DescribeLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLedgerResponse describeLedger(Consumer<DescribeLedgerRequest.Builder> describeLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        return describeLedger(DescribeLedgerRequest.builder().applyMutation(describeLedgerRequest).build());
    }

    /**
     * <p>
     * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage
     * Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> is in <code>CREATING</code> status, then throws
     * <code>ResourcePreconditionNotMetException</code>.
     * </p>
     * <p>
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export
     * requests throw <code>LimitExceededException</code>.
     * </p>
     *
     * @param exportJournalToS3Request
     * @return Result of the ExportJournalToS3 operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ExportJournalToS3
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ExportJournalToS3" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportJournalToS3Response exportJournalToS3(ExportJournalToS3Request exportJournalToS3Request)
            throws ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage
     * Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the ledger with the given <code>Name</code> is in <code>CREATING</code> status, then throws
     * <code>ResourcePreconditionNotMetException</code>.
     * </p>
     * <p>
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export
     * requests throw <code>LimitExceededException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportJournalToS3Request.Builder} avoiding the need
     * to create one manually via {@link ExportJournalToS3Request#builder()}
     * </p>
     *
     * @param exportJournalToS3Request
     *        A {@link Consumer} that will call methods on {@link ExportJournalToS3Request.Builder} to create a request.
     * @return Result of the ExportJournalToS3 operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ExportJournalToS3
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ExportJournalToS3" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportJournalToS3Response exportJournalToS3(Consumer<ExportJournalToS3Request.Builder> exportJournalToS3Request)
            throws ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        return exportJournalToS3(ExportJournalToS3Request.builder().applyMutation(exportJournalToS3Request).build());
    }

    /**
     * <p>
     * Returns a journal block object at a specified address in a ledger. Also returns a proof of the specified block
     * for verification if <code>DigestTipAddress</code> is provided.
     * </p>
     * <p>
     * If the specified ledger doesn't exist or is in <code>DELETING</code> status, then throws
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the specified ledger is in <code>CREATING</code> status, then throws
     * <code>ResourcePreconditionNotMetException</code>.
     * </p>
     * <p>
     * If no block exists with the specified address, then throws <code>InvalidParameterException</code>.
     * </p>
     *
     * @param getBlockRequest
     * @return Result of the GetBlock operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlockResponse getBlock(GetBlockRequest getBlockRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a journal block object at a specified address in a ledger. Also returns a proof of the specified block
     * for verification if <code>DigestTipAddress</code> is provided.
     * </p>
     * <p>
     * If the specified ledger doesn't exist or is in <code>DELETING</code> status, then throws
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the specified ledger is in <code>CREATING</code> status, then throws
     * <code>ResourcePreconditionNotMetException</code>.
     * </p>
     * <p>
     * If no block exists with the specified address, then throws <code>InvalidParameterException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlockRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlockRequest#builder()}
     * </p>
     *
     * @param getBlockRequest
     *        A {@link Consumer} that will call methods on {@link GetBlockRequest.Builder} to create a request.
     * @return Result of the GetBlock operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlockResponse getBlock(Consumer<GetBlockRequest.Builder> getBlockRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        return getBlock(GetBlockRequest.builder().applyMutation(getBlockRequest).build());
    }

    /**
     * <p>
     * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash
     * value and a block address.
     * </p>
     *
     * @param getDigestRequest
     * @return Result of the GetDigest operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetDigest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetDigest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDigestResponse getDigest(GetDigestRequest getDigestRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash
     * value and a block address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDigestRequest.Builder} avoiding the need to
     * create one manually via {@link GetDigestRequest#builder()}
     * </p>
     *
     * @param getDigestRequest
     *        A {@link Consumer} that will call methods on {@link GetDigestRequest.Builder} to create a request.
     * @return Result of the GetDigest operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetDigest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetDigest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDigestResponse getDigest(Consumer<GetDigestRequest.Builder> getDigestRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        return getDigest(GetDigestRequest.builder().applyMutation(getDigestRequest).build());
    }

    /**
     * <p>
     * Returns a revision data object for a specified document ID and block address. Also returns a proof of the
     * specified revision for verification if <code>DigestTipAddress</code> is provided.
     * </p>
     *
     * @param getRevisionRequest
     * @return Result of the GetRevision operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetRevision" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRevisionResponse getRevision(GetRevisionRequest getRevisionRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a revision data object for a specified document ID and block address. Also returns a proof of the
     * specified revision for verification if <code>DigestTipAddress</code> is provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRevisionRequest.Builder} avoiding the need to
     * create one manually via {@link GetRevisionRequest#builder()}
     * </p>
     *
     * @param getRevisionRequest
     *        A {@link Consumer} that will call methods on {@link GetRevisionRequest.Builder} to create a request.
     * @return Result of the GetRevision operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.GetRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetRevision" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRevisionResponse getRevision(Consumer<GetRevisionRequest.Builder> getRevisionRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        return getRevision(GetRevisionRequest.builder().applyMutation(getRevisionRequest).build());
    }

    /**
     * <p>
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream
     * descriptor includes the same details that are returned by <code>DescribeJournalKinesisStream</code>.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items. It is paginated so that you can retrieve all the
     * items by calling <code>ListJournalKinesisStreamsForLedger</code> multiple times.
     * </p>
     *
     * @param listJournalKinesisStreamsForLedgerRequest
     * @return Result of the ListJournalKinesisStreamsForLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalKinesisStreamsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalKinesisStreamsForLedgerResponse listJournalKinesisStreamsForLedger(
            ListJournalKinesisStreamsForLedgerRequest listJournalKinesisStreamsForLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream
     * descriptor includes the same details that are returned by <code>DescribeJournalKinesisStream</code>.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items. It is paginated so that you can retrieve all the
     * items by calling <code>ListJournalKinesisStreamsForLedger</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalKinesisStreamsForLedgerRequest.Builder}
     * avoiding the need to create one manually via {@link ListJournalKinesisStreamsForLedgerRequest#builder()}
     * </p>
     *
     * @param listJournalKinesisStreamsForLedgerRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalKinesisStreamsForLedgerRequest.Builder} to
     *        create a request.
     * @return Result of the ListJournalKinesisStreamsForLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalKinesisStreamsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalKinesisStreamsForLedgerResponse listJournalKinesisStreamsForLedger(
            Consumer<ListJournalKinesisStreamsForLedgerRequest.Builder> listJournalKinesisStreamsForLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        return listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest.builder()
                .applyMutation(listJournalKinesisStreamsForLedgerRequest).build());
    }

    /**
     * <p>
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream
     * descriptor includes the same details that are returned by <code>DescribeJournalKinesisStream</code>.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items. It is paginated so that you can retrieve all the
     * items by calling <code>ListJournalKinesisStreamsForLedger</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalKinesisStreamsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client.listJournalKinesisStreamsForLedgerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client
     *             .listJournalKinesisStreamsForLedgerPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client.listJournalKinesisStreamsForLedgerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalKinesisStreamsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJournalKinesisStreamsForLedgerRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalKinesisStreamsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalKinesisStreamsForLedgerIterable listJournalKinesisStreamsForLedgerPaginator(
            ListJournalKinesisStreamsForLedgerRequest listJournalKinesisStreamsForLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream
     * descriptor includes the same details that are returned by <code>DescribeJournalKinesisStream</code>.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items. It is paginated so that you can retrieve all the
     * items by calling <code>ListJournalKinesisStreamsForLedger</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalKinesisStreamsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client.listJournalKinesisStreamsForLedgerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client
     *             .listJournalKinesisStreamsForLedgerPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalKinesisStreamsForLedgerIterable responses = client.listJournalKinesisStreamsForLedgerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalKinesisStreamsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalKinesisStreamsForLedgerRequest.Builder}
     * avoiding the need to create one manually via {@link ListJournalKinesisStreamsForLedgerRequest#builder()}
     * </p>
     *
     * @param listJournalKinesisStreamsForLedgerRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalKinesisStreamsForLedgerRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalKinesisStreamsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalKinesisStreamsForLedgerIterable listJournalKinesisStreamsForLedgerPaginator(
            Consumer<ListJournalKinesisStreamsForLedgerRequest.Builder> listJournalKinesisStreamsForLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        return listJournalKinesisStreamsForLedgerPaginator(ListJournalKinesisStreamsForLedgerRequest.builder()
                .applyMutation(listJournalKinesisStreamsForLedgerRequest).build());
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for all ledgers that are associated with the current AWS
     * account and Region.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3Exports</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     *
     * @param listJournalS3ExportsRequest
     * @return Result of the ListJournalS3Exports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3Exports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJournalS3ExportsResponse listJournalS3Exports(ListJournalS3ExportsRequest listJournalS3ExportsRequest)
            throws AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for all ledgers that are associated with the current AWS
     * account and Region.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3Exports</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalS3ExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListJournalS3ExportsRequest#builder()}
     * </p>
     *
     * @param listJournalS3ExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalS3ExportsRequest.Builder} to create a
     *        request.
     * @return Result of the ListJournalS3Exports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3Exports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJournalS3ExportsResponse listJournalS3Exports(
            Consumer<ListJournalS3ExportsRequest.Builder> listJournalS3ExportsRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        return listJournalS3Exports(ListJournalS3ExportsRequest.builder().applyMutation(listJournalS3ExportsRequest).build());
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for all ledgers that are associated with the current AWS
     * account and Region.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3Exports</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalS3Exports(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client.listJournalS3ExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client
     *             .listJournalS3ExportsPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client.listJournalS3ExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalS3Exports(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJournalS3ExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3Exports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJournalS3ExportsIterable listJournalS3ExportsPaginator(ListJournalS3ExportsRequest listJournalS3ExportsRequest)
            throws AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for all ledgers that are associated with the current AWS
     * account and Region.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3Exports</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalS3Exports(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client.listJournalS3ExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client
     *             .listJournalS3ExportsPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsIterable responses = client.listJournalS3ExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalS3Exports(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalS3ExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListJournalS3ExportsRequest#builder()}
     * </p>
     *
     * @param listJournalS3ExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalS3ExportsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3Exports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJournalS3ExportsIterable listJournalS3ExportsPaginator(
            Consumer<ListJournalS3ExportsRequest.Builder> listJournalS3ExportsRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        return listJournalS3ExportsPaginator(ListJournalS3ExportsRequest.builder().applyMutation(listJournalS3ExportsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for a specified ledger.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3ExportsForLedger</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     *
     * @param listJournalS3ExportsForLedgerRequest
     * @return Result of the ListJournalS3ExportsForLedger operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3ExportsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalS3ExportsForLedgerResponse listJournalS3ExportsForLedger(
            ListJournalS3ExportsForLedgerRequest listJournalS3ExportsForLedgerRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for a specified ledger.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3ExportsForLedger</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalS3ExportsForLedgerRequest.Builder}
     * avoiding the need to create one manually via {@link ListJournalS3ExportsForLedgerRequest#builder()}
     * </p>
     *
     * @param listJournalS3ExportsForLedgerRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalS3ExportsForLedgerRequest.Builder} to
     *        create a request.
     * @return Result of the ListJournalS3ExportsForLedger operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3ExportsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalS3ExportsForLedgerResponse listJournalS3ExportsForLedger(
            Consumer<ListJournalS3ExportsForLedgerRequest.Builder> listJournalS3ExportsForLedgerRequest)
            throws AwsServiceException, SdkClientException, QldbException {
        return listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest.builder()
                .applyMutation(listJournalS3ExportsForLedgerRequest).build());
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for a specified ledger.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3ExportsForLedger</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalS3ExportsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client.listJournalS3ExportsForLedgerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client
     *             .listJournalS3ExportsForLedgerPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client.listJournalS3ExportsForLedgerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalS3ExportsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJournalS3ExportsForLedgerRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3ExportsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalS3ExportsForLedgerIterable listJournalS3ExportsForLedgerPaginator(
            ListJournalS3ExportsForLedgerRequest listJournalS3ExportsForLedgerRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of journal export job descriptions for a specified ledger.
     * </p>
     * <p>
     * This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the
     * items by calling <code>ListJournalS3ExportsForLedger</code> multiple times.
     * </p>
     * <p>
     * This action does not return any expired export jobs. For more information, see <a href=
     * "https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration"
     * >Export Job Expiration</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJournalS3ExportsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client.listJournalS3ExportsForLedgerPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client
     *             .listJournalS3ExportsForLedgerPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListJournalS3ExportsForLedgerIterable responses = client.listJournalS3ExportsForLedgerPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJournalS3ExportsForLedger(software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJournalS3ExportsForLedgerRequest.Builder}
     * avoiding the need to create one manually via {@link ListJournalS3ExportsForLedgerRequest#builder()}
     * </p>
     *
     * @param listJournalS3ExportsForLedgerRequest
     *        A {@link Consumer} that will call methods on {@link ListJournalS3ExportsForLedgerRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListJournalS3ExportsForLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger"
     *      target="_top">AWS API Documentation</a>
     */
    default ListJournalS3ExportsForLedgerIterable listJournalS3ExportsForLedgerPaginator(
            Consumer<ListJournalS3ExportsForLedgerRequest.Builder> listJournalS3ExportsForLedgerRequest)
            throws AwsServiceException, SdkClientException, QldbException {
        return listJournalS3ExportsForLedgerPaginator(ListJournalS3ExportsForLedgerRequest.builder()
                .applyMutation(listJournalS3ExportsForLedgerRequest).build());
    }

    /**
     * <p>
     * Returns an array of ledger summaries that are associated with the current AWS account and Region.
     * </p>
     * <p>
     * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling
     * <code>ListLedgers</code> multiple times.
     * </p>
     *
     * @param listLedgersRequest
     * @return Result of the ListLedgers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListLedgers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLedgersResponse listLedgers(ListLedgersRequest listLedgersRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of ledger summaries that are associated with the current AWS account and Region.
     * </p>
     * <p>
     * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling
     * <code>ListLedgers</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLedgersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLedgersRequest#builder()}
     * </p>
     *
     * @param listLedgersRequest
     *        A {@link Consumer} that will call methods on {@link ListLedgersRequest.Builder} to create a request.
     * @return Result of the ListLedgers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListLedgers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLedgersResponse listLedgers(Consumer<ListLedgersRequest.Builder> listLedgersRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        return listLedgers(ListLedgersRequest.builder().applyMutation(listLedgersRequest).build());
    }

    /**
     * <p>
     * Returns an array of ledger summaries that are associated with the current AWS account and Region.
     * </p>
     * <p>
     * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling
     * <code>ListLedgers</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLedgers(software.amazon.awssdk.services.qldb.model.ListLedgersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListLedgersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLedgers(software.amazon.awssdk.services.qldb.model.ListLedgersRequest)} operation.</b>
     * </p>
     *
     * @param listLedgersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListLedgers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLedgersIterable listLedgersPaginator(ListLedgersRequest listLedgersRequest) throws AwsServiceException,
            SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of ledger summaries that are associated with the current AWS account and Region.
     * </p>
     * <p>
     * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling
     * <code>ListLedgers</code> multiple times.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLedgers(software.amazon.awssdk.services.qldb.model.ListLedgersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     *     for (software.amazon.awssdk.services.qldb.model.ListLedgersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qldb.paginators.ListLedgersIterable responses = client.listLedgersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLedgers(software.amazon.awssdk.services.qldb.model.ListLedgersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLedgersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLedgersRequest#builder()}
     * </p>
     *
     * @param listLedgersRequest
     *        A {@link Consumer} that will call methods on {@link ListLedgersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListLedgers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLedgersIterable listLedgersPaginator(Consumer<ListLedgersRequest.Builder> listLedgersRequest)
            throws AwsServiceException, SdkClientException, QldbException {
        return listLedgersPaginator(ListLedgersRequest.builder().applyMutation(listLedgersRequest).build());
    }

    /**
     * <p>
     * Returns all tags for a specified Amazon QLDB resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all tags for a specified Amazon QLDB resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a stream for a given Amazon QLDB ledger that delivers the journal data to a specified Amazon Kinesis Data
     * Streams resource. The stream captures every document revision that is committed to your journal and sends it to
     * the Kinesis data stream.
     * </p>
     *
     * @param streamJournalToKinesisRequest
     * @return Result of the StreamJournalToKinesis operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.StreamJournalToKinesis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/StreamJournalToKinesis" target="_top">AWS
     *      API Documentation</a>
     */
    default StreamJournalToKinesisResponse streamJournalToKinesis(StreamJournalToKinesisRequest streamJournalToKinesisRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException,
            AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stream for a given Amazon QLDB ledger that delivers the journal data to a specified Amazon Kinesis Data
     * Streams resource. The stream captures every document revision that is committed to your journal and sends it to
     * the Kinesis data stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamJournalToKinesisRequest.Builder} avoiding the
     * need to create one manually via {@link StreamJournalToKinesisRequest#builder()}
     * </p>
     *
     * @param streamJournalToKinesisRequest
     *        A {@link Consumer} that will call methods on {@link StreamJournalToKinesisRequest.Builder} to create a
     *        request.
     * @return Result of the StreamJournalToKinesis operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourcePreconditionNotMetException
     *         The operation failed because a condition wasn't satisfied in advance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.StreamJournalToKinesis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/StreamJournalToKinesis" target="_top">AWS
     *      API Documentation</a>
     */
    default StreamJournalToKinesisResponse streamJournalToKinesis(
            Consumer<StreamJournalToKinesisRequest.Builder> streamJournalToKinesisRequest) throws InvalidParameterException,
            ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException,
            QldbException {
        return streamJournalToKinesis(StreamJournalToKinesisRequest.builder().applyMutation(streamJournalToKinesisRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified Amazon QLDB resource.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified Amazon QLDB resource.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates properties on a ledger.
     * </p>
     *
     * @param updateLedgerRequest
     * @return Result of the UpdateLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.UpdateLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLedgerResponse updateLedger(UpdateLedgerRequest updateLedgerRequest) throws InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties on a ledger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLedgerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLedgerRequest#builder()}
     * </p>
     *
     * @param updateLedgerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLedgerRequest.Builder} to create a request.
     * @return Result of the UpdateLedger operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in the request aren't valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QldbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QldbClient.UpdateLedger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedger" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLedgerResponse updateLedger(Consumer<UpdateLedgerRequest.Builder> updateLedgerRequest)
            throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        return updateLedger(UpdateLedgerRequest.builder().applyMutation(updateLedgerRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("qldb");
    }
}
