/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextAIPromptInferenceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextAIPromptInferenceConfiguration> {
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("temperature").getter(TextAIPromptInferenceConfiguration.getter(TextAIPromptInferenceConfiguration::temperature)).setter(TextAIPromptInferenceConfiguration.setter(Builder::temperature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()}).build();
    private static final SdkField<Float> TOPP_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("topP").getter(TextAIPromptInferenceConfiguration.getter(TextAIPromptInferenceConfiguration::topP)).setter(TextAIPromptInferenceConfiguration.setter(Builder::topP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("topK").getter(TextAIPromptInferenceConfiguration.getter(TextAIPromptInferenceConfiguration::topK)).setter(TextAIPromptInferenceConfiguration.setter(Builder::topK)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()}).build();
    private static final SdkField<Integer> MAX_TOKENS_TO_SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTokensToSample").getter(TextAIPromptInferenceConfiguration.getter(TextAIPromptInferenceConfiguration::maxTokensToSample)).setter(TextAIPromptInferenceConfiguration.setter(Builder::maxTokensToSample)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTokensToSample").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPERATURE_FIELD, TOPP_FIELD, TOPK_FIELD, MAX_TOKENS_TO_SAMPLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextAIPromptInferenceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float temperature;
    private final Float topP;
    private final Integer topK;
    private final Integer maxTokensToSample;

    private TextAIPromptInferenceConfiguration(BuilderImpl builder) {
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.topK = builder.topK;
        this.maxTokensToSample = builder.maxTokensToSample;
    }

    public final Float temperature() {
        return this.temperature;
    }

    public final Float topP() {
        return this.topP;
    }

    public final Integer topK() {
        return this.topK;
    }

    public final Integer maxTokensToSample() {
        return this.maxTokensToSample;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.temperature());
        hashCode = 31 * hashCode + Objects.hashCode(this.topP());
        hashCode = 31 * hashCode + Objects.hashCode(this.topK());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTokensToSample());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextAIPromptInferenceConfiguration)) {
            return false;
        }
        TextAIPromptInferenceConfiguration other = (TextAIPromptInferenceConfiguration)obj;
        return Objects.equals(this.temperature(), other.temperature()) && Objects.equals(this.topP(), other.topP()) && Objects.equals(this.topK(), other.topK()) && Objects.equals(this.maxTokensToSample(), other.maxTokensToSample());
    }

    public final String toString() {
        return ToString.builder((String)"TextAIPromptInferenceConfiguration").add("Temperature", (Object)(this.temperature() == null ? null : "*** Sensitive Data Redacted ***")).add("TopP", (Object)(this.topP() == null ? null : "*** Sensitive Data Redacted ***")).add("TopK", (Object)(this.topK() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxTokensToSample", (Object)(this.maxTokensToSample() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "temperature": {
                return Optional.ofNullable(clazz.cast(this.temperature()));
            }
            case "topP": {
                return Optional.ofNullable(clazz.cast(this.topP()));
            }
            case "topK": {
                return Optional.ofNullable(clazz.cast(this.topK()));
            }
            case "maxTokensToSample": {
                return Optional.ofNullable(clazz.cast(this.maxTokensToSample()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("temperature", TEMPERATURE_FIELD);
        map.put("topP", TOPP_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("maxTokensToSample", MAX_TOKENS_TO_SAMPLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextAIPromptInferenceConfiguration, T> g) {
        return obj -> g.apply((TextAIPromptInferenceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float temperature;
        private Float topP;
        private Integer topK;
        private Integer maxTokensToSample;

        private BuilderImpl() {
        }

        private BuilderImpl(TextAIPromptInferenceConfiguration model) {
            this.temperature(model.temperature);
            this.topP(model.topP);
            this.topK(model.topK);
            this.maxTokensToSample(model.maxTokensToSample);
        }

        public final Float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return this.topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final Integer getTopK() {
            return this.topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Integer getMaxTokensToSample() {
            return this.maxTokensToSample;
        }

        public final void setMaxTokensToSample(Integer maxTokensToSample) {
            this.maxTokensToSample = maxTokensToSample;
        }

        @Override
        public final Builder maxTokensToSample(Integer maxTokensToSample) {
            this.maxTokensToSample = maxTokensToSample;
            return this;
        }

        public TextAIPromptInferenceConfiguration build() {
            return new TextAIPromptInferenceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextAIPromptInferenceConfiguration> {
        public Builder temperature(Float var1);

        public Builder topP(Float var1);

        public Builder topK(Integer var1);

        public Builder maxTokensToSample(Integer var1);
    }
}

