/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.Participant;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValue;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpanMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpanMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(SpanMessage.getter(SpanMessage::messageId)).setter(SpanMessage.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<String> PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participant").getter(SpanMessage.getter(SpanMessage::participantAsString)).setter(SpanMessage.setter(Builder::participant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participant").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(SpanMessage.getter(SpanMessage::timestamp)).setter(SpanMessage.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<List<SpanMessageValue>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(SpanMessage.getter(SpanMessage::values)).setter(SpanMessage.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpanMessageValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, PARTICIPANT_FIELD, TIMESTAMP_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpanMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String participant;
    private final Instant timestamp;
    private final List<SpanMessageValue> values;

    private SpanMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.participant = builder.participant;
        this.timestamp = builder.timestamp;
        this.values = builder.values;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Participant participant() {
        return Participant.fromValue(this.participant);
    }

    public final String participantAsString() {
        return this.participant;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<SpanMessageValue> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanMessage)) {
            return false;
        }
        SpanMessage other = (SpanMessage)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.participantAsString(), other.participantAsString()) && Objects.equals(this.timestamp(), other.timestamp()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"SpanMessage").add("MessageId", (Object)this.messageId()).add("Participant", (Object)this.participantAsString()).add("Timestamp", (Object)this.timestamp()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "participant": {
                return Optional.ofNullable(clazz.cast(this.participantAsString()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("participant", PARTICIPANT_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanMessage, T> g) {
        return obj -> g.apply((SpanMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String participant;
        private Instant timestamp;
        private List<SpanMessageValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpanMessage model) {
            this.messageId(model.messageId);
            this.participant(model.participant);
            this.timestamp(model.timestamp);
            this.values(model.values);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getParticipant() {
            return this.participant;
        }

        public final void setParticipant(String participant) {
            this.participant = participant;
        }

        @Override
        public final Builder participant(String participant) {
            this.participant = participant;
            return this;
        }

        @Override
        public final Builder participant(Participant participant) {
            this.participant(participant == null ? null : participant.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<SpanMessageValue.Builder> getValues() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<SpanMessageValue.BuilderImpl> values) {
            this.values = SpanMessageValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SpanMessageValue> values) {
            this.values = SpanMessageValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SpanMessageValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<SpanMessageValue.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (SpanMessageValue)((SpanMessageValue.Builder)SpanMessageValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SpanMessage build() {
            return new SpanMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpanMessage> {
        public Builder messageId(String var1);

        public Builder participant(String var1);

        public Builder participant(Participant var1);

        public Builder timestamp(Instant var1);

        public Builder values(Collection<SpanMessageValue> var1);

        public Builder values(SpanMessageValue ... var1);

        public Builder values(Consumer<SpanMessageValue.Builder> ... var1);
    }
}

