/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.SpanAttributes;
import software.amazon.awssdk.services.qconnect.model.SpanStatus;
import software.amazon.awssdk.services.qconnect.model.SpanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Span
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Span> {
    private static final SdkField<String> SPAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spanId").getter(Span.getter(Span::spanId)).setter(Span.setter(Builder::spanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(Span.getter(Span::assistantId)).setter(Span.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(Span.getter(Span::sessionId)).setter(Span.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> PARENT_SPAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentSpanId").getter(Span.getter(Span::parentSpanId)).setter(Span.setter(Builder::parentSpanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSpanId").build()}).build();
    private static final SdkField<String> SPAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spanName").getter(Span.getter(Span::spanName)).setter(Span.setter(Builder::spanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanName").build()}).build();
    private static final SdkField<String> SPAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spanType").getter(Span.getter(Span::spanTypeAsString)).setter(Span.setter(Builder::spanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanType").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTimestamp").getter(Span.getter(Span::startTimestamp)).setter(Span.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTimestamp").getter(Span.getter(Span::endTimestamp)).setter(Span.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Span.getter(Span::statusAsString)).setter(Span.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(Span.getter(Span::requestId)).setter(Span.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<SpanAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributes").getter(Span.getter(Span::attributes)).setter(Span.setter(Builder::attributes)).constructor(SpanAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPAN_ID_FIELD, ASSISTANT_ID_FIELD, SESSION_ID_FIELD, PARENT_SPAN_ID_FIELD, SPAN_NAME_FIELD, SPAN_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Span.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String spanId;
    private final String assistantId;
    private final String sessionId;
    private final String parentSpanId;
    private final String spanName;
    private final String spanType;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final String status;
    private final String requestIdValue;
    private final SpanAttributes attributes;

    private Span(BuilderImpl builder) {
        this.spanId = builder.spanId;
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.parentSpanId = builder.parentSpanId;
        this.spanName = builder.spanName;
        this.spanType = builder.spanType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.status = builder.status;
        this.requestIdValue = builder.requestIdValue;
        this.attributes = builder.attributes;
    }

    public final String spanId() {
        return this.spanId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String parentSpanId() {
        return this.parentSpanId;
    }

    public final String spanName() {
        return this.spanName;
    }

    public final SpanType spanType() {
        return SpanType.fromValue(this.spanType);
    }

    public final String spanTypeAsString() {
        return this.spanType;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final SpanStatus status() {
        return SpanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final SpanAttributes attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSpanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Span)) {
            return false;
        }
        Span other = (Span)obj;
        return Objects.equals(this.spanId(), other.spanId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.parentSpanId(), other.parentSpanId()) && Objects.equals(this.spanName(), other.spanName()) && Objects.equals(this.spanTypeAsString(), other.spanTypeAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"Span").add("SpanId", (Object)this.spanId()).add("AssistantId", (Object)this.assistantId()).add("SessionId", (Object)this.sessionId()).add("ParentSpanId", (Object)this.parentSpanId()).add("SpanName", (Object)this.spanName()).add("SpanType", (Object)this.spanTypeAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("Status", (Object)this.statusAsString()).add("RequestId", (Object)this.requestId()).add("Attributes", (Object)this.attributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spanId": {
                return Optional.ofNullable(clazz.cast(this.spanId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "parentSpanId": {
                return Optional.ofNullable(clazz.cast(this.parentSpanId()));
            }
            case "spanName": {
                return Optional.ofNullable(clazz.cast(this.spanName()));
            }
            case "spanType": {
                return Optional.ofNullable(clazz.cast(this.spanTypeAsString()));
            }
            case "startTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "endTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spanId", SPAN_ID_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("parentSpanId", PARENT_SPAN_ID_FIELD);
        map.put("spanName", SPAN_NAME_FIELD);
        map.put("spanType", SPAN_TYPE_FIELD);
        map.put("startTimestamp", START_TIMESTAMP_FIELD);
        map.put("endTimestamp", END_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Span, T> g) {
        return obj -> g.apply((Span)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spanId;
        private String assistantId;
        private String sessionId;
        private String parentSpanId;
        private String spanName;
        private String spanType;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private String status;
        private String requestIdValue;
        private SpanAttributes attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Span model) {
            this.spanId(model.spanId);
            this.assistantId(model.assistantId);
            this.sessionId(model.sessionId);
            this.parentSpanId(model.parentSpanId);
            this.spanName(model.spanName);
            this.spanType(model.spanType);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.status(model.status);
            this.requestId(model.requestIdValue);
            this.attributes(model.attributes);
        }

        public final String getSpanId() {
            return this.spanId;
        }

        public final void setSpanId(String spanId) {
            this.spanId = spanId;
        }

        @Override
        public final Builder spanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getParentSpanId() {
            return this.parentSpanId;
        }

        public final void setParentSpanId(String parentSpanId) {
            this.parentSpanId = parentSpanId;
        }

        @Override
        public final Builder parentSpanId(String parentSpanId) {
            this.parentSpanId = parentSpanId;
            return this;
        }

        public final String getSpanName() {
            return this.spanName;
        }

        public final void setSpanName(String spanName) {
            this.spanName = spanName;
        }

        @Override
        public final Builder spanName(String spanName) {
            this.spanName = spanName;
            return this;
        }

        public final String getSpanType() {
            return this.spanType;
        }

        public final void setSpanType(String spanType) {
            this.spanType = spanType;
        }

        @Override
        public final Builder spanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public final Builder spanType(SpanType spanType) {
            this.spanType(spanType == null ? null : spanType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final SpanAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(SpanAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(SpanAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public Span build() {
            return new Span(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Span> {
        public Builder spanId(String var1);

        public Builder assistantId(String var1);

        public Builder sessionId(String var1);

        public Builder parentSpanId(String var1);

        public Builder spanName(String var1);

        public Builder spanType(String var1);

        public Builder spanType(SpanType var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(SpanStatus var1);

        public Builder requestId(String var1);

        public Builder attributes(SpanAttributes var1);

        default public Builder attributes(Consumer<SpanAttributes.Builder> attributes) {
            return this.attributes((SpanAttributes)((SpanAttributes.Builder)SpanAttributes.builder().applyMutation(attributes)).build());
        }
    }
}

