/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ReferenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrieveResult> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(RetrieveResult.getter(RetrieveResult::associationId)).setter(RetrieveResult.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceId").getter(RetrieveResult.getter(RetrieveResult::sourceId)).setter(RetrieveResult.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()}).build();
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceType").getter(RetrieveResult.getter(RetrieveResult::referenceTypeAsString)).setter(RetrieveResult.setter(Builder::referenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()}).build();
    private static final SdkField<String> CONTENT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentText").getter(RetrieveResult.getter(RetrieveResult::contentText)).setter(RetrieveResult.setter(Builder::contentText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, SOURCE_ID_FIELD, REFERENCE_TYPE_FIELD, CONTENT_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String sourceId;
    private final String referenceType;
    private final String contentText;

    private RetrieveResult(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.sourceId = builder.sourceId;
        this.referenceType = builder.referenceType;
        this.contentText = builder.contentText;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public final String referenceTypeAsString() {
        return this.referenceType;
    }

    public final String contentText() {
        return this.contentText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResult)) {
            return false;
        }
        RetrieveResult other = (RetrieveResult)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.referenceTypeAsString(), other.referenceTypeAsString()) && Objects.equals(this.contentText(), other.contentText());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveResult").add("AssociationId", (Object)this.associationId()).add("SourceId", (Object)(this.sourceId() == null ? null : "*** Sensitive Data Redacted ***")).add("ReferenceType", (Object)this.referenceTypeAsString()).add("ContentText", (Object)(this.contentText() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "sourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "referenceType": {
                return Optional.ofNullable(clazz.cast(this.referenceTypeAsString()));
            }
            case "contentText": {
                return Optional.ofNullable(clazz.cast(this.contentText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        map.put("contentText", CONTENT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResult, T> g) {
        return obj -> g.apply((RetrieveResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String sourceId;
        private String referenceType;
        private String contentText;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResult model) {
            this.associationId(model.associationId);
            this.sourceId(model.sourceId);
            this.referenceType(model.referenceType);
            this.contentText(model.contentText);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final String getContentText() {
            return this.contentText;
        }

        public final void setContentText(String contentText) {
            this.contentText = contentText;
        }

        @Override
        public final Builder contentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public RetrieveResult build() {
            return new RetrieveResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrieveResult> {
        public Builder associationId(String var1);

        public Builder sourceId(String var1);

        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);

        public Builder contentText(String var1);
    }
}

