/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateBodyContentProvider;
import software.amazon.awssdk.services.qconnect.model.PushMessageAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushAPNSMessageTemplateContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushAPNSMessageTemplateContent> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::title)).setter(PushAPNSMessageTemplateContent.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<MessageTemplateBodyContentProvider> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("body").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::body)).setter(PushAPNSMessageTemplateContent.setter(Builder::body)).constructor(MessageTemplateBodyContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::actionAsString)).setter(PushAPNSMessageTemplateContent.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> SOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sound").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::sound)).setter(PushAPNSMessageTemplateContent.setter(Builder::sound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sound").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::url)).setter(PushAPNSMessageTemplateContent.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaUrl").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::mediaUrl)).setter(PushAPNSMessageTemplateContent.setter(Builder::mediaUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaUrl").build()}).build();
    private static final SdkField<MessageTemplateBodyContentProvider> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rawContent").getter(PushAPNSMessageTemplateContent.getter(PushAPNSMessageTemplateContent::rawContent)).setter(PushAPNSMessageTemplateContent.setter(Builder::rawContent)).constructor(MessageTemplateBodyContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, BODY_FIELD, ACTION_FIELD, SOUND_FIELD, URL_FIELD, MEDIA_URL_FIELD, RAW_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PushAPNSMessageTemplateContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final MessageTemplateBodyContentProvider body;
    private final String action;
    private final String sound;
    private final String url;
    private final String mediaUrl;
    private final MessageTemplateBodyContentProvider rawContent;

    private PushAPNSMessageTemplateContent(BuilderImpl builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.action = builder.action;
        this.sound = builder.sound;
        this.url = builder.url;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
    }

    public final String title() {
        return this.title;
    }

    public final MessageTemplateBodyContentProvider body() {
        return this.body;
    }

    public final PushMessageAction action() {
        return PushMessageAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String sound() {
        return this.sound;
    }

    public final String url() {
        return this.url;
    }

    public final String mediaUrl() {
        return this.mediaUrl;
    }

    public final MessageTemplateBodyContentProvider rawContent() {
        return this.rawContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushAPNSMessageTemplateContent)) {
            return false;
        }
        PushAPNSMessageTemplateContent other = (PushAPNSMessageTemplateContent)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.sound(), other.sound()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.rawContent(), other.rawContent());
    }

    public final String toString() {
        return ToString.builder((String)"PushAPNSMessageTemplateContent").add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Body", (Object)this.body()).add("Action", (Object)this.actionAsString()).add("Sound", (Object)(this.sound() == null ? null : "*** Sensitive Data Redacted ***")).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaUrl", (Object)(this.mediaUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("RawContent", (Object)this.rawContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "sound": {
                return Optional.ofNullable(clazz.cast(this.sound()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "mediaUrl": {
                return Optional.ofNullable(clazz.cast(this.mediaUrl()));
            }
            case "rawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", TITLE_FIELD);
        map.put("body", BODY_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("sound", SOUND_FIELD);
        map.put("url", URL_FIELD);
        map.put("mediaUrl", MEDIA_URL_FIELD);
        map.put("rawContent", RAW_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushAPNSMessageTemplateContent, T> g) {
        return obj -> g.apply((PushAPNSMessageTemplateContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private MessageTemplateBodyContentProvider body;
        private String action;
        private String sound;
        private String url;
        private String mediaUrl;
        private MessageTemplateBodyContentProvider rawContent;

        private BuilderImpl() {
        }

        private BuilderImpl(PushAPNSMessageTemplateContent model) {
            this.title(model.title);
            this.body(model.body);
            this.action(model.action);
            this.sound(model.sound);
            this.url(model.url);
            this.mediaUrl(model.mediaUrl);
            this.rawContent(model.rawContent);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final MessageTemplateBodyContentProvider.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        public final void setBody(MessageTemplateBodyContentProvider.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(MessageTemplateBodyContentProvider body) {
            this.body = body;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(PushMessageAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getSound() {
            return this.sound;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final MessageTemplateBodyContentProvider.Builder getRawContent() {
            return this.rawContent != null ? this.rawContent.toBuilder() : null;
        }

        public final void setRawContent(MessageTemplateBodyContentProvider.BuilderImpl rawContent) {
            this.rawContent = rawContent != null ? rawContent.build() : null;
        }

        @Override
        public final Builder rawContent(MessageTemplateBodyContentProvider rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public PushAPNSMessageTemplateContent build() {
            return new PushAPNSMessageTemplateContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushAPNSMessageTemplateContent> {
        public Builder title(String var1);

        public Builder body(MessageTemplateBodyContentProvider var1);

        default public Builder body(Consumer<MessageTemplateBodyContentProvider.Builder> body) {
            return this.body((MessageTemplateBodyContentProvider)((MessageTemplateBodyContentProvider.Builder)MessageTemplateBodyContentProvider.builder().applyMutation(body)).build());
        }

        public Builder action(String var1);

        public Builder action(PushMessageAction var1);

        public Builder sound(String var1);

        public Builder url(String var1);

        public Builder mediaUrl(String var1);

        public Builder rawContent(MessageTemplateBodyContentProvider var1);

        default public Builder rawContent(Consumer<MessageTemplateBodyContentProvider.Builder> rawContent) {
            return this.rawContent((MessageTemplateBodyContentProvider)((MessageTemplateBodyContentProvider.Builder)MessageTemplateBodyContentProvider.builder().applyMutation(rawContent)).build());
        }
    }
}

