/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationData;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationMapCopier;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry;
import software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagFilter;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSessionRequest.getter(CreateSessionRequest::clientToken)).setter(CreateSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(CreateSessionRequest.getter(CreateSessionRequest::assistantId)).setter(CreateSessionRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSessionRequest.getter(CreateSessionRequest::name)).setter(CreateSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSessionRequest.getter(CreateSessionRequest::description)).setter(CreateSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSessionRequest.getter(CreateSessionRequest::tags)).setter(CreateSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(CreateSessionRequest.getter(CreateSessionRequest::tagFilter)).setter(CreateSessionRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("aiAgentConfiguration").getter(CreateSessionRequest.getter(CreateSessionRequest::aiAgentConfigurationAsStrings)).setter(CreateSessionRequest.setter(Builder::aiAgentConfigurationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIAgentConfigurationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactArn").getter(CreateSessionRequest.getter(CreateSessionRequest::contactArn)).setter(CreateSessionRequest.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()}).build();
    private static final SdkField<List<OrchestratorConfigurationEntry>> ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orchestratorConfigurationList").getter(CreateSessionRequest.getter(CreateSessionRequest::orchestratorConfigurationList)).setter(CreateSessionRequest.setter(Builder::orchestratorConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrchestratorConfigurationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeOrchestratorConfigurationList").getter(CreateSessionRequest.getter(CreateSessionRequest::removeOrchestratorConfigurationList)).setter(CreateSessionRequest.setter(Builder::removeOrchestratorConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeOrchestratorConfigurationList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ASSISTANT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, TAG_FILTER_FIELD, AI_AGENT_CONFIGURATION_FIELD, CONTACT_ARN_FIELD, ORCHESTRATOR_CONFIGURATION_LIST_FIELD, REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSessionRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String assistantId;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final TagFilter tagFilter;
    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;
    private final String contactArn;
    private final List<OrchestratorConfigurationEntry> orchestratorConfigurationList;
    private final Boolean removeOrchestratorConfigurationList;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.tagFilter = builder.tagFilter;
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.contactArn = builder.contactArn;
        this.orchestratorConfigurationList = builder.orchestratorConfigurationList;
        this.removeOrchestratorConfigurationList = builder.removeOrchestratorConfigurationList;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(this.aiAgentConfiguration);
    }

    public final boolean hasAiAgentConfiguration() {
        return this.aiAgentConfiguration != null && !(this.aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return this.aiAgentConfiguration;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final boolean hasOrchestratorConfigurationList() {
        return this.orchestratorConfigurationList != null && !(this.orchestratorConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<OrchestratorConfigurationEntry> orchestratorConfigurationList() {
        return this.orchestratorConfigurationList;
    }

    public final Boolean removeOrchestratorConfigurationList() {
        return this.removeOrchestratorConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrchestratorConfigurationList() ? this.orchestratorConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.removeOrchestratorConfigurationList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tagFilter(), other.tagFilter()) && this.hasAiAgentConfiguration() == other.hasAiAgentConfiguration() && Objects.equals(this.aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings()) && Objects.equals(this.contactArn(), other.contactArn()) && this.hasOrchestratorConfigurationList() == other.hasOrchestratorConfigurationList() && Objects.equals(this.orchestratorConfigurationList(), other.orchestratorConfigurationList()) && Objects.equals(this.removeOrchestratorConfigurationList(), other.removeOrchestratorConfigurationList());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionRequest").add("ClientToken", (Object)this.clientToken()).add("AssistantId", (Object)this.assistantId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("TagFilter", (Object)this.tagFilter()).add("AiAgentConfiguration", this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null).add("ContactArn", (Object)this.contactArn()).add("OrchestratorConfigurationList", this.hasOrchestratorConfigurationList() ? this.orchestratorConfigurationList() : null).add("RemoveOrchestratorConfigurationList", (Object)this.removeOrchestratorConfigurationList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "aiAgentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aiAgentConfigurationAsStrings()));
            }
            case "contactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "orchestratorConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.orchestratorConfigurationList()));
            }
            case "removeOrchestratorConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.removeOrchestratorConfigurationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("aiAgentConfiguration", AI_AGENT_CONFIGURATION_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        map.put("orchestratorConfigurationList", ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        map.put("removeOrchestratorConfigurationList", REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String assistantId;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TagFilter tagFilter;
        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String contactArn;
        private List<OrchestratorConfigurationEntry> orchestratorConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private Boolean removeOrchestratorConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.assistantId(model.assistantId);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.tagFilter(model.tagFilter);
            this.aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            this.contactArn(model.contactArn);
            this.orchestratorConfigurationList(model.orchestratorConfigurationList);
            this.removeOrchestratorConfigurationList(model.removeOrchestratorConfigurationList);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier.copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final List<OrchestratorConfigurationEntry.Builder> getOrchestratorConfigurationList() {
            List<OrchestratorConfigurationEntry.Builder> result = OrchestratorConfigurationListCopier.copyToBuilder(this.orchestratorConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrchestratorConfigurationList(Collection<OrchestratorConfigurationEntry.BuilderImpl> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copyFromBuilder(orchestratorConfigurationList);
        }

        @Override
        public final Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copy(orchestratorConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(OrchestratorConfigurationEntry ... orchestratorConfigurationList) {
            this.orchestratorConfigurationList(Arrays.asList(orchestratorConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder> ... orchestratorConfigurationList) {
            this.orchestratorConfigurationList(Stream.of(orchestratorConfigurationList).map(c -> (OrchestratorConfigurationEntry)((OrchestratorConfigurationEntry.Builder)OrchestratorConfigurationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRemoveOrchestratorConfigurationList() {
            return this.removeOrchestratorConfigurationList;
        }

        public final void setRemoveOrchestratorConfigurationList(Boolean removeOrchestratorConfigurationList) {
            this.removeOrchestratorConfigurationList = removeOrchestratorConfigurationList;
        }

        @Override
        public final Builder removeOrchestratorConfigurationList(Boolean removeOrchestratorConfigurationList) {
            this.removeOrchestratorConfigurationList = removeOrchestratorConfigurationList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionRequest> {
        public Builder clientToken(String var1);

        public Builder assistantId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> var1);

        public Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> var1);

        public Builder contactArn(String var1);

        public Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> var1);

        public Builder orchestratorConfigurationList(OrchestratorConfigurationEntry ... var1);

        public Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder> ... var1);

        public Builder removeOrchestratorConfigurationList(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

