/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about the external data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppMessageTemplateSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppMessageTemplateSourceConfiguration.Builder, WhatsAppMessageTemplateSourceConfiguration> {
    private static final SdkField<String> BUSINESS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessAccountId").getter(getter(WhatsAppMessageTemplateSourceConfiguration::businessAccountId))
            .setter(setter(Builder::businessAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(WhatsAppMessageTemplateSourceConfiguration::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(WhatsAppMessageTemplateSourceConfiguration::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, COMPONENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String businessAccountId;

    private final String templateId;

    private final List<String> components;

    private WhatsAppMessageTemplateSourceConfiguration(BuilderImpl builder) {
        this.businessAccountId = builder.businessAccountId;
        this.templateId = builder.templateId;
        this.components = builder.components;
    }

    /**
     * <p>
     * The ID of the End User Messaging WhatsApp Business Account to associate with this template.
     * </p>
     * 
     * @return The ID of the End User Messaging WhatsApp Business Account to associate with this template.
     */
    public final String businessAccountId() {
        return businessAccountId;
    }

    /**
     * <p>
     * The WhatsApp template ID.
     * </p>
     * 
     * @return The WhatsApp template ID.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of component mapping from WhatsApp template parameters to Message Template attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return The list of component mapping from WhatsApp template parameters to Message Template attributes.
     */
    public final List<String> components() {
        return components;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppMessageTemplateSourceConfiguration)) {
            return false;
        }
        WhatsAppMessageTemplateSourceConfiguration other = (WhatsAppMessageTemplateSourceConfiguration) obj;
        return Objects.equals(businessAccountId(), other.businessAccountId()) && Objects.equals(templateId(), other.templateId())
                && hasComponents() == other.hasComponents() && Objects.equals(components(), other.components());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppMessageTemplateSourceConfiguration").add("BusinessAccountId", businessAccountId())
                .add("TemplateId", templateId()).add("Components", hasComponents() ? components() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "businessAccountId":
            return Optional.ofNullable(clazz.cast(businessAccountId()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("businessAccountId", BUSINESS_ACCOUNT_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("components", COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppMessageTemplateSourceConfiguration, T> g) {
        return obj -> g.apply((WhatsAppMessageTemplateSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfiguration> {
        /**
         * <p>
         * The ID of the End User Messaging WhatsApp Business Account to associate with this template.
         * </p>
         * 
         * @param businessAccountId
         *        The ID of the End User Messaging WhatsApp Business Account to associate with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessAccountId(String businessAccountId);

        /**
         * <p>
         * The WhatsApp template ID.
         * </p>
         * 
         * @param templateId
         *        The WhatsApp template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * </p>
         * 
         * @param components
         *        The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<String> components);

        /**
         * <p>
         * The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * </p>
         * 
         * @param components
         *        The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(String... components);
    }

    static final class BuilderImpl implements Builder {
        private String businessAccountId;

        private String templateId;

        private List<String> components = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppMessageTemplateSourceConfiguration model) {
            businessAccountId(model.businessAccountId);
            templateId(model.templateId);
            components(model.components);
        }

        public final String getBusinessAccountId() {
            return businessAccountId;
        }

        public final void setBusinessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
        }

        @Override
        public final Builder businessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Collection<String> getComponents() {
            if (components instanceof SdkAutoConstructList) {
                return null;
            }
            return components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        public WhatsAppMessageTemplateSourceConfiguration build() {
            return new WhatsAppMessageTemplateSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
