/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for user interaction settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserInteractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UserInteractionConfiguration.Builder, UserInteractionConfiguration> {
    private static final SdkField<Boolean> IS_USER_CONFIRMATION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isUserConfirmationRequired")
            .getter(getter(UserInteractionConfiguration::isUserConfirmationRequired))
            .setter(setter(Builder::isUserConfirmationRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUserConfirmationRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IS_USER_CONFIRMATION_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isUserConfirmationRequired;

    private UserInteractionConfiguration(BuilderImpl builder) {
        this.isUserConfirmationRequired = builder.isUserConfirmationRequired;
    }

    /**
     * <p>
     * Indicates whether user confirmation is required for the interaction.
     * </p>
     * 
     * @return Indicates whether user confirmation is required for the interaction.
     */
    public final Boolean isUserConfirmationRequired() {
        return isUserConfirmationRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isUserConfirmationRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserInteractionConfiguration)) {
            return false;
        }
        UserInteractionConfiguration other = (UserInteractionConfiguration) obj;
        return Objects.equals(isUserConfirmationRequired(), other.isUserConfirmationRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserInteractionConfiguration").add("IsUserConfirmationRequired", isUserConfirmationRequired())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isUserConfirmationRequired":
            return Optional.ofNullable(clazz.cast(isUserConfirmationRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isUserConfirmationRequired", IS_USER_CONFIRMATION_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserInteractionConfiguration, T> g) {
        return obj -> g.apply((UserInteractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserInteractionConfiguration> {
        /**
         * <p>
         * Indicates whether user confirmation is required for the interaction.
         * </p>
         * 
         * @param isUserConfirmationRequired
         *        Indicates whether user confirmation is required for the interaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUserConfirmationRequired(Boolean isUserConfirmationRequired);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isUserConfirmationRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(UserInteractionConfiguration model) {
            isUserConfirmationRequired(model.isUserConfirmationRequired);
        }

        public final Boolean getIsUserConfirmationRequired() {
            return isUserConfirmationRequired;
        }

        public final void setIsUserConfirmationRequired(Boolean isUserConfirmationRequired) {
            this.isUserConfirmationRequired = isUserConfirmationRequired;
        }

        @Override
        public final Builder isUserConfirmationRequired(Boolean isUserConfirmationRequired) {
            this.isUserConfirmationRequired = isUserConfirmationRequired;
            return this;
        }

        @Override
        public UserInteractionConfiguration build() {
            return new UserInteractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
