/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAiPromptRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateAiPromptRequest.Builder, UpdateAiPromptRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAiPromptRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(UpdateAiPromptRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiPromptId").getter(getter(UpdateAiPromptRequest::aiPromptId)).setter(setter(Builder::aiPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiPromptId").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(UpdateAiPromptRequest::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<AIPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(UpdateAiPromptRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(AIPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAiPromptRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(UpdateAiPromptRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<AIPromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<AIPromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(UpdateAiPromptRequest::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(AIPromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ASSISTANT_ID_FIELD, AI_PROMPT_ID_FIELD, VISIBILITY_STATUS_FIELD, TEMPLATE_CONFIGURATION_FIELD, DESCRIPTION_FIELD,
            MODEL_ID_FIELD, INFERENCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String assistantId;

    private final String aiPromptId;

    private final String visibilityStatus;

    private final AIPromptTemplateConfiguration templateConfiguration;

    private final String description;

    private final String modelId;

    private final AIPromptInferenceConfiguration inferenceConfiguration;

    private UpdateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.aiPromptId = builder.aiPromptId;
        this.visibilityStatus = builder.visibilityStatus;
        this.templateConfiguration = builder.templateConfiguration;
        this.description = builder.description;
        this.modelId = builder.modelId;
        this.inferenceConfiguration = builder.inferenceConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>..
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>..
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI Prompt.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI Prompt.
     */
    public final String aiPromptId() {
        return aiPromptId;
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI prompt.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI prompt.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * <p>
     * The configuration of the prompt template for this AI Prompt.
     * </p>
     * 
     * @return The configuration of the prompt template for this AI Prompt.
     */
    public final AIPromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The description of the Amazon Q in Connect AI Prompt.
     * </p>
     * 
     * @return The description of the Amazon Q in Connect AI Prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the model used for this AI Prompt.
     * </p>
     * <note>
     * <p>
     * For information about which models are supported in each Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt">Supported
     * models for system/custom prompts</a>.
     * </p>
     * </note>
     * 
     * @return The identifier of the model used for this AI Prompt.</p> <note>
     *         <p>
     *         For information about which models are supported in each Amazon Web Services Region, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
     *         >Supported models for system/custom prompts</a>.
     *         </p>
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The updated inference configuration for the AI Prompt.
     * </p>
     * 
     * @return The updated inference configuration for the AI Prompt.
     */
    public final AIPromptInferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiPromptRequest)) {
            return false;
        }
        UpdateAiPromptRequest other = (UpdateAiPromptRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(aiPromptId(), other.aiPromptId())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(inferenceConfiguration(), other.inferenceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAiPromptRequest").add("ClientToken", clientToken()).add("AssistantId", assistantId())
                .add("AiPromptId", aiPromptId()).add("VisibilityStatus", visibilityStatusAsString())
                .add("TemplateConfiguration", templateConfiguration()).add("Description", description())
                .add("ModelId", modelId()).add("InferenceConfiguration", inferenceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "aiPromptId":
            return Optional.ofNullable(clazz.cast(aiPromptId()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiPromptId", AI_PROMPT_ID_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiPromptRequest, T> g) {
        return obj -> g.apply((UpdateAiPromptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAiPromptRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>..
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI Prompt.
         * </p>
         * 
         * @param aiPromptId
         *        The identifier of the Amazon Q in Connect AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPromptId(String aiPromptId);

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration of the prompt template for this AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(AIPromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link AIPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(AIPromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The description of the Amazon Q in Connect AI Prompt.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Q in Connect AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the model used for this AI Prompt.
         * </p>
         * <note>
         * <p>
         * For information about which models are supported in each Amazon Web Services Region, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
         * >Supported models for system/custom prompts</a>.
         * </p>
         * </note>
         * 
         * @param modelId
         *        The identifier of the model used for this AI Prompt.</p> <note>
         *        <p>
         *        For information about which models are supported in each Amazon Web Services Region, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
         *        >Supported models for system/custom prompts</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The updated inference configuration for the AI Prompt.
         * </p>
         * 
         * @param inferenceConfiguration
         *        The updated inference configuration for the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * The updated inference configuration for the AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfiguration(AIPromptInferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link AIPromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(AIPromptInferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<AIPromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(AIPromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String assistantId;

        private String aiPromptId;

        private String visibilityStatus;

        private AIPromptTemplateConfiguration templateConfiguration;

        private String description;

        private String modelId;

        private AIPromptInferenceConfiguration inferenceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiPromptRequest model) {
            super(model);
            clientToken(model.clientToken);
            assistantId(model.assistantId);
            aiPromptId(model.aiPromptId);
            visibilityStatus(model.visibilityStatus);
            templateConfiguration(model.templateConfiguration);
            description(model.description);
            modelId(model.modelId);
            inferenceConfiguration(model.inferenceConfiguration);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiPromptId() {
            return aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final AIPromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(AIPromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiPromptRequest build() {
            return new UpdateAiPromptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
