/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAiAgentResponse extends QConnectResponse implements
        ToCopyableBuilder<UpdateAiAgentResponse.Builder, UpdateAiAgentResponse> {
    private static final SdkField<AIAgentData> AI_AGENT_FIELD = SdkField.<AIAgentData> builder(MarshallingType.SDK_POJO)
            .memberName("aiAgent").getter(getter(UpdateAiAgentResponse::aiAgent)).setter(setter(Builder::aiAgent))
            .constructor(AIAgentData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AIAgentData aiAgent;

    private UpdateAiAgentResponse(BuilderImpl builder) {
        super(builder);
        this.aiAgent = builder.aiAgent;
    }

    /**
     * <p>
     * The data of the updated Amazon Q in Connect AI Agent.
     * </p>
     * 
     * @return The data of the updated Amazon Q in Connect AI Agent.
     */
    public final AIAgentData aiAgent() {
        return aiAgent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiAgent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiAgentResponse)) {
            return false;
        }
        UpdateAiAgentResponse other = (UpdateAiAgentResponse) obj;
        return Objects.equals(aiAgent(), other.aiAgent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAiAgentResponse").add("AiAgent", aiAgent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiAgent":
            return Optional.ofNullable(clazz.cast(aiAgent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiAgent", AI_AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiAgentResponse, T> g) {
        return obj -> g.apply((UpdateAiAgentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAiAgentResponse> {
        /**
         * <p>
         * The data of the updated Amazon Q in Connect AI Agent.
         * </p>
         * 
         * @param aiAgent
         *        The data of the updated Amazon Q in Connect AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgent(AIAgentData aiAgent);

        /**
         * <p>
         * The data of the updated Amazon Q in Connect AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentData.Builder} avoiding the need to
         * create one manually via {@link AIAgentData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentData.Builder#build()} is called immediately and its result
         * is passed to {@link #aiAgent(AIAgentData)}.
         * 
         * @param aiAgent
         *        a consumer that will call methods on {@link AIAgentData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiAgent(AIAgentData)
         */
        default Builder aiAgent(Consumer<AIAgentData.Builder> aiAgent) {
            return aiAgent(AIAgentData.builder().applyMutation(aiAgent).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private AIAgentData aiAgent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiAgentResponse model) {
            super(model);
            aiAgent(model.aiAgent);
        }

        public final AIAgentData.Builder getAiAgent() {
            return aiAgent != null ? aiAgent.toBuilder() : null;
        }

        public final void setAiAgent(AIAgentData.BuilderImpl aiAgent) {
            this.aiAgent = aiAgent != null ? aiAgent.build() : null;
        }

        @Override
        public final Builder aiAgent(AIAgentData aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        @Override
        public UpdateAiAgentResponse build() {
            return new UpdateAiAgentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
