/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data about the result of tool usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolUseResultData implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolUseResultData.Builder, ToolUseResultData> {
    private static final SdkField<String> TOOL_USE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolUseId").getter(getter(ToolUseResultData::toolUseId)).setter(setter(Builder::toolUseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseId").build()).build();

    private static final SdkField<String> TOOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolName").getter(getter(ToolUseResultData::toolName)).setter(setter(Builder::toolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolName").build()).build();

    private static final SdkField<Document> TOOL_RESULT_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("toolResult").getter(getter(ToolUseResultData::toolResult)).setter(setter(Builder::toolResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()).build();

    private static final SdkField<Document> INPUT_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("inputSchema").getter(getter(ToolUseResultData::inputSchema)).setter(setter(Builder::inputSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_ID_FIELD,
            TOOL_NAME_FIELD, TOOL_RESULT_FIELD, INPUT_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String toolUseId;

    private final String toolName;

    private final Document toolResult;

    private final Document inputSchema;

    private ToolUseResultData(BuilderImpl builder) {
        this.toolUseId = builder.toolUseId;
        this.toolName = builder.toolName;
        this.toolResult = builder.toolResult;
        this.inputSchema = builder.inputSchema;
    }

    /**
     * <p>
     * The identifier of the tool use instance.
     * </p>
     * 
     * @return The identifier of the tool use instance.
     */
    public final String toolUseId() {
        return toolUseId;
    }

    /**
     * <p>
     * The name of the tool that was used.
     * </p>
     * 
     * @return The name of the tool that was used.
     */
    public final String toolName() {
        return toolName;
    }

    /**
     * <p>
     * The result of the tool usage.
     * </p>
     * 
     * @return The result of the tool usage.
     */
    public final Document toolResult() {
        return toolResult;
    }

    /**
     * <p>
     * The input schema for the tool use result.
     * </p>
     * 
     * @return The input schema for the tool use result.
     */
    public final Document inputSchema() {
        return inputSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolUseId());
        hashCode = 31 * hashCode + Objects.hashCode(toolName());
        hashCode = 31 * hashCode + Objects.hashCode(toolResult());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolUseResultData)) {
            return false;
        }
        ToolUseResultData other = (ToolUseResultData) obj;
        return Objects.equals(toolUseId(), other.toolUseId()) && Objects.equals(toolName(), other.toolName())
                && Objects.equals(toolResult(), other.toolResult()) && Objects.equals(inputSchema(), other.inputSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolUseResultData").add("ToolUseId", toolUseId()).add("ToolName", toolName())
                .add("ToolResult", toolResult()).add("InputSchema", inputSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolUseId":
            return Optional.ofNullable(clazz.cast(toolUseId()));
        case "toolName":
            return Optional.ofNullable(clazz.cast(toolName()));
        case "toolResult":
            return Optional.ofNullable(clazz.cast(toolResult()));
        case "inputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("toolUseId", TOOL_USE_ID_FIELD);
        map.put("toolName", TOOL_NAME_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("inputSchema", INPUT_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolUseResultData, T> g) {
        return obj -> g.apply((ToolUseResultData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolUseResultData> {
        /**
         * <p>
         * The identifier of the tool use instance.
         * </p>
         * 
         * @param toolUseId
         *        The identifier of the tool use instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUseId(String toolUseId);

        /**
         * <p>
         * The name of the tool that was used.
         * </p>
         * 
         * @param toolName
         *        The name of the tool that was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolName(String toolName);

        /**
         * <p>
         * The result of the tool usage.
         * </p>
         * 
         * @param toolResult
         *        The result of the tool usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(Document toolResult);

        /**
         * <p>
         * The input schema for the tool use result.
         * </p>
         * 
         * @param inputSchema
         *        The input schema for the tool use result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(Document inputSchema);
    }

    static final class BuilderImpl implements Builder {
        private String toolUseId;

        private String toolName;

        private Document toolResult;

        private Document inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolUseResultData model) {
            toolUseId(model.toolUseId);
            toolName(model.toolName);
            toolResult(model.toolResult);
            inputSchema(model.inputSchema);
        }

        public final String getToolUseId() {
            return toolUseId;
        }

        public final void setToolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
        }

        @Override
        public final Builder toolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
            return this;
        }

        public final String getToolName() {
            return toolName;
        }

        public final void setToolName(String toolName) {
            this.toolName = toolName;
        }

        @Override
        public final Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public final Document getToolResult() {
            return toolResult;
        }

        public final void setToolResult(Document toolResult) {
            this.toolResult = toolResult;
        }

        @Override
        public final Builder toolResult(Document toolResult) {
            this.toolResult = toolResult;
            return this;
        }

        public final Document getInputSchema() {
            return inputSchema;
        }

        public final void setInputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
        }

        @Override
        public final Builder inputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @Override
        public ToolUseResultData build() {
            return new ToolUseResultData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
