/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter configuration for tool output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolOutputFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolOutputFilter.Builder, ToolOutputFilter> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jsonPath").getter(getter(ToolOutputFilter::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()).build();

    private static final SdkField<ToolOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ToolOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(ToolOutputFilter::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(ToolOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD,
            OUTPUT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jsonPath;

    private final ToolOutputConfiguration outputConfiguration;

    private ToolOutputFilter(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.outputConfiguration = builder.outputConfiguration;
    }

    /**
     * <p>
     * The JSON path for filtering tool output.
     * </p>
     * 
     * @return The JSON path for filtering tool output.
     */
    public final String jsonPath() {
        return jsonPath;
    }

    /**
     * <p>
     * The output configuration for the filter.
     * </p>
     * 
     * @return The output configuration for the filter.
     */
    public final ToolOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOutputFilter)) {
            return false;
        }
        ToolOutputFilter other = (ToolOutputFilter) obj;
        return Objects.equals(jsonPath(), other.jsonPath()) && Objects.equals(outputConfiguration(), other.outputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolOutputFilter").add("JsonPath", jsonPath()).add("OutputConfiguration", outputConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jsonPath", JSON_PATH_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolOutputFilter, T> g) {
        return obj -> g.apply((ToolOutputFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolOutputFilter> {
        /**
         * <p>
         * The JSON path for filtering tool output.
         * </p>
         * 
         * @param jsonPath
         *        The JSON path for filtering tool output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);

        /**
         * <p>
         * The output configuration for the filter.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(ToolOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The output configuration for the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolOutputConfiguration.Builder} avoiding
         * the need to create one manually via {@link ToolOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfiguration(ToolOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link ToolOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(ToolOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<ToolOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(ToolOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jsonPath;

        private ToolOutputConfiguration outputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolOutputFilter model) {
            jsonPath(model.jsonPath);
            outputConfiguration(model.outputConfiguration);
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final ToolOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(ToolOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(ToolOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        @Override
        public ToolOutputFilter build() {
            return new ToolOutputFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
