/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for a tool used by AI Agents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolConfiguration.Builder, ToolConfiguration> {
    private static final SdkField<String> TOOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolName").getter(getter(ToolConfiguration::toolName)).setter(setter(Builder::toolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolName").build()).build();

    private static final SdkField<String> TOOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolType").getter(getter(ToolConfiguration::toolTypeAsString)).setter(setter(Builder::toolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ToolConfiguration::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> TOOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("toolId")
            .getter(getter(ToolConfiguration::toolId)).setter(setter(Builder::toolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ToolConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ToolInstruction> INSTRUCTION_FIELD = SdkField
            .<ToolInstruction> builder(MarshallingType.SDK_POJO).memberName("instruction")
            .getter(getter(ToolConfiguration::instruction)).setter(setter(Builder::instruction))
            .constructor(ToolInstruction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<List<ToolOverrideInputValue>> OVERRIDE_INPUT_VALUES_FIELD = SdkField
            .<List<ToolOverrideInputValue>> builder(MarshallingType.LIST)
            .memberName("overrideInputValues")
            .getter(getter(ToolConfiguration::overrideInputValues))
            .setter(setter(Builder::overrideInputValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideInputValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToolOverrideInputValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToolOverrideInputValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ToolOutputFilter>> OUTPUT_FILTERS_FIELD = SdkField
            .<List<ToolOutputFilter>> builder(MarshallingType.LIST)
            .memberName("outputFilters")
            .getter(getter(ToolConfiguration::outputFilters))
            .setter(setter(Builder::outputFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToolOutputFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToolOutputFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> INPUT_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("inputSchema").getter(getter(ToolConfiguration::inputSchema)).setter(setter(Builder::inputSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSchema").build()).build();

    private static final SdkField<Document> OUTPUT_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("outputSchema").getter(getter(ToolConfiguration::outputSchema)).setter(setter(Builder::outputSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSchema").build()).build();

    private static final SdkField<Annotation> ANNOTATIONS_FIELD = SdkField.<Annotation> builder(MarshallingType.SDK_POJO)
            .memberName("annotations").getter(getter(ToolConfiguration::annotations)).setter(setter(Builder::annotations))
            .constructor(Annotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build()).build();

    private static final SdkField<UserInteractionConfiguration> USER_INTERACTION_CONFIGURATION_FIELD = SdkField
            .<UserInteractionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("userInteractionConfiguration")
            .getter(getter(ToolConfiguration::userInteractionConfiguration))
            .setter(setter(Builder::userInteractionConfiguration))
            .constructor(UserInteractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userInteractionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_NAME_FIELD,
            TOOL_TYPE_FIELD, TITLE_FIELD, TOOL_ID_FIELD, DESCRIPTION_FIELD, INSTRUCTION_FIELD, OVERRIDE_INPUT_VALUES_FIELD,
            OUTPUT_FILTERS_FIELD, INPUT_SCHEMA_FIELD, OUTPUT_SCHEMA_FIELD, ANNOTATIONS_FIELD,
            USER_INTERACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String toolName;

    private final String toolType;

    private final String title;

    private final String toolId;

    private final String description;

    private final ToolInstruction instruction;

    private final List<ToolOverrideInputValue> overrideInputValues;

    private final List<ToolOutputFilter> outputFilters;

    private final Document inputSchema;

    private final Document outputSchema;

    private final Annotation annotations;

    private final UserInteractionConfiguration userInteractionConfiguration;

    private ToolConfiguration(BuilderImpl builder) {
        this.toolName = builder.toolName;
        this.toolType = builder.toolType;
        this.title = builder.title;
        this.toolId = builder.toolId;
        this.description = builder.description;
        this.instruction = builder.instruction;
        this.overrideInputValues = builder.overrideInputValues;
        this.outputFilters = builder.outputFilters;
        this.inputSchema = builder.inputSchema;
        this.outputSchema = builder.outputSchema;
        this.annotations = builder.annotations;
        this.userInteractionConfiguration = builder.userInteractionConfiguration;
    }

    /**
     * <p>
     * The name of the tool.
     * </p>
     * 
     * @return The name of the tool.
     */
    public final String toolName() {
        return toolName;
    }

    /**
     * <p>
     * The type of the tool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolType} will
     * return {@link ToolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toolTypeAsString}.
     * </p>
     * 
     * @return The type of the tool.
     * @see ToolType
     */
    public final ToolType toolType() {
        return ToolType.fromValue(toolType);
    }

    /**
     * <p>
     * The type of the tool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolType} will
     * return {@link ToolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toolTypeAsString}.
     * </p>
     * 
     * @return The type of the tool.
     * @see ToolType
     */
    public final String toolTypeAsString() {
        return toolType;
    }

    /**
     * <p>
     * The title of the tool configuration.
     * </p>
     * 
     * @return The title of the tool configuration.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The identifier of the tool, for example toolName from Model Context Provider server.
     * </p>
     * 
     * @return The identifier of the tool, for example toolName from Model Context Provider server.
     */
    public final String toolId() {
        return toolId;
    }

    /**
     * <p>
     * The description of the tool configuration.
     * </p>
     * 
     * @return The description of the tool configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Instructions for using the tool.
     * </p>
     * 
     * @return Instructions for using the tool.
     */
    public final ToolInstruction instruction() {
        return instruction;
    }

    /**
     * For responses, this returns true if the service returned a value for the OverrideInputValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOverrideInputValues() {
        return overrideInputValues != null && !(overrideInputValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Override input values for the tool configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrideInputValues} method.
     * </p>
     * 
     * @return Override input values for the tool configuration.
     */
    public final List<ToolOverrideInputValue> overrideInputValues() {
        return overrideInputValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputFilters() {
        return outputFilters != null && !(outputFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Output filters applies to the tool result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputFilters} method.
     * </p>
     * 
     * @return Output filters applies to the tool result.
     */
    public final List<ToolOutputFilter> outputFilters() {
        return outputFilters;
    }

    /**
     * <p>
     * The input schema for the tool configuration.
     * </p>
     * 
     * @return The input schema for the tool configuration.
     */
    public final Document inputSchema() {
        return inputSchema;
    }

    /**
     * <p>
     * The output schema for the tool configuration.
     * </p>
     * 
     * @return The output schema for the tool configuration.
     */
    public final Document outputSchema() {
        return outputSchema;
    }

    /**
     * <p>
     * Annotations for the tool configuration.
     * </p>
     * 
     * @return Annotations for the tool configuration.
     */
    public final Annotation annotations() {
        return annotations;
    }

    /**
     * <p>
     * Configuration for user interaction with the tool.
     * </p>
     * 
     * @return Configuration for user interaction with the tool.
     */
    public final UserInteractionConfiguration userInteractionConfiguration() {
        return userInteractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolName());
        hashCode = 31 * hashCode + Objects.hashCode(toolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(toolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrideInputValues() ? overrideInputValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputFilters() ? outputFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(outputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(annotations());
        hashCode = 31 * hashCode + Objects.hashCode(userInteractionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration) obj;
        return Objects.equals(toolName(), other.toolName()) && Objects.equals(toolTypeAsString(), other.toolTypeAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(toolId(), other.toolId())
                && Objects.equals(description(), other.description()) && Objects.equals(instruction(), other.instruction())
                && hasOverrideInputValues() == other.hasOverrideInputValues()
                && Objects.equals(overrideInputValues(), other.overrideInputValues())
                && hasOutputFilters() == other.hasOutputFilters() && Objects.equals(outputFilters(), other.outputFilters())
                && Objects.equals(inputSchema(), other.inputSchema()) && Objects.equals(outputSchema(), other.outputSchema())
                && Objects.equals(annotations(), other.annotations())
                && Objects.equals(userInteractionConfiguration(), other.userInteractionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolConfiguration").add("ToolName", toolName()).add("ToolType", toolTypeAsString())
                .add("Title", title()).add("ToolId", toolId()).add("Description", description())
                .add("Instruction", instruction())
                .add("OverrideInputValues", hasOverrideInputValues() ? overrideInputValues() : null)
                .add("OutputFilters", hasOutputFilters() ? outputFilters() : null).add("InputSchema", inputSchema())
                .add("OutputSchema", outputSchema()).add("Annotations", annotations())
                .add("UserInteractionConfiguration", userInteractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolName":
            return Optional.ofNullable(clazz.cast(toolName()));
        case "toolType":
            return Optional.ofNullable(clazz.cast(toolTypeAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "toolId":
            return Optional.ofNullable(clazz.cast(toolId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "overrideInputValues":
            return Optional.ofNullable(clazz.cast(overrideInputValues()));
        case "outputFilters":
            return Optional.ofNullable(clazz.cast(outputFilters()));
        case "inputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        case "outputSchema":
            return Optional.ofNullable(clazz.cast(outputSchema()));
        case "annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "userInteractionConfiguration":
            return Optional.ofNullable(clazz.cast(userInteractionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("toolName", TOOL_NAME_FIELD);
        map.put("toolType", TOOL_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("toolId", TOOL_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("overrideInputValues", OVERRIDE_INPUT_VALUES_FIELD);
        map.put("outputFilters", OUTPUT_FILTERS_FIELD);
        map.put("inputSchema", INPUT_SCHEMA_FIELD);
        map.put("outputSchema", OUTPUT_SCHEMA_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("userInteractionConfiguration", USER_INTERACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolConfiguration, T> g) {
        return obj -> g.apply((ToolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolConfiguration> {
        /**
         * <p>
         * The name of the tool.
         * </p>
         * 
         * @param toolName
         *        The name of the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolName(String toolName);

        /**
         * <p>
         * The type of the tool.
         * </p>
         * 
         * @param toolType
         *        The type of the tool.
         * @see ToolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolType
         */
        Builder toolType(String toolType);

        /**
         * <p>
         * The type of the tool.
         * </p>
         * 
         * @param toolType
         *        The type of the tool.
         * @see ToolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolType
         */
        Builder toolType(ToolType toolType);

        /**
         * <p>
         * The title of the tool configuration.
         * </p>
         * 
         * @param title
         *        The title of the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The identifier of the tool, for example toolName from Model Context Provider server.
         * </p>
         * 
         * @param toolId
         *        The identifier of the tool, for example toolName from Model Context Provider server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolId(String toolId);

        /**
         * <p>
         * The description of the tool configuration.
         * </p>
         * 
         * @param description
         *        The description of the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Instructions for using the tool.
         * </p>
         * 
         * @param instruction
         *        Instructions for using the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(ToolInstruction instruction);

        /**
         * <p>
         * Instructions for using the tool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolInstruction.Builder} avoiding the
         * need to create one manually via {@link ToolInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolInstruction.Builder#build()} is called immediately and its
         * result is passed to {@link #instruction(ToolInstruction)}.
         * 
         * @param instruction
         *        a consumer that will call methods on {@link ToolInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instruction(ToolInstruction)
         */
        default Builder instruction(Consumer<ToolInstruction.Builder> instruction) {
            return instruction(ToolInstruction.builder().applyMutation(instruction).build());
        }

        /**
         * <p>
         * Override input values for the tool configuration.
         * </p>
         * 
         * @param overrideInputValues
         *        Override input values for the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideInputValues(Collection<ToolOverrideInputValue> overrideInputValues);

        /**
         * <p>
         * Override input values for the tool configuration.
         * </p>
         * 
         * @param overrideInputValues
         *        Override input values for the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideInputValues(ToolOverrideInputValue... overrideInputValues);

        /**
         * <p>
         * Override input values for the tool configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValue.Builder#build()} is called
         * immediately and its result is passed to {@link #overrideInputValues(List<ToolOverrideInputValue>)}.
         * 
         * @param overrideInputValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.ToolOverrideInputValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideInputValues(java.util.Collection<ToolOverrideInputValue>)
         */
        Builder overrideInputValues(Consumer<ToolOverrideInputValue.Builder>... overrideInputValues);

        /**
         * <p>
         * Output filters applies to the tool result.
         * </p>
         * 
         * @param outputFilters
         *        Output filters applies to the tool result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFilters(Collection<ToolOutputFilter> outputFilters);

        /**
         * <p>
         * Output filters applies to the tool result.
         * </p>
         * 
         * @param outputFilters
         *        Output filters applies to the tool result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFilters(ToolOutputFilter... outputFilters);

        /**
         * <p>
         * Output filters applies to the tool result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.ToolOutputFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.ToolOutputFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.ToolOutputFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #outputFilters(List<ToolOutputFilter>)}.
         * 
         * @param outputFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.ToolOutputFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputFilters(java.util.Collection<ToolOutputFilter>)
         */
        Builder outputFilters(Consumer<ToolOutputFilter.Builder>... outputFilters);

        /**
         * <p>
         * The input schema for the tool configuration.
         * </p>
         * 
         * @param inputSchema
         *        The input schema for the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(Document inputSchema);

        /**
         * <p>
         * The output schema for the tool configuration.
         * </p>
         * 
         * @param outputSchema
         *        The output schema for the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchema(Document outputSchema);

        /**
         * <p>
         * Annotations for the tool configuration.
         * </p>
         * 
         * @param annotations
         *        Annotations for the tool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Annotation annotations);

        /**
         * <p>
         * Annotations for the tool configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Annotation.Builder} avoiding the need to
         * create one manually via {@link Annotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Annotation.Builder#build()} is called immediately and its result
         * is passed to {@link #annotations(Annotation)}.
         * 
         * @param annotations
         *        a consumer that will call methods on {@link Annotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(Annotation)
         */
        default Builder annotations(Consumer<Annotation.Builder> annotations) {
            return annotations(Annotation.builder().applyMutation(annotations).build());
        }

        /**
         * <p>
         * Configuration for user interaction with the tool.
         * </p>
         * 
         * @param userInteractionConfiguration
         *        Configuration for user interaction with the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInteractionConfiguration(UserInteractionConfiguration userInteractionConfiguration);

        /**
         * <p>
         * Configuration for user interaction with the tool.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserInteractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link UserInteractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserInteractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #userInteractionConfiguration(UserInteractionConfiguration)}.
         * 
         * @param userInteractionConfiguration
         *        a consumer that will call methods on {@link UserInteractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userInteractionConfiguration(UserInteractionConfiguration)
         */
        default Builder userInteractionConfiguration(Consumer<UserInteractionConfiguration.Builder> userInteractionConfiguration) {
            return userInteractionConfiguration(UserInteractionConfiguration.builder()
                    .applyMutation(userInteractionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String toolName;

        private String toolType;

        private String title;

        private String toolId;

        private String description;

        private ToolInstruction instruction;

        private List<ToolOverrideInputValue> overrideInputValues = DefaultSdkAutoConstructList.getInstance();

        private List<ToolOutputFilter> outputFilters = DefaultSdkAutoConstructList.getInstance();

        private Document inputSchema;

        private Document outputSchema;

        private Annotation annotations;

        private UserInteractionConfiguration userInteractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolConfiguration model) {
            toolName(model.toolName);
            toolType(model.toolType);
            title(model.title);
            toolId(model.toolId);
            description(model.description);
            instruction(model.instruction);
            overrideInputValues(model.overrideInputValues);
            outputFilters(model.outputFilters);
            inputSchema(model.inputSchema);
            outputSchema(model.outputSchema);
            annotations(model.annotations);
            userInteractionConfiguration(model.userInteractionConfiguration);
        }

        public final String getToolName() {
            return toolName;
        }

        public final void setToolName(String toolName) {
            this.toolName = toolName;
        }

        @Override
        public final Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public final String getToolType() {
            return toolType;
        }

        public final void setToolType(String toolType) {
            this.toolType = toolType;
        }

        @Override
        public final Builder toolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        @Override
        public final Builder toolType(ToolType toolType) {
            this.toolType(toolType == null ? null : toolType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getToolId() {
            return toolId;
        }

        public final void setToolId(String toolId) {
            this.toolId = toolId;
        }

        @Override
        public final Builder toolId(String toolId) {
            this.toolId = toolId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ToolInstruction.Builder getInstruction() {
            return instruction != null ? instruction.toBuilder() : null;
        }

        public final void setInstruction(ToolInstruction.BuilderImpl instruction) {
            this.instruction = instruction != null ? instruction.build() : null;
        }

        @Override
        public final Builder instruction(ToolInstruction instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<ToolOverrideInputValue.Builder> getOverrideInputValues() {
            List<ToolOverrideInputValue.Builder> result = ToolOverrideInputValueListCopier
                    .copyToBuilder(this.overrideInputValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrideInputValues(Collection<ToolOverrideInputValue.BuilderImpl> overrideInputValues) {
            this.overrideInputValues = ToolOverrideInputValueListCopier.copyFromBuilder(overrideInputValues);
        }

        @Override
        public final Builder overrideInputValues(Collection<ToolOverrideInputValue> overrideInputValues) {
            this.overrideInputValues = ToolOverrideInputValueListCopier.copy(overrideInputValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideInputValues(ToolOverrideInputValue... overrideInputValues) {
            overrideInputValues(Arrays.asList(overrideInputValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideInputValues(Consumer<ToolOverrideInputValue.Builder>... overrideInputValues) {
            overrideInputValues(Stream.of(overrideInputValues)
                    .map(c -> ToolOverrideInputValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ToolOutputFilter.Builder> getOutputFilters() {
            List<ToolOutputFilter.Builder> result = ToolOutputFilterListCopier.copyToBuilder(this.outputFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputFilters(Collection<ToolOutputFilter.BuilderImpl> outputFilters) {
            this.outputFilters = ToolOutputFilterListCopier.copyFromBuilder(outputFilters);
        }

        @Override
        public final Builder outputFilters(Collection<ToolOutputFilter> outputFilters) {
            this.outputFilters = ToolOutputFilterListCopier.copy(outputFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFilters(ToolOutputFilter... outputFilters) {
            outputFilters(Arrays.asList(outputFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFilters(Consumer<ToolOutputFilter.Builder>... outputFilters) {
            outputFilters(Stream.of(outputFilters).map(c -> ToolOutputFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Document getInputSchema() {
            return inputSchema;
        }

        public final void setInputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
        }

        @Override
        public final Builder inputSchema(Document inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final Document getOutputSchema() {
            return outputSchema;
        }

        public final void setOutputSchema(Document outputSchema) {
            this.outputSchema = outputSchema;
        }

        @Override
        public final Builder outputSchema(Document outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public final Annotation.Builder getAnnotations() {
            return annotations != null ? annotations.toBuilder() : null;
        }

        public final void setAnnotations(Annotation.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        @Override
        public final Builder annotations(Annotation annotations) {
            this.annotations = annotations;
            return this;
        }

        public final UserInteractionConfiguration.Builder getUserInteractionConfiguration() {
            return userInteractionConfiguration != null ? userInteractionConfiguration.toBuilder() : null;
        }

        public final void setUserInteractionConfiguration(UserInteractionConfiguration.BuilderImpl userInteractionConfiguration) {
            this.userInteractionConfiguration = userInteractionConfiguration != null ? userInteractionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder userInteractionConfiguration(UserInteractionConfiguration userInteractionConfiguration) {
            this.userInteractionConfiguration = userInteractionConfiguration;
            return this;
        }

        @Override
        public ToolConfiguration build() {
            return new ToolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
