/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Message content value - can be text, tool invocation, or tool result
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpanMessageValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SpanMessageValue.Builder, SpanMessageValue> {
    private static final SdkField<SpanTextValue> TEXT_FIELD = SdkField.<SpanTextValue> builder(MarshallingType.SDK_POJO)
            .memberName("text").getter(getter(SpanMessageValue::text)).setter(setter(Builder::text))
            .constructor(SpanTextValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<SpanToolUseValue> TOOL_USE_FIELD = SdkField
            .<SpanToolUseValue> builder(MarshallingType.SDK_POJO).memberName("toolUse").getter(getter(SpanMessageValue::toolUse))
            .setter(setter(Builder::toolUse)).constructor(SpanToolUseValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()).build();

    private static final SdkField<SpanToolResultValue> TOOL_RESULT_FIELD = SdkField
            .<SpanToolResultValue> builder(MarshallingType.SDK_POJO).memberName("toolResult")
            .getter(getter(SpanMessageValue::toolResult)).setter(setter(Builder::toolResult))
            .constructor(SpanToolResultValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_FIELD,
            TOOL_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SpanTextValue text;

    private final SpanToolUseValue toolUse;

    private final SpanToolResultValue toolResult;

    private final Type type;

    private SpanMessageValue(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.type = builder.type;
    }

    /**
     * <p>
     * Text message content
     * </p>
     * 
     * @return Text message content
     */
    public final SpanTextValue text() {
        return text;
    }

    /**
     * <p>
     * Tool invocation message content
     * </p>
     * 
     * @return Tool invocation message content
     */
    public final SpanToolUseValue toolUse() {
        return toolUse;
    }

    /**
     * <p>
     * Tool result message content
     * </p>
     * 
     * @return Tool result message content
     */
    public final SpanToolResultValue toolResult() {
        return toolResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(toolResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanMessageValue)) {
            return false;
        }
        SpanMessageValue other = (SpanMessageValue) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(toolUse(), other.toolUse())
                && Objects.equals(toolResult(), other.toolResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpanMessageValue").add("Text", text()).add("ToolUse", toolUse()).add("ToolResult", toolResult())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "toolUse":
            return Optional.ofNullable(clazz.cast(toolUse()));
        case "toolResult":
            return Optional.ofNullable(clazz.cast(toolResult()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Text message content
     * </p>
     * 
     * @param text
     *        Text message content
     */
    public static SpanMessageValue fromText(SpanTextValue text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Text message content
     * </p>
     * 
     * @param text
     *        Text message content
     */
    public static SpanMessageValue fromText(Consumer<SpanTextValue.Builder> text) {
        SpanTextValue.Builder builder = SpanTextValue.builder();
        text.accept(builder);
        return fromText(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Tool invocation message content
     * </p>
     * 
     * @param toolUse
     *        Tool invocation message content
     */
    public static SpanMessageValue fromToolUse(SpanToolUseValue toolUse) {
        return builder().toolUse(toolUse).build();
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Tool invocation message content
     * </p>
     * 
     * @param toolUse
     *        Tool invocation message content
     */
    public static SpanMessageValue fromToolUse(Consumer<SpanToolUseValue.Builder> toolUse) {
        SpanToolUseValue.Builder builder = SpanToolUseValue.builder();
        toolUse.accept(builder);
        return fromToolUse(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * Tool result message content
     * </p>
     * 
     * @param toolResult
     *        Tool result message content
     */
    public static SpanMessageValue fromToolResult(SpanToolResultValue toolResult) {
        return builder().toolResult(toolResult).build();
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * Tool result message content
     * </p>
     * 
     * @param toolResult
     *        Tool result message content
     */
    public static SpanMessageValue fromToolResult(Consumer<SpanToolResultValue.Builder> toolResult) {
        SpanToolResultValue.Builder builder = SpanToolResultValue.builder();
        toolResult.accept(builder);
        return fromToolResult(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanMessageValue, T> g) {
        return obj -> g.apply((SpanMessageValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpanMessageValue> {
        /**
         * <p>
         * Text message content
         * </p>
         * 
         * @param text
         *        Text message content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(SpanTextValue text);

        /**
         * <p>
         * Text message content
         * </p>
         * This is a convenience method that creates an instance of the {@link SpanTextValue.Builder} avoiding the need
         * to create one manually via {@link SpanTextValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpanTextValue.Builder#build()} is called immediately and its
         * result is passed to {@link #text(SpanTextValue)}.
         * 
         * @param text
         *        a consumer that will call methods on {@link SpanTextValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #text(SpanTextValue)
         */
        default Builder text(Consumer<SpanTextValue.Builder> text) {
            return text(SpanTextValue.builder().applyMutation(text).build());
        }

        /**
         * <p>
         * Tool invocation message content
         * </p>
         * 
         * @param toolUse
         *        Tool invocation message content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUse(SpanToolUseValue toolUse);

        /**
         * <p>
         * Tool invocation message content
         * </p>
         * This is a convenience method that creates an instance of the {@link SpanToolUseValue.Builder} avoiding the
         * need to create one manually via {@link SpanToolUseValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpanToolUseValue.Builder#build()} is called immediately and its
         * result is passed to {@link #toolUse(SpanToolUseValue)}.
         * 
         * @param toolUse
         *        a consumer that will call methods on {@link SpanToolUseValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolUse(SpanToolUseValue)
         */
        default Builder toolUse(Consumer<SpanToolUseValue.Builder> toolUse) {
            return toolUse(SpanToolUseValue.builder().applyMutation(toolUse).build());
        }

        /**
         * <p>
         * Tool result message content
         * </p>
         * 
         * @param toolResult
         *        Tool result message content
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(SpanToolResultValue toolResult);

        /**
         * <p>
         * Tool result message content
         * </p>
         * This is a convenience method that creates an instance of the {@link SpanToolResultValue.Builder} avoiding the
         * need to create one manually via {@link SpanToolResultValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpanToolResultValue.Builder#build()} is called immediately and
         * its result is passed to {@link #toolResult(SpanToolResultValue)}.
         * 
         * @param toolResult
         *        a consumer that will call methods on {@link SpanToolResultValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolResult(SpanToolResultValue)
         */
        default Builder toolResult(Consumer<SpanToolResultValue.Builder> toolResult) {
            return toolResult(SpanToolResultValue.builder().applyMutation(toolResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpanTextValue text;

        private SpanToolUseValue toolUse;

        private SpanToolResultValue toolResult;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SpanMessageValue model) {
            text(model.text);
            toolUse(model.toolUse);
            toolResult(model.toolResult);
        }

        public final SpanTextValue.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        public final void setText(SpanTextValue.BuilderImpl text) {
            Object oldValue = this.text;
            this.text = text != null ? text.build() : null;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(SpanTextValue text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final SpanToolUseValue.Builder getToolUse() {
            return toolUse != null ? toolUse.toBuilder() : null;
        }

        public final void setToolUse(SpanToolUseValue.BuilderImpl toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(SpanToolUseValue toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final SpanToolResultValue.Builder getToolResult() {
            return toolResult != null ? toolResult.toBuilder() : null;
        }

        public final void setToolResult(SpanToolResultValue.BuilderImpl toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(SpanToolResultValue toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        @Override
        public SpanMessageValue build() {
            return new SpanMessageValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SpanMessageValue#type()
     */
    public enum Type {
        TEXT,

        TOOL_USE,

        TOOL_RESULT,

        UNKNOWN_TO_SDK_VERSION
    }
}
