/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contextual attributes capturing operation details, LLM configuration, usage metrics, and conversation data
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpanAttributes implements SdkPojo, Serializable, ToCopyableBuilder<SpanAttributes.Builder, SpanAttributes> {
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationName").getter(getter(SpanAttributes::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(SpanAttributes::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(SpanAttributes::errorType)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(SpanAttributes::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(SpanAttributes::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactId").getter(getter(SpanAttributes::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()).build();

    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initialContactId").getter(getter(SpanAttributes::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialContactId").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionName").getter(getter(SpanAttributes::sessionName)).setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()).build();

    private static final SdkField<String> AI_AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentArn").getter(getter(SpanAttributes::aiAgentArn)).setter(setter(Builder::aiAgentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentArn").build()).build();

    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentType").getter(getter(SpanAttributes::aiAgentTypeAsString)).setter(setter(Builder::aiAgentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentType").build()).build();

    private static final SdkField<String> AI_AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentName").getter(getter(SpanAttributes::aiAgentName)).setter(setter(Builder::aiAgentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentName").build()).build();

    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentId").getter(getter(SpanAttributes::aiAgentId)).setter(setter(Builder::aiAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()).build();

    private static final SdkField<Integer> AI_AGENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("aiAgentVersion").getter(getter(SpanAttributes::aiAgentVersion)).setter(setter(Builder::aiAgentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentVersion").build()).build();

    private static final SdkField<String> AI_AGENT_INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentInvoker").getter(getter(SpanAttributes::aiAgentInvoker)).setter(setter(Builder::aiAgentInvoker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentInvoker").build()).build();

    private static final SdkField<String> AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aiAgentOrchestratorUseCase")
            .getter(getter(SpanAttributes::aiAgentOrchestratorUseCase))
            .setter(setter(Builder::aiAgentOrchestratorUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentOrchestratorUseCase").build())
            .build();

    private static final SdkField<String> REQUEST_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestModel").getter(getter(SpanAttributes::requestModel)).setter(setter(Builder::requestModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModel").build()).build();

    private static final SdkField<Integer> REQUEST_MAX_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("requestMaxTokens").getter(getter(SpanAttributes::requestMaxTokens))
            .setter(setter(Builder::requestMaxTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMaxTokens").build()).build();

    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("temperature").getter(getter(SpanAttributes::temperature)).setter(setter(Builder::temperature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()).build();

    private static final SdkField<Float> TOPP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("topP")
            .getter(getter(SpanAttributes::topP)).setter(setter(Builder::topP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()).build();

    private static final SdkField<String> RESPONSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseModel").getter(getter(SpanAttributes::responseModel)).setter(setter(Builder::responseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModel").build()).build();

    private static final SdkField<List<String>> RESPONSE_FINISH_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("responseFinishReasons")
            .getter(getter(SpanAttributes::responseFinishReasons))
            .setter(setter(Builder::responseFinishReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseFinishReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> USAGE_INPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("usageInputTokens").getter(getter(SpanAttributes::usageInputTokens))
            .setter(setter(Builder::usageInputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageInputTokens").build()).build();

    private static final SdkField<Integer> USAGE_OUTPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("usageOutputTokens").getter(getter(SpanAttributes::usageOutputTokens))
            .setter(setter(Builder::usageOutputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageOutputTokens").build()).build();

    private static final SdkField<Integer> USAGE_TOTAL_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("usageTotalTokens").getter(getter(SpanAttributes::usageTotalTokens))
            .setter(setter(Builder::usageTotalTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTotalTokens").build()).build();

    private static final SdkField<Integer> CACHE_READ_INPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cacheReadInputTokens").getter(getter(SpanAttributes::cacheReadInputTokens))
            .setter(setter(Builder::cacheReadInputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheReadInputTokens").build())
            .build();

    private static final SdkField<Integer> CACHE_WRITE_INPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cacheWriteInputTokens").getter(getter(SpanAttributes::cacheWriteInputTokens))
            .setter(setter(Builder::cacheWriteInputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheWriteInputTokens").build())
            .build();

    private static final SdkField<List<SpanMessage>> INPUT_MESSAGES_FIELD = SdkField
            .<List<SpanMessage>> builder(MarshallingType.LIST)
            .memberName("inputMessages")
            .getter(getter(SpanAttributes::inputMessages))
            .setter(setter(Builder::inputMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SpanMessage>> OUTPUT_MESSAGES_FIELD = SdkField
            .<List<SpanMessage>> builder(MarshallingType.LIST)
            .memberName("outputMessages")
            .getter(getter(SpanAttributes::outputMessages))
            .setter(setter(Builder::outputMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SpanMessageValue>> SYSTEM_INSTRUCTIONS_FIELD = SdkField
            .<List<SpanMessageValue>> builder(MarshallingType.LIST)
            .memberName("systemInstructions")
            .getter(getter(SpanAttributes::systemInstructions))
            .setter(setter(Builder::systemInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpanMessageValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpanMessageValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptArn").getter(getter(SpanAttributes::promptArn)).setter(setter(Builder::promptArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptArn").build()).build();

    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptId").getter(getter(SpanAttributes::promptId)).setter(setter(Builder::promptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptId").build()).build();

    private static final SdkField<String> PROMPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptType").getter(getter(SpanAttributes::promptTypeAsString)).setter(setter(Builder::promptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptType").build()).build();

    private static final SdkField<String> PROMPT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptName").getter(getter(SpanAttributes::promptName)).setter(setter(Builder::promptName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptName").build()).build();

    private static final SdkField<Integer> PROMPT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("promptVersion").getter(getter(SpanAttributes::promptVersion)).setter(setter(Builder::promptVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_NAME_FIELD,
            PROVIDER_NAME_FIELD, ERROR_TYPE_FIELD, AGENT_ID_FIELD, INSTANCE_ARN_FIELD, CONTACT_ID_FIELD,
            INITIAL_CONTACT_ID_FIELD, SESSION_NAME_FIELD, AI_AGENT_ARN_FIELD, AI_AGENT_TYPE_FIELD, AI_AGENT_NAME_FIELD,
            AI_AGENT_ID_FIELD, AI_AGENT_VERSION_FIELD, AI_AGENT_INVOKER_FIELD, AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD,
            REQUEST_MODEL_FIELD, REQUEST_MAX_TOKENS_FIELD, TEMPERATURE_FIELD, TOPP_FIELD, RESPONSE_MODEL_FIELD,
            RESPONSE_FINISH_REASONS_FIELD, USAGE_INPUT_TOKENS_FIELD, USAGE_OUTPUT_TOKENS_FIELD, USAGE_TOTAL_TOKENS_FIELD,
            CACHE_READ_INPUT_TOKENS_FIELD, CACHE_WRITE_INPUT_TOKENS_FIELD, INPUT_MESSAGES_FIELD, OUTPUT_MESSAGES_FIELD,
            SYSTEM_INSTRUCTIONS_FIELD, PROMPT_ARN_FIELD, PROMPT_ID_FIELD, PROMPT_TYPE_FIELD, PROMPT_NAME_FIELD,
            PROMPT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operationName;

    private final String providerName;

    private final String errorType;

    private final String agentId;

    private final String instanceArn;

    private final String contactId;

    private final String initialContactId;

    private final String sessionName;

    private final String aiAgentArn;

    private final String aiAgentType;

    private final String aiAgentName;

    private final String aiAgentId;

    private final Integer aiAgentVersion;

    private final String aiAgentInvoker;

    private final String aiAgentOrchestratorUseCase;

    private final String requestModel;

    private final Integer requestMaxTokens;

    private final Float temperature;

    private final Float topP;

    private final String responseModel;

    private final List<String> responseFinishReasons;

    private final Integer usageInputTokens;

    private final Integer usageOutputTokens;

    private final Integer usageTotalTokens;

    private final Integer cacheReadInputTokens;

    private final Integer cacheWriteInputTokens;

    private final List<SpanMessage> inputMessages;

    private final List<SpanMessage> outputMessages;

    private final List<SpanMessageValue> systemInstructions;

    private final String promptArn;

    private final String promptId;

    private final String promptType;

    private final String promptName;

    private final Integer promptVersion;

    private SpanAttributes(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.providerName = builder.providerName;
        this.errorType = builder.errorType;
        this.agentId = builder.agentId;
        this.instanceArn = builder.instanceArn;
        this.contactId = builder.contactId;
        this.initialContactId = builder.initialContactId;
        this.sessionName = builder.sessionName;
        this.aiAgentArn = builder.aiAgentArn;
        this.aiAgentType = builder.aiAgentType;
        this.aiAgentName = builder.aiAgentName;
        this.aiAgentId = builder.aiAgentId;
        this.aiAgentVersion = builder.aiAgentVersion;
        this.aiAgentInvoker = builder.aiAgentInvoker;
        this.aiAgentOrchestratorUseCase = builder.aiAgentOrchestratorUseCase;
        this.requestModel = builder.requestModel;
        this.requestMaxTokens = builder.requestMaxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.responseModel = builder.responseModel;
        this.responseFinishReasons = builder.responseFinishReasons;
        this.usageInputTokens = builder.usageInputTokens;
        this.usageOutputTokens = builder.usageOutputTokens;
        this.usageTotalTokens = builder.usageTotalTokens;
        this.cacheReadInputTokens = builder.cacheReadInputTokens;
        this.cacheWriteInputTokens = builder.cacheWriteInputTokens;
        this.inputMessages = builder.inputMessages;
        this.outputMessages = builder.outputMessages;
        this.systemInstructions = builder.systemInstructions;
        this.promptArn = builder.promptArn;
        this.promptId = builder.promptId;
        this.promptType = builder.promptType;
        this.promptName = builder.promptName;
        this.promptVersion = builder.promptVersion;
    }

    /**
     * <p>
     * Action being performed
     * </p>
     * 
     * @return Action being performed
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * Model provider identifier (e.g., aws.bedrock)
     * </p>
     * 
     * @return Model provider identifier (e.g., aws.bedrock)
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * Error classification if span failed (e.g., throttle, timeout)
     * </p>
     * 
     * @return Error classification if span failed (e.g., throttle, timeout)
     */
    public final String errorType() {
        return errorType;
    }

    /**
     * <p>
     * Amazon Connect agent ID
     * </p>
     * 
     * @return Amazon Connect agent ID
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Amazon Connect instance ARN
     * </p>
     * 
     * @return Amazon Connect instance ARN
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Amazon Connect contact identifier
     * </p>
     * 
     * @return Amazon Connect contact identifier
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * Amazon Connect contact identifier
     * </p>
     * 
     * @return Amazon Connect contact identifier
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * Session name
     * </p>
     * 
     * @return Session name
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * AI agent ARN
     * </p>
     * 
     * @return AI agent ARN
     */
    public final String aiAgentArn() {
        return aiAgentArn;
    }

    /**
     * <p>
     * AI agent type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return AI agent type
     * @see AIAgentType
     */
    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(aiAgentType);
    }

    /**
     * <p>
     * AI agent type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return AI agent type
     * @see AIAgentType
     */
    public final String aiAgentTypeAsString() {
        return aiAgentType;
    }

    /**
     * <p>
     * AI agent name
     * </p>
     * 
     * @return AI agent name
     */
    public final String aiAgentName() {
        return aiAgentName;
    }

    /**
     * <p>
     * AI agent identifier
     * </p>
     * 
     * @return AI agent identifier
     */
    public final String aiAgentId() {
        return aiAgentId;
    }

    /**
     * <p>
     * AI agent version number
     * </p>
     * 
     * @return AI agent version number
     */
    public final Integer aiAgentVersion() {
        return aiAgentVersion;
    }

    /**
     * <p>
     * Entity that invoked the AI agent
     * </p>
     * 
     * @return Entity that invoked the AI agent
     */
    public final String aiAgentInvoker() {
        return aiAgentInvoker;
    }

    /**
     * <p>
     * AI agent orchestrator use case
     * </p>
     * 
     * @return AI agent orchestrator use case
     */
    public final String aiAgentOrchestratorUseCase() {
        return aiAgentOrchestratorUseCase;
    }

    /**
     * <p>
     * LLM model ID for request (e.g., anthropic.claude-3-sonnet)
     * </p>
     * 
     * @return LLM model ID for request (e.g., anthropic.claude-3-sonnet)
     */
    public final String requestModel() {
        return requestModel;
    }

    /**
     * <p>
     * Maximum tokens configured for generation
     * </p>
     * 
     * @return Maximum tokens configured for generation
     */
    public final Integer requestMaxTokens() {
        return requestMaxTokens;
    }

    /**
     * <p>
     * Sampling temperature for generation
     * </p>
     * 
     * @return Sampling temperature for generation
     */
    public final Float temperature() {
        return temperature;
    }

    /**
     * <p>
     * Top-p sampling parameter for generation
     * </p>
     * 
     * @return Top-p sampling parameter for generation
     */
    public final Float topP() {
        return topP;
    }

    /**
     * <p>
     * Actual model used for response (usually matches requestModel)
     * </p>
     * 
     * @return Actual model used for response (usually matches requestModel)
     */
    public final String responseModel() {
        return responseModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseFinishReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponseFinishReasons() {
        return responseFinishReasons != null && !(responseFinishReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Generation termination reasons (e.g., stop, max_tokens)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseFinishReasons} method.
     * </p>
     * 
     * @return Generation termination reasons (e.g., stop, max_tokens)
     */
    public final List<String> responseFinishReasons() {
        return responseFinishReasons;
    }

    /**
     * <p>
     * Number of input tokens in prompt
     * </p>
     * 
     * @return Number of input tokens in prompt
     */
    public final Integer usageInputTokens() {
        return usageInputTokens;
    }

    /**
     * <p>
     * Number of output tokens in response
     * </p>
     * 
     * @return Number of output tokens in response
     */
    public final Integer usageOutputTokens() {
        return usageOutputTokens;
    }

    /**
     * <p>
     * Total tokens consumed (input + output)
     * </p>
     * 
     * @return Total tokens consumed (input + output)
     */
    public final Integer usageTotalTokens() {
        return usageTotalTokens;
    }

    /**
     * <p>
     * Number of input tokens that were retrieved from cache
     * </p>
     * 
     * @return Number of input tokens that were retrieved from cache
     */
    public final Integer cacheReadInputTokens() {
        return cacheReadInputTokens;
    }

    /**
     * <p>
     * Number of input tokens that were written to cache in this request
     * </p>
     * 
     * @return Number of input tokens that were written to cache in this request
     */
    public final Integer cacheWriteInputTokens() {
        return cacheWriteInputTokens;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputMessages() {
        return inputMessages != null && !(inputMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Input message collection sent to LLM
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputMessages} method.
     * </p>
     * 
     * @return Input message collection sent to LLM
     */
    public final List<SpanMessage> inputMessages() {
        return inputMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputMessages() {
        return outputMessages != null && !(outputMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Output message collection received from LLM
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputMessages} method.
     * </p>
     * 
     * @return Output message collection received from LLM
     */
    public final List<SpanMessage> outputMessages() {
        return outputMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the SystemInstructions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSystemInstructions() {
        return systemInstructions != null && !(systemInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * System prompt instructions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystemInstructions} method.
     * </p>
     * 
     * @return System prompt instructions
     */
    public final List<SpanMessageValue> systemInstructions() {
        return systemInstructions;
    }

    /**
     * <p>
     * AI prompt ARN
     * </p>
     * 
     * @return AI prompt ARN
     */
    public final String promptArn() {
        return promptArn;
    }

    /**
     * <p>
     * AI prompt identifier
     * </p>
     * 
     * @return AI prompt identifier
     */
    public final String promptId() {
        return promptId;
    }

    /**
     * <p>
     * AI prompt type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptType} will
     * return {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptTypeAsString}.
     * </p>
     * 
     * @return AI prompt type
     * @see AIPromptType
     */
    public final AIPromptType promptType() {
        return AIPromptType.fromValue(promptType);
    }

    /**
     * <p>
     * AI prompt type
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptType} will
     * return {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptTypeAsString}.
     * </p>
     * 
     * @return AI prompt type
     * @see AIPromptType
     */
    public final String promptTypeAsString() {
        return promptType;
    }

    /**
     * <p>
     * AI prompt name
     * </p>
     * 
     * @return AI prompt name
     */
    public final String promptName() {
        return promptName;
    }

    /**
     * <p>
     * AI prompt version number
     * </p>
     * 
     * @return AI prompt version number
     */
    public final Integer promptVersion() {
        return promptVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(errorType());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentName());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentInvoker());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentOrchestratorUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(requestModel());
        hashCode = 31 * hashCode + Objects.hashCode(requestMaxTokens());
        hashCode = 31 * hashCode + Objects.hashCode(temperature());
        hashCode = 31 * hashCode + Objects.hashCode(topP());
        hashCode = 31 * hashCode + Objects.hashCode(responseModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseFinishReasons() ? responseFinishReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usageInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(usageOutputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(usageTotalTokens());
        hashCode = 31 * hashCode + Objects.hashCode(cacheReadInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(cacheWriteInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputMessages() ? inputMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputMessages() ? outputMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSystemInstructions() ? systemInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(promptArn());
        hashCode = 31 * hashCode + Objects.hashCode(promptId());
        hashCode = 31 * hashCode + Objects.hashCode(promptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptName());
        hashCode = 31 * hashCode + Objects.hashCode(promptVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanAttributes)) {
            return false;
        }
        SpanAttributes other = (SpanAttributes) obj;
        return Objects.equals(operationName(), other.operationName()) && Objects.equals(providerName(), other.providerName())
                && Objects.equals(errorType(), other.errorType()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(initialContactId(), other.initialContactId())
                && Objects.equals(sessionName(), other.sessionName()) && Objects.equals(aiAgentArn(), other.aiAgentArn())
                && Objects.equals(aiAgentTypeAsString(), other.aiAgentTypeAsString())
                && Objects.equals(aiAgentName(), other.aiAgentName()) && Objects.equals(aiAgentId(), other.aiAgentId())
                && Objects.equals(aiAgentVersion(), other.aiAgentVersion())
                && Objects.equals(aiAgentInvoker(), other.aiAgentInvoker())
                && Objects.equals(aiAgentOrchestratorUseCase(), other.aiAgentOrchestratorUseCase())
                && Objects.equals(requestModel(), other.requestModel())
                && Objects.equals(requestMaxTokens(), other.requestMaxTokens())
                && Objects.equals(temperature(), other.temperature()) && Objects.equals(topP(), other.topP())
                && Objects.equals(responseModel(), other.responseModel())
                && hasResponseFinishReasons() == other.hasResponseFinishReasons()
                && Objects.equals(responseFinishReasons(), other.responseFinishReasons())
                && Objects.equals(usageInputTokens(), other.usageInputTokens())
                && Objects.equals(usageOutputTokens(), other.usageOutputTokens())
                && Objects.equals(usageTotalTokens(), other.usageTotalTokens())
                && Objects.equals(cacheReadInputTokens(), other.cacheReadInputTokens())
                && Objects.equals(cacheWriteInputTokens(), other.cacheWriteInputTokens())
                && hasInputMessages() == other.hasInputMessages() && Objects.equals(inputMessages(), other.inputMessages())
                && hasOutputMessages() == other.hasOutputMessages() && Objects.equals(outputMessages(), other.outputMessages())
                && hasSystemInstructions() == other.hasSystemInstructions()
                && Objects.equals(systemInstructions(), other.systemInstructions())
                && Objects.equals(promptArn(), other.promptArn()) && Objects.equals(promptId(), other.promptId())
                && Objects.equals(promptTypeAsString(), other.promptTypeAsString())
                && Objects.equals(promptName(), other.promptName()) && Objects.equals(promptVersion(), other.promptVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpanAttributes").add("OperationName", operationName()).add("ProviderName", providerName())
                .add("ErrorType", errorType()).add("AgentId", agentId()).add("InstanceArn", instanceArn())
                .add("ContactId", contactId()).add("InitialContactId", initialContactId()).add("SessionName", sessionName())
                .add("AiAgentArn", aiAgentArn()).add("AiAgentType", aiAgentTypeAsString()).add("AiAgentName", aiAgentName())
                .add("AiAgentId", aiAgentId()).add("AiAgentVersion", aiAgentVersion()).add("AiAgentInvoker", aiAgentInvoker())
                .add("AiAgentOrchestratorUseCase", aiAgentOrchestratorUseCase()).add("RequestModel", requestModel())
                .add("RequestMaxTokens", requestMaxTokens()).add("Temperature", temperature()).add("TopP", topP())
                .add("ResponseModel", responseModel())
                .add("ResponseFinishReasons", hasResponseFinishReasons() ? responseFinishReasons() : null)
                .add("UsageInputTokens", usageInputTokens()).add("UsageOutputTokens", usageOutputTokens())
                .add("UsageTotalTokens", usageTotalTokens()).add("CacheReadInputTokens", cacheReadInputTokens())
                .add("CacheWriteInputTokens", cacheWriteInputTokens())
                .add("InputMessages", hasInputMessages() ? inputMessages() : null)
                .add("OutputMessages", hasOutputMessages() ? outputMessages() : null)
                .add("SystemInstructions", hasSystemInstructions() ? systemInstructions() : null).add("PromptArn", promptArn())
                .add("PromptId", promptId()).add("PromptType", promptTypeAsString()).add("PromptName", promptName())
                .add("PromptVersion", promptVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorType()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "contactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "initialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "sessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "aiAgentArn":
            return Optional.ofNullable(clazz.cast(aiAgentArn()));
        case "aiAgentType":
            return Optional.ofNullable(clazz.cast(aiAgentTypeAsString()));
        case "aiAgentName":
            return Optional.ofNullable(clazz.cast(aiAgentName()));
        case "aiAgentId":
            return Optional.ofNullable(clazz.cast(aiAgentId()));
        case "aiAgentVersion":
            return Optional.ofNullable(clazz.cast(aiAgentVersion()));
        case "aiAgentInvoker":
            return Optional.ofNullable(clazz.cast(aiAgentInvoker()));
        case "aiAgentOrchestratorUseCase":
            return Optional.ofNullable(clazz.cast(aiAgentOrchestratorUseCase()));
        case "requestModel":
            return Optional.ofNullable(clazz.cast(requestModel()));
        case "requestMaxTokens":
            return Optional.ofNullable(clazz.cast(requestMaxTokens()));
        case "temperature":
            return Optional.ofNullable(clazz.cast(temperature()));
        case "topP":
            return Optional.ofNullable(clazz.cast(topP()));
        case "responseModel":
            return Optional.ofNullable(clazz.cast(responseModel()));
        case "responseFinishReasons":
            return Optional.ofNullable(clazz.cast(responseFinishReasons()));
        case "usageInputTokens":
            return Optional.ofNullable(clazz.cast(usageInputTokens()));
        case "usageOutputTokens":
            return Optional.ofNullable(clazz.cast(usageOutputTokens()));
        case "usageTotalTokens":
            return Optional.ofNullable(clazz.cast(usageTotalTokens()));
        case "cacheReadInputTokens":
            return Optional.ofNullable(clazz.cast(cacheReadInputTokens()));
        case "cacheWriteInputTokens":
            return Optional.ofNullable(clazz.cast(cacheWriteInputTokens()));
        case "inputMessages":
            return Optional.ofNullable(clazz.cast(inputMessages()));
        case "outputMessages":
            return Optional.ofNullable(clazz.cast(outputMessages()));
        case "systemInstructions":
            return Optional.ofNullable(clazz.cast(systemInstructions()));
        case "promptArn":
            return Optional.ofNullable(clazz.cast(promptArn()));
        case "promptId":
            return Optional.ofNullable(clazz.cast(promptId()));
        case "promptType":
            return Optional.ofNullable(clazz.cast(promptTypeAsString()));
        case "promptName":
            return Optional.ofNullable(clazz.cast(promptName()));
        case "promptVersion":
            return Optional.ofNullable(clazz.cast(promptVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationName", OPERATION_NAME_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("contactId", CONTACT_ID_FIELD);
        map.put("initialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("aiAgentArn", AI_AGENT_ARN_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("aiAgentName", AI_AGENT_NAME_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("aiAgentVersion", AI_AGENT_VERSION_FIELD);
        map.put("aiAgentInvoker", AI_AGENT_INVOKER_FIELD);
        map.put("aiAgentOrchestratorUseCase", AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD);
        map.put("requestModel", REQUEST_MODEL_FIELD);
        map.put("requestMaxTokens", REQUEST_MAX_TOKENS_FIELD);
        map.put("temperature", TEMPERATURE_FIELD);
        map.put("topP", TOPP_FIELD);
        map.put("responseModel", RESPONSE_MODEL_FIELD);
        map.put("responseFinishReasons", RESPONSE_FINISH_REASONS_FIELD);
        map.put("usageInputTokens", USAGE_INPUT_TOKENS_FIELD);
        map.put("usageOutputTokens", USAGE_OUTPUT_TOKENS_FIELD);
        map.put("usageTotalTokens", USAGE_TOTAL_TOKENS_FIELD);
        map.put("cacheReadInputTokens", CACHE_READ_INPUT_TOKENS_FIELD);
        map.put("cacheWriteInputTokens", CACHE_WRITE_INPUT_TOKENS_FIELD);
        map.put("inputMessages", INPUT_MESSAGES_FIELD);
        map.put("outputMessages", OUTPUT_MESSAGES_FIELD);
        map.put("systemInstructions", SYSTEM_INSTRUCTIONS_FIELD);
        map.put("promptArn", PROMPT_ARN_FIELD);
        map.put("promptId", PROMPT_ID_FIELD);
        map.put("promptType", PROMPT_TYPE_FIELD);
        map.put("promptName", PROMPT_NAME_FIELD);
        map.put("promptVersion", PROMPT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanAttributes, T> g) {
        return obj -> g.apply((SpanAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpanAttributes> {
        /**
         * <p>
         * Action being performed
         * </p>
         * 
         * @param operationName
         *        Action being performed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * Model provider identifier (e.g., aws.bedrock)
         * </p>
         * 
         * @param providerName
         *        Model provider identifier (e.g., aws.bedrock)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * Error classification if span failed (e.g., throttle, timeout)
         * </p>
         * 
         * @param errorType
         *        Error classification if span failed (e.g., throttle, timeout)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * Amazon Connect agent ID
         * </p>
         * 
         * @param agentId
         *        Amazon Connect agent ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Amazon Connect instance ARN
         * </p>
         * 
         * @param instanceArn
         *        Amazon Connect instance ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Amazon Connect contact identifier
         * </p>
         * 
         * @param contactId
         *        Amazon Connect contact identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * Amazon Connect contact identifier
         * </p>
         * 
         * @param initialContactId
         *        Amazon Connect contact identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * Session name
         * </p>
         * 
         * @param sessionName
         *        Session name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * AI agent ARN
         * </p>
         * 
         * @param aiAgentArn
         *        AI agent ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentArn(String aiAgentArn);

        /**
         * <p>
         * AI agent type
         * </p>
         * 
         * @param aiAgentType
         *        AI agent type
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(String aiAgentType);

        /**
         * <p>
         * AI agent type
         * </p>
         * 
         * @param aiAgentType
         *        AI agent type
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(AIAgentType aiAgentType);

        /**
         * <p>
         * AI agent name
         * </p>
         * 
         * @param aiAgentName
         *        AI agent name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentName(String aiAgentName);

        /**
         * <p>
         * AI agent identifier
         * </p>
         * 
         * @param aiAgentId
         *        AI agent identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentId(String aiAgentId);

        /**
         * <p>
         * AI agent version number
         * </p>
         * 
         * @param aiAgentVersion
         *        AI agent version number
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentVersion(Integer aiAgentVersion);

        /**
         * <p>
         * Entity that invoked the AI agent
         * </p>
         * 
         * @param aiAgentInvoker
         *        Entity that invoked the AI agent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentInvoker(String aiAgentInvoker);

        /**
         * <p>
         * AI agent orchestrator use case
         * </p>
         * 
         * @param aiAgentOrchestratorUseCase
         *        AI agent orchestrator use case
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentOrchestratorUseCase(String aiAgentOrchestratorUseCase);

        /**
         * <p>
         * LLM model ID for request (e.g., anthropic.claude-3-sonnet)
         * </p>
         * 
         * @param requestModel
         *        LLM model ID for request (e.g., anthropic.claude-3-sonnet)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestModel(String requestModel);

        /**
         * <p>
         * Maximum tokens configured for generation
         * </p>
         * 
         * @param requestMaxTokens
         *        Maximum tokens configured for generation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMaxTokens(Integer requestMaxTokens);

        /**
         * <p>
         * Sampling temperature for generation
         * </p>
         * 
         * @param temperature
         *        Sampling temperature for generation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temperature(Float temperature);

        /**
         * <p>
         * Top-p sampling parameter for generation
         * </p>
         * 
         * @param topP
         *        Top-p sampling parameter for generation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topP(Float topP);

        /**
         * <p>
         * Actual model used for response (usually matches requestModel)
         * </p>
         * 
         * @param responseModel
         *        Actual model used for response (usually matches requestModel)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseModel(String responseModel);

        /**
         * <p>
         * Generation termination reasons (e.g., stop, max_tokens)
         * </p>
         * 
         * @param responseFinishReasons
         *        Generation termination reasons (e.g., stop, max_tokens)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseFinishReasons(Collection<String> responseFinishReasons);

        /**
         * <p>
         * Generation termination reasons (e.g., stop, max_tokens)
         * </p>
         * 
         * @param responseFinishReasons
         *        Generation termination reasons (e.g., stop, max_tokens)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseFinishReasons(String... responseFinishReasons);

        /**
         * <p>
         * Number of input tokens in prompt
         * </p>
         * 
         * @param usageInputTokens
         *        Number of input tokens in prompt
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageInputTokens(Integer usageInputTokens);

        /**
         * <p>
         * Number of output tokens in response
         * </p>
         * 
         * @param usageOutputTokens
         *        Number of output tokens in response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOutputTokens(Integer usageOutputTokens);

        /**
         * <p>
         * Total tokens consumed (input + output)
         * </p>
         * 
         * @param usageTotalTokens
         *        Total tokens consumed (input + output)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTotalTokens(Integer usageTotalTokens);

        /**
         * <p>
         * Number of input tokens that were retrieved from cache
         * </p>
         * 
         * @param cacheReadInputTokens
         *        Number of input tokens that were retrieved from cache
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheReadInputTokens(Integer cacheReadInputTokens);

        /**
         * <p>
         * Number of input tokens that were written to cache in this request
         * </p>
         * 
         * @param cacheWriteInputTokens
         *        Number of input tokens that were written to cache in this request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheWriteInputTokens(Integer cacheWriteInputTokens);

        /**
         * <p>
         * Input message collection sent to LLM
         * </p>
         * 
         * @param inputMessages
         *        Input message collection sent to LLM
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputMessages(Collection<SpanMessage> inputMessages);

        /**
         * <p>
         * Input message collection sent to LLM
         * </p>
         * 
         * @param inputMessages
         *        Input message collection sent to LLM
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputMessages(SpanMessage... inputMessages);

        /**
         * <p>
         * Input message collection sent to LLM
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.SpanMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #inputMessages(List<SpanMessage>)}.
         * 
         * @param inputMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputMessages(java.util.Collection<SpanMessage>)
         */
        Builder inputMessages(Consumer<SpanMessage.Builder>... inputMessages);

        /**
         * <p>
         * Output message collection received from LLM
         * </p>
         * 
         * @param outputMessages
         *        Output message collection received from LLM
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputMessages(Collection<SpanMessage> outputMessages);

        /**
         * <p>
         * Output message collection received from LLM
         * </p>
         * 
         * @param outputMessages
         *        Output message collection received from LLM
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputMessages(SpanMessage... outputMessages);

        /**
         * <p>
         * Output message collection received from LLM
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.SpanMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #outputMessages(List<SpanMessage>)}.
         * 
         * @param outputMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputMessages(java.util.Collection<SpanMessage>)
         */
        Builder outputMessages(Consumer<SpanMessage.Builder>... outputMessages);

        /**
         * <p>
         * System prompt instructions
         * </p>
         * 
         * @param systemInstructions
         *        System prompt instructions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInstructions(Collection<SpanMessageValue> systemInstructions);

        /**
         * <p>
         * System prompt instructions
         * </p>
         * 
         * @param systemInstructions
         *        System prompt instructions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInstructions(SpanMessageValue... systemInstructions);

        /**
         * <p>
         * System prompt instructions
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder#build()} is called immediately
         * and its result is passed to {@link #systemInstructions(List<SpanMessageValue>)}.
         * 
         * @param systemInstructions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.SpanMessageValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemInstructions(java.util.Collection<SpanMessageValue>)
         */
        Builder systemInstructions(Consumer<SpanMessageValue.Builder>... systemInstructions);

        /**
         * <p>
         * AI prompt ARN
         * </p>
         * 
         * @param promptArn
         *        AI prompt ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptArn(String promptArn);

        /**
         * <p>
         * AI prompt identifier
         * </p>
         * 
         * @param promptId
         *        AI prompt identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptId(String promptId);

        /**
         * <p>
         * AI prompt type
         * </p>
         * 
         * @param promptType
         *        AI prompt type
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder promptType(String promptType);

        /**
         * <p>
         * AI prompt type
         * </p>
         * 
         * @param promptType
         *        AI prompt type
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder promptType(AIPromptType promptType);

        /**
         * <p>
         * AI prompt name
         * </p>
         * 
         * @param promptName
         *        AI prompt name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptName(String promptName);

        /**
         * <p>
         * AI prompt version number
         * </p>
         * 
         * @param promptVersion
         *        AI prompt version number
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptVersion(Integer promptVersion);
    }

    static final class BuilderImpl implements Builder {
        private String operationName;

        private String providerName;

        private String errorType;

        private String agentId;

        private String instanceArn;

        private String contactId;

        private String initialContactId;

        private String sessionName;

        private String aiAgentArn;

        private String aiAgentType;

        private String aiAgentName;

        private String aiAgentId;

        private Integer aiAgentVersion;

        private String aiAgentInvoker;

        private String aiAgentOrchestratorUseCase;

        private String requestModel;

        private Integer requestMaxTokens;

        private Float temperature;

        private Float topP;

        private String responseModel;

        private List<String> responseFinishReasons = DefaultSdkAutoConstructList.getInstance();

        private Integer usageInputTokens;

        private Integer usageOutputTokens;

        private Integer usageTotalTokens;

        private Integer cacheReadInputTokens;

        private Integer cacheWriteInputTokens;

        private List<SpanMessage> inputMessages = DefaultSdkAutoConstructList.getInstance();

        private List<SpanMessage> outputMessages = DefaultSdkAutoConstructList.getInstance();

        private List<SpanMessageValue> systemInstructions = DefaultSdkAutoConstructList.getInstance();

        private String promptArn;

        private String promptId;

        private String promptType;

        private String promptName;

        private Integer promptVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanAttributes model) {
            operationName(model.operationName);
            providerName(model.providerName);
            errorType(model.errorType);
            agentId(model.agentId);
            instanceArn(model.instanceArn);
            contactId(model.contactId);
            initialContactId(model.initialContactId);
            sessionName(model.sessionName);
            aiAgentArn(model.aiAgentArn);
            aiAgentType(model.aiAgentType);
            aiAgentName(model.aiAgentName);
            aiAgentId(model.aiAgentId);
            aiAgentVersion(model.aiAgentVersion);
            aiAgentInvoker(model.aiAgentInvoker);
            aiAgentOrchestratorUseCase(model.aiAgentOrchestratorUseCase);
            requestModel(model.requestModel);
            requestMaxTokens(model.requestMaxTokens);
            temperature(model.temperature);
            topP(model.topP);
            responseModel(model.responseModel);
            responseFinishReasons(model.responseFinishReasons);
            usageInputTokens(model.usageInputTokens);
            usageOutputTokens(model.usageOutputTokens);
            usageTotalTokens(model.usageTotalTokens);
            cacheReadInputTokens(model.cacheReadInputTokens);
            cacheWriteInputTokens(model.cacheWriteInputTokens);
            inputMessages(model.inputMessages);
            outputMessages(model.outputMessages);
            systemInstructions(model.systemInstructions);
            promptArn(model.promptArn);
            promptId(model.promptId);
            promptType(model.promptType);
            promptName(model.promptName);
            promptVersion(model.promptVersion);
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getSessionName() {
            return sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final String getAiAgentArn() {
            return aiAgentArn;
        }

        public final void setAiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
        }

        @Override
        public final Builder aiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
            return this;
        }

        public final String getAiAgentType() {
            return aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final String getAiAgentName() {
            return aiAgentName;
        }

        public final void setAiAgentName(String aiAgentName) {
            this.aiAgentName = aiAgentName;
        }

        @Override
        public final Builder aiAgentName(String aiAgentName) {
            this.aiAgentName = aiAgentName;
            return this;
        }

        public final String getAiAgentId() {
            return aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final Integer getAiAgentVersion() {
            return aiAgentVersion;
        }

        public final void setAiAgentVersion(Integer aiAgentVersion) {
            this.aiAgentVersion = aiAgentVersion;
        }

        @Override
        public final Builder aiAgentVersion(Integer aiAgentVersion) {
            this.aiAgentVersion = aiAgentVersion;
            return this;
        }

        public final String getAiAgentInvoker() {
            return aiAgentInvoker;
        }

        public final void setAiAgentInvoker(String aiAgentInvoker) {
            this.aiAgentInvoker = aiAgentInvoker;
        }

        @Override
        public final Builder aiAgentInvoker(String aiAgentInvoker) {
            this.aiAgentInvoker = aiAgentInvoker;
            return this;
        }

        public final String getAiAgentOrchestratorUseCase() {
            return aiAgentOrchestratorUseCase;
        }

        public final void setAiAgentOrchestratorUseCase(String aiAgentOrchestratorUseCase) {
            this.aiAgentOrchestratorUseCase = aiAgentOrchestratorUseCase;
        }

        @Override
        public final Builder aiAgentOrchestratorUseCase(String aiAgentOrchestratorUseCase) {
            this.aiAgentOrchestratorUseCase = aiAgentOrchestratorUseCase;
            return this;
        }

        public final String getRequestModel() {
            return requestModel;
        }

        public final void setRequestModel(String requestModel) {
            this.requestModel = requestModel;
        }

        @Override
        public final Builder requestModel(String requestModel) {
            this.requestModel = requestModel;
            return this;
        }

        public final Integer getRequestMaxTokens() {
            return requestMaxTokens;
        }

        public final void setRequestMaxTokens(Integer requestMaxTokens) {
            this.requestMaxTokens = requestMaxTokens;
        }

        @Override
        public final Builder requestMaxTokens(Integer requestMaxTokens) {
            this.requestMaxTokens = requestMaxTokens;
            return this;
        }

        public final Float getTemperature() {
            return temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final String getResponseModel() {
            return responseModel;
        }

        public final void setResponseModel(String responseModel) {
            this.responseModel = responseModel;
        }

        @Override
        public final Builder responseModel(String responseModel) {
            this.responseModel = responseModel;
            return this;
        }

        public final Collection<String> getResponseFinishReasons() {
            if (responseFinishReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return responseFinishReasons;
        }

        public final void setResponseFinishReasons(Collection<String> responseFinishReasons) {
            this.responseFinishReasons = SpanFinishReasonListCopier.copy(responseFinishReasons);
        }

        @Override
        public final Builder responseFinishReasons(Collection<String> responseFinishReasons) {
            this.responseFinishReasons = SpanFinishReasonListCopier.copy(responseFinishReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseFinishReasons(String... responseFinishReasons) {
            responseFinishReasons(Arrays.asList(responseFinishReasons));
            return this;
        }

        public final Integer getUsageInputTokens() {
            return usageInputTokens;
        }

        public final void setUsageInputTokens(Integer usageInputTokens) {
            this.usageInputTokens = usageInputTokens;
        }

        @Override
        public final Builder usageInputTokens(Integer usageInputTokens) {
            this.usageInputTokens = usageInputTokens;
            return this;
        }

        public final Integer getUsageOutputTokens() {
            return usageOutputTokens;
        }

        public final void setUsageOutputTokens(Integer usageOutputTokens) {
            this.usageOutputTokens = usageOutputTokens;
        }

        @Override
        public final Builder usageOutputTokens(Integer usageOutputTokens) {
            this.usageOutputTokens = usageOutputTokens;
            return this;
        }

        public final Integer getUsageTotalTokens() {
            return usageTotalTokens;
        }

        public final void setUsageTotalTokens(Integer usageTotalTokens) {
            this.usageTotalTokens = usageTotalTokens;
        }

        @Override
        public final Builder usageTotalTokens(Integer usageTotalTokens) {
            this.usageTotalTokens = usageTotalTokens;
            return this;
        }

        public final Integer getCacheReadInputTokens() {
            return cacheReadInputTokens;
        }

        public final void setCacheReadInputTokens(Integer cacheReadInputTokens) {
            this.cacheReadInputTokens = cacheReadInputTokens;
        }

        @Override
        public final Builder cacheReadInputTokens(Integer cacheReadInputTokens) {
            this.cacheReadInputTokens = cacheReadInputTokens;
            return this;
        }

        public final Integer getCacheWriteInputTokens() {
            return cacheWriteInputTokens;
        }

        public final void setCacheWriteInputTokens(Integer cacheWriteInputTokens) {
            this.cacheWriteInputTokens = cacheWriteInputTokens;
        }

        @Override
        public final Builder cacheWriteInputTokens(Integer cacheWriteInputTokens) {
            this.cacheWriteInputTokens = cacheWriteInputTokens;
            return this;
        }

        public final List<SpanMessage.Builder> getInputMessages() {
            List<SpanMessage.Builder> result = SpanMessageListCopier.copyToBuilder(this.inputMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputMessages(Collection<SpanMessage.BuilderImpl> inputMessages) {
            this.inputMessages = SpanMessageListCopier.copyFromBuilder(inputMessages);
        }

        @Override
        public final Builder inputMessages(Collection<SpanMessage> inputMessages) {
            this.inputMessages = SpanMessageListCopier.copy(inputMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputMessages(SpanMessage... inputMessages) {
            inputMessages(Arrays.asList(inputMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputMessages(Consumer<SpanMessage.Builder>... inputMessages) {
            inputMessages(Stream.of(inputMessages).map(c -> SpanMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SpanMessage.Builder> getOutputMessages() {
            List<SpanMessage.Builder> result = SpanMessageListCopier.copyToBuilder(this.outputMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputMessages(Collection<SpanMessage.BuilderImpl> outputMessages) {
            this.outputMessages = SpanMessageListCopier.copyFromBuilder(outputMessages);
        }

        @Override
        public final Builder outputMessages(Collection<SpanMessage> outputMessages) {
            this.outputMessages = SpanMessageListCopier.copy(outputMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputMessages(SpanMessage... outputMessages) {
            outputMessages(Arrays.asList(outputMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputMessages(Consumer<SpanMessage.Builder>... outputMessages) {
            outputMessages(Stream.of(outputMessages).map(c -> SpanMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SpanMessageValue.Builder> getSystemInstructions() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.systemInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemInstructions(Collection<SpanMessageValue.BuilderImpl> systemInstructions) {
            this.systemInstructions = SpanMessageValueListCopier.copyFromBuilder(systemInstructions);
        }

        @Override
        public final Builder systemInstructions(Collection<SpanMessageValue> systemInstructions) {
            this.systemInstructions = SpanMessageValueListCopier.copy(systemInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInstructions(SpanMessageValue... systemInstructions) {
            systemInstructions(Arrays.asList(systemInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInstructions(Consumer<SpanMessageValue.Builder>... systemInstructions) {
            systemInstructions(Stream.of(systemInstructions).map(c -> SpanMessageValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPromptArn() {
            return promptArn;
        }

        public final void setPromptArn(String promptArn) {
            this.promptArn = promptArn;
        }

        @Override
        public final Builder promptArn(String promptArn) {
            this.promptArn = promptArn;
            return this;
        }

        public final String getPromptId() {
            return promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public final String getPromptType() {
            return promptType;
        }

        public final void setPromptType(String promptType) {
            this.promptType = promptType;
        }

        @Override
        public final Builder promptType(String promptType) {
            this.promptType = promptType;
            return this;
        }

        @Override
        public final Builder promptType(AIPromptType promptType) {
            this.promptType(promptType == null ? null : promptType.toString());
            return this;
        }

        public final String getPromptName() {
            return promptName;
        }

        public final void setPromptName(String promptName) {
            this.promptName = promptName;
        }

        @Override
        public final Builder promptName(String promptName) {
            this.promptName = promptName;
            return this;
        }

        public final Integer getPromptVersion() {
            return promptVersion;
        }

        public final void setPromptVersion(Integer promptVersion) {
            this.promptVersion = promptVersion;
        }

        @Override
        public final Builder promptVersion(Integer promptVersion) {
            this.promptVersion = promptVersion;
            return this;
        }

        @Override
        public SpanAttributes build() {
            return new SpanAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
