/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageRequest extends QConnectRequest implements
        ToCopyableBuilder<SendMessageRequest.Builder, SendMessageRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(SendMessageRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SendMessageRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SendMessageRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<MessageInput> MESSAGE_FIELD = SdkField.<MessageInput> builder(MarshallingType.SDK_POJO)
            .memberName("message").getter(getter(SendMessageRequest::message)).setter(setter(Builder::message))
            .constructor(MessageInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentId").getter(getter(SendMessageRequest::aiAgentId)).setter(setter(Builder::aiAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()).build();

    private static final SdkField<ConversationContext> CONVERSATION_CONTEXT_FIELD = SdkField
            .<ConversationContext> builder(MarshallingType.SDK_POJO).memberName("conversationContext")
            .getter(getter(SendMessageRequest::conversationContext)).setter(setter(Builder::conversationContext))
            .constructor(ConversationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationContext").build())
            .build();

    private static final SdkField<MessageConfiguration> CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(SendMessageRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(SendMessageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ORCHESTRATOR_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestratorUseCase").getter(getter(SendMessageRequest::orchestratorUseCase))
            .setter(setter(Builder::orchestratorUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorUseCase").build())
            .build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(SendMessageRequest::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            SESSION_ID_FIELD, TYPE_FIELD, MESSAGE_FIELD, AI_AGENT_ID_FIELD, CONVERSATION_CONTEXT_FIELD, CONFIGURATION_FIELD,
            CLIENT_TOKEN_FIELD, ORCHESTRATOR_USE_CASE_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String sessionId;

    private final String type;

    private final MessageInput message;

    private final String aiAgentId;

    private final ConversationContext conversationContext;

    private final MessageConfiguration configuration;

    private final String clientToken;

    private final String orchestratorUseCase;

    private final Map<String, String> metadata;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.type = builder.type;
        this.message = builder.message;
        this.aiAgentId = builder.aiAgentId;
        this.conversationContext = builder.conversationContext;
        this.configuration = builder.configuration;
        this.clientToken = builder.clientToken;
        this.orchestratorUseCase = builder.orchestratorUseCase;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect session.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see MessageType
     */
    public final MessageType type() {
        return MessageType.fromValue(type);
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see MessageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The message data to submit to the Amazon Q in Connect session.
     * </p>
     * 
     * @return The message data to submit to the Amazon Q in Connect session.
     */
    public final MessageInput message() {
        return message;
    }

    /**
     * <p>
     * The identifier of the AI Agent to use for processing the message.
     * </p>
     * 
     * @return The identifier of the AI Agent to use for processing the message.
     */
    public final String aiAgentId() {
        return aiAgentId;
    }

    /**
     * <p>
     * The conversation context before the Amazon Q in Connect session.
     * </p>
     * 
     * @return The conversation context before the Amazon Q in Connect session.
     */
    public final ConversationContext conversationContext() {
        return conversationContext;
    }

    /**
     * <p>
     * The configuration of the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html"
     * >SendMessage</a> request.
     * </p>
     * 
     * @return The configuration of the <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html"
     *         >SendMessage</a> request.
     */
    public final MessageConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the AWS SDK populates this field.For more information about idempotency, see Making retries safe with idempotent
     * APIs.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the AWS SDK populates this field.For more information about idempotency, see Making retries
     *         safe with idempotent APIs.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The orchestrator use case for message processing.
     * </p>
     * 
     * @return The orchestrator use case for message processing.
     */
    public final String orchestratorUseCase() {
        return orchestratorUseCase;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional metadata for the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Additional metadata for the message.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationContext());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(orchestratorUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(aiAgentId(), other.aiAgentId())
                && Objects.equals(conversationContext(), other.conversationContext())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(orchestratorUseCase(), other.orchestratorUseCase()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageRequest").add("AssistantId", assistantId()).add("SessionId", sessionId())
                .add("Type", typeAsString()).add("Message", message()).add("AiAgentId", aiAgentId())
                .add("ConversationContext", conversationContext()).add("Configuration", configuration())
                .add("ClientToken", clientToken()).add("OrchestratorUseCase", orchestratorUseCase())
                .add("Metadata", hasMetadata() ? metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "aiAgentId":
            return Optional.ofNullable(clazz.cast(aiAgentId()));
        case "conversationContext":
            return Optional.ofNullable(clazz.cast(conversationContext()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "orchestratorUseCase":
            return Optional.ofNullable(clazz.cast(orchestratorUseCase()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("conversationContext", CONVERSATION_CONTEXT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("orchestratorUseCase", ORCHESTRATOR_USE_CASE_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder type(MessageType type);

        /**
         * <p>
         * The message data to submit to the Amazon Q in Connect session.
         * </p>
         * 
         * @param message
         *        The message data to submit to the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(MessageInput message);

        /**
         * <p>
         * The message data to submit to the Amazon Q in Connect session.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageInput.Builder} avoiding the need
         * to create one manually via {@link MessageInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageInput.Builder#build()} is called immediately and its
         * result is passed to {@link #message(MessageInput)}.
         * 
         * @param message
         *        a consumer that will call methods on {@link MessageInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #message(MessageInput)
         */
        default Builder message(Consumer<MessageInput.Builder> message) {
            return message(MessageInput.builder().applyMutation(message).build());
        }

        /**
         * <p>
         * The identifier of the AI Agent to use for processing the message.
         * </p>
         * 
         * @param aiAgentId
         *        The identifier of the AI Agent to use for processing the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentId(String aiAgentId);

        /**
         * <p>
         * The conversation context before the Amazon Q in Connect session.
         * </p>
         * 
         * @param conversationContext
         *        The conversation context before the Amazon Q in Connect session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationContext(ConversationContext conversationContext);

        /**
         * <p>
         * The conversation context before the Amazon Q in Connect session.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationContext.Builder} avoiding the
         * need to create one manually via {@link ConversationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationContext.Builder#build()} is called immediately and
         * its result is passed to {@link #conversationContext(ConversationContext)}.
         * 
         * @param conversationContext
         *        a consumer that will call methods on {@link ConversationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationContext(ConversationContext)
         */
        default Builder conversationContext(Consumer<ConversationContext.Builder> conversationContext) {
            return conversationContext(ConversationContext.builder().applyMutation(conversationContext).build());
        }

        /**
         * <p>
         * The configuration of the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html"
         * >SendMessage</a> request.
         * </p>
         * 
         * @param configuration
         *        The configuration of the <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html"
         *        >SendMessage</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(MessageConfiguration configuration);

        /**
         * <p>
         * The configuration of the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_SendMessage.html"
         * >SendMessage</a> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageConfiguration.Builder} avoiding
         * the need to create one manually via {@link MessageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(MessageConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(MessageConfiguration)
         */
        default Builder configuration(Consumer<MessageConfiguration.Builder> configuration) {
            return configuration(MessageConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the AWS SDK populates this field.For more information about idempotency, see Making retries safe
         * with idempotent APIs.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the AWS SDK populates this field.For more information about idempotency, see Making retries
         *        safe with idempotent APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The orchestrator use case for message processing.
         * </p>
         * 
         * @param orchestratorUseCase
         *        The orchestrator use case for message processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorUseCase(String orchestratorUseCase);

        /**
         * <p>
         * Additional metadata for the message.
         * </p>
         * 
         * @param metadata
         *        Additional metadata for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String sessionId;

        private String type;

        private MessageInput message;

        private String aiAgentId;

        private ConversationContext conversationContext;

        private MessageConfiguration configuration;

        private String clientToken;

        private String orchestratorUseCase;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            assistantId(model.assistantId);
            sessionId(model.sessionId);
            type(model.type);
            message(model.message);
            aiAgentId(model.aiAgentId);
            conversationContext(model.conversationContext);
            configuration(model.configuration);
            clientToken(model.clientToken);
            orchestratorUseCase(model.orchestratorUseCase);
            metadata(model.metadata);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MessageInput.Builder getMessage() {
            return message != null ? message.toBuilder() : null;
        }

        public final void setMessage(MessageInput.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(MessageInput message) {
            this.message = message;
            return this;
        }

        public final String getAiAgentId() {
            return aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final ConversationContext.Builder getConversationContext() {
            return conversationContext != null ? conversationContext.toBuilder() : null;
        }

        public final void setConversationContext(ConversationContext.BuilderImpl conversationContext) {
            this.conversationContext = conversationContext != null ? conversationContext.build() : null;
        }

        @Override
        public final Builder conversationContext(ConversationContext conversationContext) {
            this.conversationContext = conversationContext;
            return this;
        }

        public final MessageConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(MessageConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(MessageConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrchestratorUseCase() {
            return orchestratorUseCase;
        }

        public final void setOrchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
        }

        @Override
        public final Builder orchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MessageMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MessageMetadataCopier.copy(metadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
