/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single result from a content retrieval operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveResult implements SdkPojo, Serializable, ToCopyableBuilder<RetrieveResult.Builder, RetrieveResult> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(RetrieveResult::associationId)).setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceId").getter(getter(RetrieveResult::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()).build();

    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceType").getter(getter(RetrieveResult::referenceTypeAsString))
            .setter(setter(Builder::referenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()).build();

    private static final SdkField<String> CONTENT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentText").getter(getter(RetrieveResult::contentText)).setter(setter(Builder::contentText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            SOURCE_ID_FIELD, REFERENCE_TYPE_FIELD, CONTENT_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String sourceId;

    private final String referenceType;

    private final String contentText;

    private RetrieveResult(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.sourceId = builder.sourceId;
        this.referenceType = builder.referenceType;
        this.contentText = builder.contentText;
    }

    /**
     * <p>
     * The identifier of the assistant association for the retrieved result.
     * </p>
     * 
     * @return The identifier of the assistant association for the retrieved result.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The URL, URI, or ID of the retrieved content when available, or a UUID when unavailable.
     * </p>
     * 
     * @return The URL, URI, or ID of the retrieved content when available, or a UUID when unavailable.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * A type to define the KB origin of a retrieved content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return A type to define the KB origin of a retrieved content.
     * @see ReferenceType
     */
    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(referenceType);
    }

    /**
     * <p>
     * A type to define the KB origin of a retrieved content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return A type to define the KB origin of a retrieved content.
     * @see ReferenceType
     */
    public final String referenceTypeAsString() {
        return referenceType;
    }

    /**
     * <p>
     * The text content of the retrieved result.
     * </p>
     * 
     * @return The text content of the retrieved result.
     */
    public final String contentText() {
        return contentText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResult)) {
            return false;
        }
        RetrieveResult other = (RetrieveResult) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(sourceId(), other.sourceId())
                && Objects.equals(referenceTypeAsString(), other.referenceTypeAsString())
                && Objects.equals(contentText(), other.contentText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveResult").add("AssociationId", associationId())
                .add("SourceId", sourceId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReferenceType", referenceTypeAsString())
                .add("ContentText", contentText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "sourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "referenceType":
            return Optional.ofNullable(clazz.cast(referenceTypeAsString()));
        case "contentText":
            return Optional.ofNullable(clazz.cast(contentText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associationId", ASSOCIATION_ID_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        map.put("contentText", CONTENT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResult, T> g) {
        return obj -> g.apply((RetrieveResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieveResult> {
        /**
         * <p>
         * The identifier of the assistant association for the retrieved result.
         * </p>
         * 
         * @param associationId
         *        The identifier of the assistant association for the retrieved result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The URL, URI, or ID of the retrieved content when available, or a UUID when unavailable.
         * </p>
         * 
         * @param sourceId
         *        The URL, URI, or ID of the retrieved content when available, or a UUID when unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * A type to define the KB origin of a retrieved content.
         * </p>
         * 
         * @param referenceType
         *        A type to define the KB origin of a retrieved content.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(String referenceType);

        /**
         * <p>
         * A type to define the KB origin of a retrieved content.
         * </p>
         * 
         * @param referenceType
         *        A type to define the KB origin of a retrieved content.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(ReferenceType referenceType);

        /**
         * <p>
         * The text content of the retrieved result.
         * </p>
         * 
         * @param contentText
         *        The text content of the retrieved result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentText(String contentText);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String sourceId;

        private String referenceType;

        private String contentText;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResult model) {
            associationId(model.associationId);
            sourceId(model.sourceId);
            referenceType(model.referenceType);
            contentText(model.contentText);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getReferenceType() {
            return referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final String getContentText() {
            return contentText;
        }

        public final void setContentText(String contentText) {
            this.contentText = contentText;
        }

        @Override
        public final Builder contentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        @Override
        public RetrieveResult build() {
            return new RetrieveResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
