/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for filtering content during retrieval operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalFilterConfiguration.Builder, RetrievalFilterConfiguration> {
    private static final SdkField<List<RetrievalFilterConfiguration>> AND_ALL_FIELD = SdkField
            .<List<RetrievalFilterConfiguration>> builder(MarshallingType.LIST)
            .memberName("andAll")
            .getter(getter(RetrievalFilterConfiguration::andAll))
            .setter(setter(Builder::andAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievalFilterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievalFilterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterAttribute> EQUALS_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("equals").getter(getter(RetrievalFilterConfiguration::equalsValue)).setter(setter(Builder::equalsValue))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build()).build();

    private static final SdkField<FilterAttribute> GREATER_THAN_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThan")
            .getter(getter(RetrievalFilterConfiguration::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<FilterAttribute> GREATER_THAN_OR_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEquals")
            .getter(getter(RetrievalFilterConfiguration::greaterThanOrEquals)).setter(setter(Builder::greaterThanOrEquals))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEquals").build())
            .build();

    private static final SdkField<FilterAttribute> IN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("in").getter(getter(RetrievalFilterConfiguration::in)).setter(setter(Builder::in))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("in").build()).build();

    private static final SdkField<FilterAttribute> LESS_THAN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("lessThan").getter(getter(RetrievalFilterConfiguration::lessThan)).setter(setter(Builder::lessThan))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<FilterAttribute> LESS_THAN_OR_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("lessThanOrEquals")
            .getter(getter(RetrievalFilterConfiguration::lessThanOrEquals)).setter(setter(Builder::lessThanOrEquals))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEquals").build()).build();

    private static final SdkField<FilterAttribute> LIST_CONTAINS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("listContains")
            .getter(getter(RetrievalFilterConfiguration::listContains)).setter(setter(Builder::listContains))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listContains").build()).build();

    private static final SdkField<FilterAttribute> NOT_EQUALS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("notEquals")
            .getter(getter(RetrievalFilterConfiguration::notEquals)).setter(setter(Builder::notEquals))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build()).build();

    private static final SdkField<FilterAttribute> NOT_IN_FIELD = SdkField.<FilterAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("notIn").getter(getter(RetrievalFilterConfiguration::notIn)).setter(setter(Builder::notIn))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notIn").build()).build();

    private static final SdkField<List<RetrievalFilterConfiguration>> OR_ALL_FIELD = SdkField
            .<List<RetrievalFilterConfiguration>> builder(MarshallingType.LIST)
            .memberName("orAll")
            .getter(getter(RetrievalFilterConfiguration::orAll))
            .setter(setter(Builder::orAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievalFilterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievalFilterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterAttribute> STARTS_WITH_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("startsWith")
            .getter(getter(RetrievalFilterConfiguration::startsWith)).setter(setter(Builder::startsWith))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startsWith").build()).build();

    private static final SdkField<FilterAttribute> STRING_CONTAINS_FIELD = SdkField
            .<FilterAttribute> builder(MarshallingType.SDK_POJO).memberName("stringContains")
            .getter(getter(RetrievalFilterConfiguration::stringContains)).setter(setter(Builder::stringContains))
            .constructor(FilterAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringContains").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_ALL_FIELD, EQUALS_FIELD,
            GREATER_THAN_FIELD, GREATER_THAN_OR_EQUALS_FIELD, IN_FIELD, LESS_THAN_FIELD, LESS_THAN_OR_EQUALS_FIELD,
            LIST_CONTAINS_FIELD, NOT_EQUALS_FIELD, NOT_IN_FIELD, OR_ALL_FIELD, STARTS_WITH_FIELD, STRING_CONTAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RetrievalFilterConfiguration> andAll;

    private final FilterAttribute equalsValue;

    private final FilterAttribute greaterThan;

    private final FilterAttribute greaterThanOrEquals;

    private final FilterAttribute in;

    private final FilterAttribute lessThan;

    private final FilterAttribute lessThanOrEquals;

    private final FilterAttribute listContains;

    private final FilterAttribute notEquals;

    private final FilterAttribute notIn;

    private final List<RetrievalFilterConfiguration> orAll;

    private final FilterAttribute startsWith;

    private final FilterAttribute stringContains;

    private final Type type;

    private RetrievalFilterConfiguration(BuilderImpl builder) {
        this.andAll = builder.andAll;
        this.equalsValue = builder.equalsValue;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEquals = builder.greaterThanOrEquals;
        this.in = builder.in;
        this.lessThan = builder.lessThan;
        this.lessThanOrEquals = builder.lessThanOrEquals;
        this.listContains = builder.listContains;
        this.notEquals = builder.notEquals;
        this.notIn = builder.notIn;
        this.orAll = builder.orAll;
        this.startsWith = builder.startsWith;
        this.stringContains = builder.stringContains;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAll property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAndAll() {
        return andAll != null && !(andAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter configuration that requires all conditions to be met.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAll} method.
     * </p>
     * 
     * @return Filter configuration that requires all conditions to be met.
     */
    public final List<RetrievalFilterConfiguration> andAll() {
        return andAll;
    }

    /**
     * <p>
     * Filter configuration for exact equality matching.
     * </p>
     * 
     * @return Filter configuration for exact equality matching.
     */
    public final FilterAttribute equalsValue() {
        return equalsValue;
    }

    /**
     * <p>
     * Filter configuration for greater than comparison.
     * </p>
     * 
     * @return Filter configuration for greater than comparison.
     */
    public final FilterAttribute greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Filter configuration for greater than or equal comparison.
     * </p>
     * 
     * @return Filter configuration for greater than or equal comparison.
     */
    public final FilterAttribute greaterThanOrEquals() {
        return greaterThanOrEquals;
    }

    /**
     * <p>
     * Filter configuration for membership in a set of values.
     * </p>
     * 
     * @return Filter configuration for membership in a set of values.
     */
    public final FilterAttribute in() {
        return in;
    }

    /**
     * <p>
     * Filter configuration for less than comparison.
     * </p>
     * 
     * @return Filter configuration for less than comparison.
     */
    public final FilterAttribute lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Filter configuration for less than or equal comparison.
     * </p>
     * 
     * @return Filter configuration for less than or equal comparison.
     */
    public final FilterAttribute lessThanOrEquals() {
        return lessThanOrEquals;
    }

    /**
     * <p>
     * Filter configuration for checking if a list contains a value.
     * </p>
     * 
     * @return Filter configuration for checking if a list contains a value.
     */
    public final FilterAttribute listContains() {
        return listContains;
    }

    /**
     * <p>
     * Filter configuration for inequality matching.
     * </p>
     * 
     * @return Filter configuration for inequality matching.
     */
    public final FilterAttribute notEquals() {
        return notEquals;
    }

    /**
     * <p>
     * Filter configuration for exclusion from a set of values.
     * </p>
     * 
     * @return Filter configuration for exclusion from a set of values.
     */
    public final FilterAttribute notIn() {
        return notIn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAll property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrAll() {
        return orAll != null && !(orAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter configuration where any condition can be met.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAll} method.
     * </p>
     * 
     * @return Filter configuration where any condition can be met.
     */
    public final List<RetrievalFilterConfiguration> orAll() {
        return orAll;
    }

    /**
     * <p>
     * Filter configuration for prefix matching.
     * </p>
     * 
     * @return Filter configuration for prefix matching.
     */
    public final FilterAttribute startsWith() {
        return startsWith;
    }

    /**
     * <p>
     * Filter configuration for substring matching.
     * </p>
     * 
     * @return Filter configuration for substring matching.
     */
    public final FilterAttribute stringContains() {
        return stringContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAll() ? andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(equalsValue());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(in());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(listContains());
        hashCode = 31 * hashCode + Objects.hashCode(notEquals());
        hashCode = 31 * hashCode + Objects.hashCode(notIn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAll() ? orAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startsWith());
        hashCode = 31 * hashCode + Objects.hashCode(stringContains());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalFilterConfiguration)) {
            return false;
        }
        RetrievalFilterConfiguration other = (RetrievalFilterConfiguration) obj;
        return hasAndAll() == other.hasAndAll() && Objects.equals(andAll(), other.andAll())
                && Objects.equals(equalsValue(), other.equalsValue()) && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEquals(), other.greaterThanOrEquals()) && Objects.equals(in(), other.in())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEquals(), other.lessThanOrEquals())
                && Objects.equals(listContains(), other.listContains()) && Objects.equals(notEquals(), other.notEquals())
                && Objects.equals(notIn(), other.notIn()) && hasOrAll() == other.hasOrAll()
                && Objects.equals(orAll(), other.orAll()) && Objects.equals(startsWith(), other.startsWith())
                && Objects.equals(stringContains(), other.stringContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalFilterConfiguration").add("AndAll", hasAndAll() ? andAll() : null)
                .add("Equals", equalsValue()).add("GreaterThan", greaterThan()).add("GreaterThanOrEquals", greaterThanOrEquals())
                .add("In", in()).add("LessThan", lessThan()).add("LessThanOrEquals", lessThanOrEquals())
                .add("ListContains", listContains()).add("NotEquals", notEquals()).add("NotIn", notIn())
                .add("OrAll", hasOrAll() ? orAll() : null).add("StartsWith", startsWith())
                .add("StringContains", stringContains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "andAll":
            return Optional.ofNullable(clazz.cast(andAll()));
        case "equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "greaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "greaterThanOrEquals":
            return Optional.ofNullable(clazz.cast(greaterThanOrEquals()));
        case "in":
            return Optional.ofNullable(clazz.cast(in()));
        case "lessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "lessThanOrEquals":
            return Optional.ofNullable(clazz.cast(lessThanOrEquals()));
        case "listContains":
            return Optional.ofNullable(clazz.cast(listContains()));
        case "notEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "notIn":
            return Optional.ofNullable(clazz.cast(notIn()));
        case "orAll":
            return Optional.ofNullable(clazz.cast(orAll()));
        case "startsWith":
            return Optional.ofNullable(clazz.cast(startsWith()));
        case "stringContains":
            return Optional.ofNullable(clazz.cast(stringContains()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #andAll()} initialized to the given value.
     *
     * <p>
     * Filter configuration that requires all conditions to be met.
     * </p>
     * 
     * @param andAll
     *        Filter configuration that requires all conditions to be met.
     */
    public static RetrievalFilterConfiguration fromAndAll(List<RetrievalFilterConfiguration> andAll) {
        return builder().andAll(andAll).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * Filter configuration for exact equality matching.
     * </p>
     * 
     * @param equalsValue
     *        Filter configuration for exact equality matching.
     */
    public static RetrievalFilterConfiguration fromEqualsValue(FilterAttribute equalsValue) {
        return builder().equalsValue(equalsValue).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * Filter configuration for exact equality matching.
     * </p>
     * 
     * @param equalsValue
     *        Filter configuration for exact equality matching.
     */
    public static RetrievalFilterConfiguration fromEqualsValue(Consumer<FilterAttribute.Builder> equalsValue) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        equalsValue.accept(builder);
        return fromEqualsValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Filter configuration for greater than comparison.
     * </p>
     * 
     * @param greaterThan
     *        Filter configuration for greater than comparison.
     */
    public static RetrievalFilterConfiguration fromGreaterThan(FilterAttribute greaterThan) {
        return builder().greaterThan(greaterThan).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Filter configuration for greater than comparison.
     * </p>
     * 
     * @param greaterThan
     *        Filter configuration for greater than comparison.
     */
    public static RetrievalFilterConfiguration fromGreaterThan(Consumer<FilterAttribute.Builder> greaterThan) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        greaterThan.accept(builder);
        return fromGreaterThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for greater than or equal comparison.
     * </p>
     * 
     * @param greaterThanOrEquals
     *        Filter configuration for greater than or equal comparison.
     */
    public static RetrievalFilterConfiguration fromGreaterThanOrEquals(FilterAttribute greaterThanOrEquals) {
        return builder().greaterThanOrEquals(greaterThanOrEquals).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for greater than or equal comparison.
     * </p>
     * 
     * @param greaterThanOrEquals
     *        Filter configuration for greater than or equal comparison.
     */
    public static RetrievalFilterConfiguration fromGreaterThanOrEquals(Consumer<FilterAttribute.Builder> greaterThanOrEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        greaterThanOrEquals.accept(builder);
        return fromGreaterThanOrEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * Filter configuration for membership in a set of values.
     * </p>
     * 
     * @param in
     *        Filter configuration for membership in a set of values.
     */
    public static RetrievalFilterConfiguration fromIn(FilterAttribute in) {
        return builder().in(in).build();
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * Filter configuration for membership in a set of values.
     * </p>
     * 
     * @param in
     *        Filter configuration for membership in a set of values.
     */
    public static RetrievalFilterConfiguration fromIn(Consumer<FilterAttribute.Builder> in) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        in.accept(builder);
        return fromIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Filter configuration for less than comparison.
     * </p>
     * 
     * @param lessThan
     *        Filter configuration for less than comparison.
     */
    public static RetrievalFilterConfiguration fromLessThan(FilterAttribute lessThan) {
        return builder().lessThan(lessThan).build();
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Filter configuration for less than comparison.
     * </p>
     * 
     * @param lessThan
     *        Filter configuration for less than comparison.
     */
    public static RetrievalFilterConfiguration fromLessThan(Consumer<FilterAttribute.Builder> lessThan) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        lessThan.accept(builder);
        return fromLessThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for less than or equal comparison.
     * </p>
     * 
     * @param lessThanOrEquals
     *        Filter configuration for less than or equal comparison.
     */
    public static RetrievalFilterConfiguration fromLessThanOrEquals(FilterAttribute lessThanOrEquals) {
        return builder().lessThanOrEquals(lessThanOrEquals).build();
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for less than or equal comparison.
     * </p>
     * 
     * @param lessThanOrEquals
     *        Filter configuration for less than or equal comparison.
     */
    public static RetrievalFilterConfiguration fromLessThanOrEquals(Consumer<FilterAttribute.Builder> lessThanOrEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        lessThanOrEquals.accept(builder);
        return fromLessThanOrEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #listContains()} initialized to the given value.
     *
     * <p>
     * Filter configuration for checking if a list contains a value.
     * </p>
     * 
     * @param listContains
     *        Filter configuration for checking if a list contains a value.
     */
    public static RetrievalFilterConfiguration fromListContains(FilterAttribute listContains) {
        return builder().listContains(listContains).build();
    }

    /**
     * Create an instance of this class with {@link #listContains()} initialized to the given value.
     *
     * <p>
     * Filter configuration for checking if a list contains a value.
     * </p>
     * 
     * @param listContains
     *        Filter configuration for checking if a list contains a value.
     */
    public static RetrievalFilterConfiguration fromListContains(Consumer<FilterAttribute.Builder> listContains) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        listContains.accept(builder);
        return fromListContains(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for inequality matching.
     * </p>
     * 
     * @param notEquals
     *        Filter configuration for inequality matching.
     */
    public static RetrievalFilterConfiguration fromNotEquals(FilterAttribute notEquals) {
        return builder().notEquals(notEquals).build();
    }

    /**
     * Create an instance of this class with {@link #notEquals()} initialized to the given value.
     *
     * <p>
     * Filter configuration for inequality matching.
     * </p>
     * 
     * @param notEquals
     *        Filter configuration for inequality matching.
     */
    public static RetrievalFilterConfiguration fromNotEquals(Consumer<FilterAttribute.Builder> notEquals) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        notEquals.accept(builder);
        return fromNotEquals(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * Filter configuration for exclusion from a set of values.
     * </p>
     * 
     * @param notIn
     *        Filter configuration for exclusion from a set of values.
     */
    public static RetrievalFilterConfiguration fromNotIn(FilterAttribute notIn) {
        return builder().notIn(notIn).build();
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * Filter configuration for exclusion from a set of values.
     * </p>
     * 
     * @param notIn
     *        Filter configuration for exclusion from a set of values.
     */
    public static RetrievalFilterConfiguration fromNotIn(Consumer<FilterAttribute.Builder> notIn) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        notIn.accept(builder);
        return fromNotIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #orAll()} initialized to the given value.
     *
     * <p>
     * Filter configuration where any condition can be met.
     * </p>
     * 
     * @param orAll
     *        Filter configuration where any condition can be met.
     */
    public static RetrievalFilterConfiguration fromOrAll(List<RetrievalFilterConfiguration> orAll) {
        return builder().orAll(orAll).build();
    }

    /**
     * Create an instance of this class with {@link #startsWith()} initialized to the given value.
     *
     * <p>
     * Filter configuration for prefix matching.
     * </p>
     * 
     * @param startsWith
     *        Filter configuration for prefix matching.
     */
    public static RetrievalFilterConfiguration fromStartsWith(FilterAttribute startsWith) {
        return builder().startsWith(startsWith).build();
    }

    /**
     * Create an instance of this class with {@link #startsWith()} initialized to the given value.
     *
     * <p>
     * Filter configuration for prefix matching.
     * </p>
     * 
     * @param startsWith
     *        Filter configuration for prefix matching.
     */
    public static RetrievalFilterConfiguration fromStartsWith(Consumer<FilterAttribute.Builder> startsWith) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        startsWith.accept(builder);
        return fromStartsWith(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringContains()} initialized to the given value.
     *
     * <p>
     * Filter configuration for substring matching.
     * </p>
     * 
     * @param stringContains
     *        Filter configuration for substring matching.
     */
    public static RetrievalFilterConfiguration fromStringContains(FilterAttribute stringContains) {
        return builder().stringContains(stringContains).build();
    }

    /**
     * Create an instance of this class with {@link #stringContains()} initialized to the given value.
     *
     * <p>
     * Filter configuration for substring matching.
     * </p>
     * 
     * @param stringContains
     *        Filter configuration for substring matching.
     */
    public static RetrievalFilterConfiguration fromStringContains(Consumer<FilterAttribute.Builder> stringContains) {
        FilterAttribute.Builder builder = FilterAttribute.builder();
        stringContains.accept(builder);
        return fromStringContains(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("andAll", AND_ALL_FIELD);
        map.put("equals", EQUALS_FIELD);
        map.put("greaterThan", GREATER_THAN_FIELD);
        map.put("greaterThanOrEquals", GREATER_THAN_OR_EQUALS_FIELD);
        map.put("in", IN_FIELD);
        map.put("lessThan", LESS_THAN_FIELD);
        map.put("lessThanOrEquals", LESS_THAN_OR_EQUALS_FIELD);
        map.put("listContains", LIST_CONTAINS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        map.put("notIn", NOT_IN_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        map.put("startsWith", STARTS_WITH_FIELD);
        map.put("stringContains", STRING_CONTAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalFilterConfiguration, T> g) {
        return obj -> g.apply((RetrievalFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalFilterConfiguration> {
        /**
         * <p>
         * Filter configuration that requires all conditions to be met.
         * </p>
         * 
         * @param andAll
         *        Filter configuration that requires all conditions to be met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(Collection<RetrievalFilterConfiguration> andAll);

        /**
         * <p>
         * Filter configuration that requires all conditions to be met.
         * </p>
         * 
         * @param andAll
         *        Filter configuration that requires all conditions to be met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(RetrievalFilterConfiguration... andAll);

        /**
         * <p>
         * Filter configuration that requires all conditions to be met.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #andAll(List<RetrievalFilterConfiguration>)}.
         * 
         * @param andAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAll(java.util.Collection<RetrievalFilterConfiguration>)
         */
        Builder andAll(Consumer<Builder>... andAll);

        /**
         * <p>
         * Filter configuration for exact equality matching.
         * </p>
         * 
         * @param equalsValue
         *        Filter configuration for exact equality matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(FilterAttribute equalsValue);

        /**
         * <p>
         * Filter configuration for exact equality matching.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #equalsValue(FilterAttribute)}.
         * 
         * @param equalsValue
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalsValue(FilterAttribute)
         */
        default Builder equalsValue(Consumer<FilterAttribute.Builder> equalsValue) {
            return equalsValue(FilterAttribute.builder().applyMutation(equalsValue).build());
        }

        /**
         * <p>
         * Filter configuration for greater than comparison.
         * </p>
         * 
         * @param greaterThan
         *        Filter configuration for greater than comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(FilterAttribute greaterThan);

        /**
         * <p>
         * Filter configuration for greater than comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThan(FilterAttribute)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(FilterAttribute)
         */
        default Builder greaterThan(Consumer<FilterAttribute.Builder> greaterThan) {
            return greaterThan(FilterAttribute.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * Filter configuration for greater than or equal comparison.
         * </p>
         * 
         * @param greaterThanOrEquals
         *        Filter configuration for greater than or equal comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEquals(FilterAttribute greaterThanOrEquals);

        /**
         * <p>
         * Filter configuration for greater than or equal comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThanOrEquals(FilterAttribute)}.
         * 
         * @param greaterThanOrEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEquals(FilterAttribute)
         */
        default Builder greaterThanOrEquals(Consumer<FilterAttribute.Builder> greaterThanOrEquals) {
            return greaterThanOrEquals(FilterAttribute.builder().applyMutation(greaterThanOrEquals).build());
        }

        /**
         * <p>
         * Filter configuration for membership in a set of values.
         * </p>
         * 
         * @param in
         *        Filter configuration for membership in a set of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder in(FilterAttribute in);

        /**
         * <p>
         * Filter configuration for membership in a set of values.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #in(FilterAttribute)}.
         * 
         * @param in
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #in(FilterAttribute)
         */
        default Builder in(Consumer<FilterAttribute.Builder> in) {
            return in(FilterAttribute.builder().applyMutation(in).build());
        }

        /**
         * <p>
         * Filter configuration for less than comparison.
         * </p>
         * 
         * @param lessThan
         *        Filter configuration for less than comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(FilterAttribute lessThan);

        /**
         * <p>
         * Filter configuration for less than comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThan(FilterAttribute)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(FilterAttribute)
         */
        default Builder lessThan(Consumer<FilterAttribute.Builder> lessThan) {
            return lessThan(FilterAttribute.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * Filter configuration for less than or equal comparison.
         * </p>
         * 
         * @param lessThanOrEquals
         *        Filter configuration for less than or equal comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEquals(FilterAttribute lessThanOrEquals);

        /**
         * <p>
         * Filter configuration for less than or equal comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThanOrEquals(FilterAttribute)}.
         * 
         * @param lessThanOrEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEquals(FilterAttribute)
         */
        default Builder lessThanOrEquals(Consumer<FilterAttribute.Builder> lessThanOrEquals) {
            return lessThanOrEquals(FilterAttribute.builder().applyMutation(lessThanOrEquals).build());
        }

        /**
         * <p>
         * Filter configuration for checking if a list contains a value.
         * </p>
         * 
         * @param listContains
         *        Filter configuration for checking if a list contains a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listContains(FilterAttribute listContains);

        /**
         * <p>
         * Filter configuration for checking if a list contains a value.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #listContains(FilterAttribute)}.
         * 
         * @param listContains
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listContains(FilterAttribute)
         */
        default Builder listContains(Consumer<FilterAttribute.Builder> listContains) {
            return listContains(FilterAttribute.builder().applyMutation(listContains).build());
        }

        /**
         * <p>
         * Filter configuration for inequality matching.
         * </p>
         * 
         * @param notEquals
         *        Filter configuration for inequality matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(FilterAttribute notEquals);

        /**
         * <p>
         * Filter configuration for inequality matching.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #notEquals(FilterAttribute)}.
         * 
         * @param notEquals
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notEquals(FilterAttribute)
         */
        default Builder notEquals(Consumer<FilterAttribute.Builder> notEquals) {
            return notEquals(FilterAttribute.builder().applyMutation(notEquals).build());
        }

        /**
         * <p>
         * Filter configuration for exclusion from a set of values.
         * </p>
         * 
         * @param notIn
         *        Filter configuration for exclusion from a set of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notIn(FilterAttribute notIn);

        /**
         * <p>
         * Filter configuration for exclusion from a set of values.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #notIn(FilterAttribute)}.
         * 
         * @param notIn
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notIn(FilterAttribute)
         */
        default Builder notIn(Consumer<FilterAttribute.Builder> notIn) {
            return notIn(FilterAttribute.builder().applyMutation(notIn).build());
        }

        /**
         * <p>
         * Filter configuration where any condition can be met.
         * </p>
         * 
         * @param orAll
         *        Filter configuration where any condition can be met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(Collection<RetrievalFilterConfiguration> orAll);

        /**
         * <p>
         * Filter configuration where any condition can be met.
         * </p>
         * 
         * @param orAll
         *        Filter configuration where any condition can be met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(RetrievalFilterConfiguration... orAll);

        /**
         * <p>
         * Filter configuration where any condition can be met.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #orAll(List<RetrievalFilterConfiguration>)}.
         * 
         * @param orAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAll(java.util.Collection<RetrievalFilterConfiguration>)
         */
        Builder orAll(Consumer<Builder>... orAll);

        /**
         * <p>
         * Filter configuration for prefix matching.
         * </p>
         * 
         * @param startsWith
         *        Filter configuration for prefix matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startsWith(FilterAttribute startsWith);

        /**
         * <p>
         * Filter configuration for prefix matching.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #startsWith(FilterAttribute)}.
         * 
         * @param startsWith
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startsWith(FilterAttribute)
         */
        default Builder startsWith(Consumer<FilterAttribute.Builder> startsWith) {
            return startsWith(FilterAttribute.builder().applyMutation(startsWith).build());
        }

        /**
         * <p>
         * Filter configuration for substring matching.
         * </p>
         * 
         * @param stringContains
         *        Filter configuration for substring matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringContains(FilterAttribute stringContains);

        /**
         * <p>
         * Filter configuration for substring matching.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterAttribute.Builder} avoiding the
         * need to create one manually via {@link FilterAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #stringContains(FilterAttribute)}.
         * 
         * @param stringContains
         *        a consumer that will call methods on {@link FilterAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringContains(FilterAttribute)
         */
        default Builder stringContains(Consumer<FilterAttribute.Builder> stringContains) {
            return stringContains(FilterAttribute.builder().applyMutation(stringContains).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RetrievalFilterConfiguration> andAll = DefaultSdkAutoConstructList.getInstance();

        private FilterAttribute equalsValue;

        private FilterAttribute greaterThan;

        private FilterAttribute greaterThanOrEquals;

        private FilterAttribute in;

        private FilterAttribute lessThan;

        private FilterAttribute lessThanOrEquals;

        private FilterAttribute listContains;

        private FilterAttribute notEquals;

        private FilterAttribute notIn;

        private List<RetrievalFilterConfiguration> orAll = DefaultSdkAutoConstructList.getInstance();

        private FilterAttribute startsWith;

        private FilterAttribute stringContains;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalFilterConfiguration model) {
            andAll(model.andAll);
            equalsValue(model.equalsValue);
            greaterThan(model.greaterThan);
            greaterThanOrEquals(model.greaterThanOrEquals);
            in(model.in);
            lessThan(model.lessThan);
            lessThanOrEquals(model.lessThanOrEquals);
            listContains(model.listContains);
            notEquals(model.notEquals);
            notIn(model.notIn);
            orAll(model.orAll);
            startsWith(model.startsWith);
            stringContains(model.stringContains);
        }

        public final List<Builder> getAndAll() {
            List<Builder> result = RetrievalFilterListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<BuilderImpl> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RetrievalFilterListCopier.copyFromBuilder(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<RetrievalFilterConfiguration> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RetrievalFilterListCopier.copy(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(RetrievalFilterConfiguration... andAll) {
            andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<Builder>... andAll) {
            andAll(Stream.of(andAll).map(c -> RetrievalFilterConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FilterAttribute.Builder getEqualsValue() {
            return equalsValue != null ? equalsValue.toBuilder() : null;
        }

        public final void setEqualsValue(FilterAttribute.BuilderImpl equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue != null ? equalsValue.build() : null;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(FilterAttribute equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        public final FilterAttribute.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(FilterAttribute.BuilderImpl greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
        }

        @Override
        public final Builder greaterThan(FilterAttribute greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
            return this;
        }

        public final FilterAttribute.Builder getGreaterThanOrEquals() {
            return greaterThanOrEquals != null ? greaterThanOrEquals.toBuilder() : null;
        }

        public final void setGreaterThanOrEquals(FilterAttribute.BuilderImpl greaterThanOrEquals) {
            Object oldValue = this.greaterThanOrEquals;
            this.greaterThanOrEquals = greaterThanOrEquals != null ? greaterThanOrEquals.build() : null;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUALS, oldValue, this.greaterThanOrEquals);
        }

        @Override
        public final Builder greaterThanOrEquals(FilterAttribute greaterThanOrEquals) {
            Object oldValue = this.greaterThanOrEquals;
            this.greaterThanOrEquals = greaterThanOrEquals;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUALS, oldValue, this.greaterThanOrEquals);
            return this;
        }

        public final FilterAttribute.Builder getIn() {
            return in != null ? in.toBuilder() : null;
        }

        public final void setIn(FilterAttribute.BuilderImpl in) {
            Object oldValue = this.in;
            this.in = in != null ? in.build() : null;
            handleUnionValueChange(Type.IN, oldValue, this.in);
        }

        @Override
        public final Builder in(FilterAttribute in) {
            Object oldValue = this.in;
            this.in = in;
            handleUnionValueChange(Type.IN, oldValue, this.in);
            return this;
        }

        public final FilterAttribute.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        public final void setLessThan(FilterAttribute.BuilderImpl lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan != null ? lessThan.build() : null;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
        }

        @Override
        public final Builder lessThan(FilterAttribute lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
            return this;
        }

        public final FilterAttribute.Builder getLessThanOrEquals() {
            return lessThanOrEquals != null ? lessThanOrEquals.toBuilder() : null;
        }

        public final void setLessThanOrEquals(FilterAttribute.BuilderImpl lessThanOrEquals) {
            Object oldValue = this.lessThanOrEquals;
            this.lessThanOrEquals = lessThanOrEquals != null ? lessThanOrEquals.build() : null;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUALS, oldValue, this.lessThanOrEquals);
        }

        @Override
        public final Builder lessThanOrEquals(FilterAttribute lessThanOrEquals) {
            Object oldValue = this.lessThanOrEquals;
            this.lessThanOrEquals = lessThanOrEquals;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUALS, oldValue, this.lessThanOrEquals);
            return this;
        }

        public final FilterAttribute.Builder getListContains() {
            return listContains != null ? listContains.toBuilder() : null;
        }

        public final void setListContains(FilterAttribute.BuilderImpl listContains) {
            Object oldValue = this.listContains;
            this.listContains = listContains != null ? listContains.build() : null;
            handleUnionValueChange(Type.LIST_CONTAINS, oldValue, this.listContains);
        }

        @Override
        public final Builder listContains(FilterAttribute listContains) {
            Object oldValue = this.listContains;
            this.listContains = listContains;
            handleUnionValueChange(Type.LIST_CONTAINS, oldValue, this.listContains);
            return this;
        }

        public final FilterAttribute.Builder getNotEquals() {
            return notEquals != null ? notEquals.toBuilder() : null;
        }

        public final void setNotEquals(FilterAttribute.BuilderImpl notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = notEquals != null ? notEquals.build() : null;
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
        }

        @Override
        public final Builder notEquals(FilterAttribute notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = notEquals;
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
            return this;
        }

        public final FilterAttribute.Builder getNotIn() {
            return notIn != null ? notIn.toBuilder() : null;
        }

        public final void setNotIn(FilterAttribute.BuilderImpl notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn != null ? notIn.build() : null;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
        }

        @Override
        public final Builder notIn(FilterAttribute notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
            return this;
        }

        public final List<Builder> getOrAll() {
            List<Builder> result = RetrievalFilterListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<BuilderImpl> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RetrievalFilterListCopier.copyFromBuilder(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<RetrievalFilterConfiguration> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RetrievalFilterListCopier.copy(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(RetrievalFilterConfiguration... orAll) {
            orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<Builder>... orAll) {
            orAll(Stream.of(orAll).map(c -> RetrievalFilterConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FilterAttribute.Builder getStartsWith() {
            return startsWith != null ? startsWith.toBuilder() : null;
        }

        public final void setStartsWith(FilterAttribute.BuilderImpl startsWith) {
            Object oldValue = this.startsWith;
            this.startsWith = startsWith != null ? startsWith.build() : null;
            handleUnionValueChange(Type.STARTS_WITH, oldValue, this.startsWith);
        }

        @Override
        public final Builder startsWith(FilterAttribute startsWith) {
            Object oldValue = this.startsWith;
            this.startsWith = startsWith;
            handleUnionValueChange(Type.STARTS_WITH, oldValue, this.startsWith);
            return this;
        }

        public final FilterAttribute.Builder getStringContains() {
            return stringContains != null ? stringContains.toBuilder() : null;
        }

        public final void setStringContains(FilterAttribute.BuilderImpl stringContains) {
            Object oldValue = this.stringContains;
            this.stringContains = stringContains != null ? stringContains.build() : null;
            handleUnionValueChange(Type.STRING_CONTAINS, oldValue, this.stringContains);
        }

        @Override
        public final Builder stringContains(FilterAttribute stringContains) {
            Object oldValue = this.stringContains;
            this.stringContains = stringContains;
            handleUnionValueChange(Type.STRING_CONTAINS, oldValue, this.stringContains);
            return this;
        }

        @Override
        public RetrievalFilterConfiguration build() {
            return new RetrievalFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RetrievalFilterConfiguration#type()
     */
    public enum Type {
        AND_ALL,

        EQUALS,

        GREATER_THAN,

        GREATER_THAN_OR_EQUALS,

        IN,

        LESS_THAN,

        LESS_THAN_OR_EQUALS,

        LIST_CONTAINS,

        NOT_EQUALS,

        NOT_IN,

        OR_ALL,

        STARTS_WITH,

        STRING_CONTAINS,

        UNKNOWN_TO_SDK_VERSION
    }
}
