/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for content retrieval operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalConfiguration.Builder, RetrievalConfiguration> {
    private static final SdkField<KnowledgeSource> KNOWLEDGE_SOURCE_FIELD = SdkField
            .<KnowledgeSource> builder(MarshallingType.SDK_POJO).memberName("knowledgeSource")
            .getter(getter(RetrievalConfiguration::knowledgeSource)).setter(setter(Builder::knowledgeSource))
            .constructor(KnowledgeSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeSource").build()).build();

    private static final SdkField<RetrievalFilterConfiguration> FILTER_FIELD = SdkField
            .<RetrievalFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(RetrievalConfiguration::filter)).setter(setter(Builder::filter))
            .constructor(RetrievalFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfResults").getter(getter(RetrievalConfiguration::numberOfResults))
            .setter(setter(Builder::numberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()).build();

    private static final SdkField<String> OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("overrideKnowledgeBaseSearchType")
            .getter(getter(RetrievalConfiguration::overrideKnowledgeBaseSearchTypeAsString))
            .setter(setter(Builder::overrideKnowledgeBaseSearchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideKnowledgeBaseSearchType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_SOURCE_FIELD,
            FILTER_FIELD, NUMBER_OF_RESULTS_FIELD, OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeSource knowledgeSource;

    private final RetrievalFilterConfiguration filter;

    private final Integer numberOfResults;

    private final String overrideKnowledgeBaseSearchType;

    private RetrievalConfiguration(BuilderImpl builder) {
        this.knowledgeSource = builder.knowledgeSource;
        this.filter = builder.filter;
        this.numberOfResults = builder.numberOfResults;
        this.overrideKnowledgeBaseSearchType = builder.overrideKnowledgeBaseSearchType;
    }

    /**
     * <p>
     * The knowledge source configuration for content retrieval.
     * </p>
     * 
     * @return The knowledge source configuration for content retrieval.
     */
    public final KnowledgeSource knowledgeSource() {
        return knowledgeSource;
    }

    /**
     * <p>
     * The filter configuration for content retrieval.
     * </p>
     * 
     * @return The filter configuration for content retrieval.
     */
    public final RetrievalFilterConfiguration filter() {
        return filter;
    }

    /**
     * <p>
     * The number of results to retrieve.
     * </p>
     * 
     * @return The number of results to retrieve.
     */
    public final Integer numberOfResults() {
        return numberOfResults;
    }

    /**
     * <p>
     * Override setting for the knowledge base search type during retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return Override setting for the knowledge base search type during retrieval.
     * @see KnowledgeBaseSearchType
     */
    public final KnowledgeBaseSearchType overrideKnowledgeBaseSearchType() {
        return KnowledgeBaseSearchType.fromValue(overrideKnowledgeBaseSearchType);
    }

    /**
     * <p>
     * Override setting for the knowledge base search type during retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return Override setting for the knowledge base search type during retrieval.
     * @see KnowledgeBaseSearchType
     */
    public final String overrideKnowledgeBaseSearchTypeAsString() {
        return overrideKnowledgeBaseSearchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeSource());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(overrideKnowledgeBaseSearchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalConfiguration)) {
            return false;
        }
        RetrievalConfiguration other = (RetrievalConfiguration) obj;
        return Objects.equals(knowledgeSource(), other.knowledgeSource()) && Objects.equals(filter(), other.filter())
                && Objects.equals(numberOfResults(), other.numberOfResults())
                && Objects.equals(overrideKnowledgeBaseSearchTypeAsString(), other.overrideKnowledgeBaseSearchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalConfiguration").add("KnowledgeSource", knowledgeSource()).add("Filter", filter())
                .add("NumberOfResults", numberOfResults())
                .add("OverrideKnowledgeBaseSearchType", overrideKnowledgeBaseSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeSource":
            return Optional.ofNullable(clazz.cast(knowledgeSource()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "numberOfResults":
            return Optional.ofNullable(clazz.cast(numberOfResults()));
        case "overrideKnowledgeBaseSearchType":
            return Optional.ofNullable(clazz.cast(overrideKnowledgeBaseSearchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeSource", KNOWLEDGE_SOURCE_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("numberOfResults", NUMBER_OF_RESULTS_FIELD);
        map.put("overrideKnowledgeBaseSearchType", OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalConfiguration, T> g) {
        return obj -> g.apply((RetrievalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalConfiguration> {
        /**
         * <p>
         * The knowledge source configuration for content retrieval.
         * </p>
         * 
         * @param knowledgeSource
         *        The knowledge source configuration for content retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeSource(KnowledgeSource knowledgeSource);

        /**
         * <p>
         * The knowledge source configuration for content retrieval.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeSource.Builder} avoiding the
         * need to create one manually via {@link KnowledgeSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeSource.Builder#build()} is called immediately and its
         * result is passed to {@link #knowledgeSource(KnowledgeSource)}.
         * 
         * @param knowledgeSource
         *        a consumer that will call methods on {@link KnowledgeSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeSource(KnowledgeSource)
         */
        default Builder knowledgeSource(Consumer<KnowledgeSource.Builder> knowledgeSource) {
            return knowledgeSource(KnowledgeSource.builder().applyMutation(knowledgeSource).build());
        }

        /**
         * <p>
         * The filter configuration for content retrieval.
         * </p>
         * 
         * @param filter
         *        The filter configuration for content retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(RetrievalFilterConfiguration filter);

        /**
         * <p>
         * The filter configuration for content retrieval.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link RetrievalFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalFilterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(RetrievalFilterConfiguration)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link RetrievalFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(RetrievalFilterConfiguration)
         */
        default Builder filter(Consumer<RetrievalFilterConfiguration.Builder> filter) {
            return filter(RetrievalFilterConfiguration.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The number of results to retrieve.
         * </p>
         * 
         * @param numberOfResults
         *        The number of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfResults(Integer numberOfResults);

        /**
         * <p>
         * Override setting for the knowledge base search type during retrieval.
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        Override setting for the knowledge base search type during retrieval.
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType);

        /**
         * <p>
         * Override setting for the knowledge base search type during retrieval.
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        Override setting for the knowledge base search type during retrieval.
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType);
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeSource knowledgeSource;

        private RetrievalFilterConfiguration filter;

        private Integer numberOfResults;

        private String overrideKnowledgeBaseSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalConfiguration model) {
            knowledgeSource(model.knowledgeSource);
            filter(model.filter);
            numberOfResults(model.numberOfResults);
            overrideKnowledgeBaseSearchType(model.overrideKnowledgeBaseSearchType);
        }

        public final KnowledgeSource.Builder getKnowledgeSource() {
            return knowledgeSource != null ? knowledgeSource.toBuilder() : null;
        }

        public final void setKnowledgeSource(KnowledgeSource.BuilderImpl knowledgeSource) {
            this.knowledgeSource = knowledgeSource != null ? knowledgeSource.build() : null;
        }

        @Override
        public final Builder knowledgeSource(KnowledgeSource knowledgeSource) {
            this.knowledgeSource = knowledgeSource;
            return this;
        }

        public final RetrievalFilterConfiguration.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(RetrievalFilterConfiguration.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(RetrievalFilterConfiguration filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getNumberOfResults() {
            return numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final String getOverrideKnowledgeBaseSearchType() {
            return overrideKnowledgeBaseSearchType;
        }

        public final void setOverrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
            return this;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType(overrideKnowledgeBaseSearchType == null ? null : overrideKnowledgeBaseSearchType
                    .toString());
            return this;
        }

        @Override
        public RetrievalConfiguration build() {
            return new RetrievalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
