/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The quick response fields to filter the quick response query results by.
 * </p>
 * <p>
 * The following is the list of supported field names.
 * </p>
 * <ul>
 * <li>
 * <p>
 * name
 * </p>
 * </li>
 * <li>
 * <p>
 * description
 * </p>
 * </li>
 * <li>
 * <p>
 * shortcutKey
 * </p>
 * </li>
 * <li>
 * <p>
 * isActive
 * </p>
 * </li>
 * <li>
 * <p>
 * channels
 * </p>
 * </li>
 * <li>
 * <p>
 * language
 * </p>
 * </li>
 * <li>
 * <p>
 * contentType
 * </p>
 * </li>
 * <li>
 * <p>
 * createdTime
 * </p>
 * </li>
 * <li>
 * <p>
 * lastModifiedTime
 * </p>
 * </li>
 * <li>
 * <p>
 * lastModifiedBy
 * </p>
 * </li>
 * <li>
 * <p>
 * groupingConfiguration.criteria
 * </p>
 * </li>
 * <li>
 * <p>
 * groupingConfiguration.values
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickResponseFilterField implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickResponseFilterField.Builder, QuickResponseFilterField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(QuickResponseFilterField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(QuickResponseFilterField::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(QuickResponseFilterField::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<Boolean> INCLUDE_NO_EXISTENCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeNoExistence").getter(getter(QuickResponseFilterField::includeNoExistence))
            .setter(setter(Builder::includeNoExistence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeNoExistence").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            OPERATOR_FIELD, INCLUDE_NO_EXISTENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String operator;

    private final Boolean includeNoExistence;

    private QuickResponseFilterField(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.operator = builder.operator;
        this.includeNoExistence = builder.includeNoExistence;
    }

    /**
     * <p>
     * The name of the attribute field to filter the quick responses by.
     * </p>
     * 
     * @return The name of the attribute field to filter the quick responses by.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of attribute field to filter the quick response by.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values of attribute field to filter the quick response by.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator to use for filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link QuickResponseFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for filtering.
     * @see QuickResponseFilterOperator
     */
    public final QuickResponseFilterOperator operator() {
        return QuickResponseFilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to use for filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link QuickResponseFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to use for filtering.
     * @see QuickResponseFilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * Whether to treat null value as a match for the attribute field.
     * </p>
     * 
     * @return Whether to treat null value as a match for the attribute field.
     */
    public final Boolean includeNoExistence() {
        return includeNoExistence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeNoExistence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseFilterField)) {
            return false;
        }
        QuickResponseFilterField other = (QuickResponseFilterField) obj;
        return Objects.equals(name(), other.name()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(includeNoExistence(), other.includeNoExistence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickResponseFilterField").add("Name", name()).add("Values", hasValues() ? values() : null)
                .add("Operator", operatorAsString()).add("IncludeNoExistence", includeNoExistence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "includeNoExistence":
            return Optional.ofNullable(clazz.cast(includeNoExistence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("includeNoExistence", INCLUDE_NO_EXISTENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseFilterField, T> g) {
        return obj -> g.apply((QuickResponseFilterField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickResponseFilterField> {
        /**
         * <p>
         * The name of the attribute field to filter the quick responses by.
         * </p>
         * 
         * @param name
         *        The name of the attribute field to filter the quick responses by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The values of attribute field to filter the quick response by.
         * </p>
         * 
         * @param values
         *        The values of attribute field to filter the quick response by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values of attribute field to filter the quick response by.
         * </p>
         * 
         * @param values
         *        The values of attribute field to filter the quick response by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator to use for filtering.
         * </p>
         * 
         * @param operator
         *        The operator to use for filtering.
         * @see QuickResponseFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickResponseFilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to use for filtering.
         * </p>
         * 
         * @param operator
         *        The operator to use for filtering.
         * @see QuickResponseFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickResponseFilterOperator
         */
        Builder operator(QuickResponseFilterOperator operator);

        /**
         * <p>
         * Whether to treat null value as a match for the attribute field.
         * </p>
         * 
         * @param includeNoExistence
         *        Whether to treat null value as a match for the attribute field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeNoExistence(Boolean includeNoExistence);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private Boolean includeNoExistence;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseFilterField model) {
            name(model.name);
            values(model.values);
            operator(model.operator);
            includeNoExistence(model.includeNoExistence);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = QuickResponseFilterValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = QuickResponseFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(QuickResponseFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Boolean getIncludeNoExistence() {
            return includeNoExistence;
        }

        public final void setIncludeNoExistence(Boolean includeNoExistence) {
            this.includeNoExistence = includeNoExistence;
        }

        @Override
        public final Builder includeNoExistence(Boolean includeNoExistence) {
            this.includeNoExistence = includeNoExistence;
            return this;
        }

        @Override
        public QuickResponseFilterField build() {
            return new QuickResponseFilterField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
