/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for AI Agents of type <code>ORCHESTRATION</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationAIAgentConfiguration.Builder, OrchestrationAIAgentConfiguration> {
    private static final SdkField<String> ORCHESTRATION_AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestrationAIPromptId").getter(getter(OrchestrationAIAgentConfiguration::orchestrationAIPromptId))
            .setter(setter(Builder::orchestrationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationAIPromptId").build())
            .build();

    private static final SdkField<String> ORCHESTRATION_AI_GUARDRAIL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("orchestrationAIGuardrailId")
            .getter(getter(OrchestrationAIAgentConfiguration::orchestrationAIGuardrailId))
            .setter(setter(Builder::orchestrationAIGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationAIGuardrailId").build())
            .build();

    private static final SdkField<List<ToolConfiguration>> TOOL_CONFIGURATIONS_FIELD = SdkField
            .<List<ToolConfiguration>> builder(MarshallingType.LIST)
            .memberName("toolConfigurations")
            .getter(getter(OrchestrationAIAgentConfiguration::toolConfigurations))
            .setter(setter(Builder::toolConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToolConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToolConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECT_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceArn").getter(getter(OrchestrationAIAgentConfiguration::connectInstanceArn))
            .setter(setter(Builder::connectInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceArn").build())
            .build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(OrchestrationAIAgentConfiguration::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORCHESTRATION_AI_PROMPT_ID_FIELD, ORCHESTRATION_AI_GUARDRAIL_ID_FIELD, TOOL_CONFIGURATIONS_FIELD,
            CONNECT_INSTANCE_ARN_FIELD, LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String orchestrationAIPromptId;

    private final String orchestrationAIGuardrailId;

    private final List<ToolConfiguration> toolConfigurations;

    private final String connectInstanceArn;

    private final String locale;

    private OrchestrationAIAgentConfiguration(BuilderImpl builder) {
        this.orchestrationAIPromptId = builder.orchestrationAIPromptId;
        this.orchestrationAIGuardrailId = builder.orchestrationAIGuardrailId;
        this.toolConfigurations = builder.toolConfigurations;
        this.connectInstanceArn = builder.connectInstanceArn;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The AI Prompt identifier used by the Orchestration AI Agent.
     * </p>
     * 
     * @return The AI Prompt identifier used by the Orchestration AI Agent.
     */
    public final String orchestrationAIPromptId() {
        return orchestrationAIPromptId;
    }

    /**
     * <p>
     * The AI Guardrail identifier used by the Orchestration AI Agent.
     * </p>
     * 
     * @return The AI Guardrail identifier used by the Orchestration AI Agent.
     */
    public final String orchestrationAIGuardrailId() {
        return orchestrationAIGuardrailId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ToolConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasToolConfigurations() {
        return toolConfigurations != null && !(toolConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tool configurations used by the Orchestration AI Agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToolConfigurations} method.
     * </p>
     * 
     * @return The tool configurations used by the Orchestration AI Agent.
     */
    public final List<ToolConfiguration> toolConfigurations() {
        return toolConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Connect instance used by the Orchestration AI Agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Connect instance used by the Orchestration AI Agent.
     */
    public final String connectInstanceArn() {
        return connectInstanceArn;
    }

    /**
     * <p>
     * The locale setting for the Orchestration AI Agent.
     * </p>
     * 
     * @return The locale setting for the Orchestration AI Agent.
     */
    public final String locale() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(hasToolConfigurations() ? toolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationAIAgentConfiguration)) {
            return false;
        }
        OrchestrationAIAgentConfiguration other = (OrchestrationAIAgentConfiguration) obj;
        return Objects.equals(orchestrationAIPromptId(), other.orchestrationAIPromptId())
                && Objects.equals(orchestrationAIGuardrailId(), other.orchestrationAIGuardrailId())
                && hasToolConfigurations() == other.hasToolConfigurations()
                && Objects.equals(toolConfigurations(), other.toolConfigurations())
                && Objects.equals(connectInstanceArn(), other.connectInstanceArn()) && Objects.equals(locale(), other.locale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationAIAgentConfiguration").add("OrchestrationAIPromptId", orchestrationAIPromptId())
                .add("OrchestrationAIGuardrailId", orchestrationAIGuardrailId())
                .add("ToolConfigurations", hasToolConfigurations() ? toolConfigurations() : null)
                .add("ConnectInstanceArn", connectInstanceArn()).add("Locale", locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "orchestrationAIPromptId":
            return Optional.ofNullable(clazz.cast(orchestrationAIPromptId()));
        case "orchestrationAIGuardrailId":
            return Optional.ofNullable(clazz.cast(orchestrationAIGuardrailId()));
        case "toolConfigurations":
            return Optional.ofNullable(clazz.cast(toolConfigurations()));
        case "connectInstanceArn":
            return Optional.ofNullable(clazz.cast(connectInstanceArn()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("orchestrationAIPromptId", ORCHESTRATION_AI_PROMPT_ID_FIELD);
        map.put("orchestrationAIGuardrailId", ORCHESTRATION_AI_GUARDRAIL_ID_FIELD);
        map.put("toolConfigurations", TOOL_CONFIGURATIONS_FIELD);
        map.put("connectInstanceArn", CONNECT_INSTANCE_ARN_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationAIAgentConfiguration, T> g) {
        return obj -> g.apply((OrchestrationAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationAIAgentConfiguration> {
        /**
         * <p>
         * The AI Prompt identifier used by the Orchestration AI Agent.
         * </p>
         * 
         * @param orchestrationAIPromptId
         *        The AI Prompt identifier used by the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationAIPromptId(String orchestrationAIPromptId);

        /**
         * <p>
         * The AI Guardrail identifier used by the Orchestration AI Agent.
         * </p>
         * 
         * @param orchestrationAIGuardrailId
         *        The AI Guardrail identifier used by the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationAIGuardrailId(String orchestrationAIGuardrailId);

        /**
         * <p>
         * The tool configurations used by the Orchestration AI Agent.
         * </p>
         * 
         * @param toolConfigurations
         *        The tool configurations used by the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolConfigurations(Collection<ToolConfiguration> toolConfigurations);

        /**
         * <p>
         * The tool configurations used by the Orchestration AI Agent.
         * </p>
         * 
         * @param toolConfigurations
         *        The tool configurations used by the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolConfigurations(ToolConfiguration... toolConfigurations);

        /**
         * <p>
         * The tool configurations used by the Orchestration AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.ToolConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.ToolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.ToolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #toolConfigurations(List<ToolConfiguration>)}.
         * 
         * @param toolConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.ToolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolConfigurations(java.util.Collection<ToolConfiguration>)
         */
        Builder toolConfigurations(Consumer<ToolConfiguration.Builder>... toolConfigurations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Connect instance used by the Orchestration AI Agent.
         * </p>
         * 
         * @param connectInstanceArn
         *        The Amazon Resource Name (ARN) of the Amazon Connect instance used by the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceArn(String connectInstanceArn);

        /**
         * <p>
         * The locale setting for the Orchestration AI Agent.
         * </p>
         * 
         * @param locale
         *        The locale setting for the Orchestration AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);
    }

    static final class BuilderImpl implements Builder {
        private String orchestrationAIPromptId;

        private String orchestrationAIGuardrailId;

        private List<ToolConfiguration> toolConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String connectInstanceArn;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationAIAgentConfiguration model) {
            orchestrationAIPromptId(model.orchestrationAIPromptId);
            orchestrationAIGuardrailId(model.orchestrationAIGuardrailId);
            toolConfigurations(model.toolConfigurations);
            connectInstanceArn(model.connectInstanceArn);
            locale(model.locale);
        }

        public final String getOrchestrationAIPromptId() {
            return orchestrationAIPromptId;
        }

        public final void setOrchestrationAIPromptId(String orchestrationAIPromptId) {
            this.orchestrationAIPromptId = orchestrationAIPromptId;
        }

        @Override
        public final Builder orchestrationAIPromptId(String orchestrationAIPromptId) {
            this.orchestrationAIPromptId = orchestrationAIPromptId;
            return this;
        }

        public final String getOrchestrationAIGuardrailId() {
            return orchestrationAIGuardrailId;
        }

        public final void setOrchestrationAIGuardrailId(String orchestrationAIGuardrailId) {
            this.orchestrationAIGuardrailId = orchestrationAIGuardrailId;
        }

        @Override
        public final Builder orchestrationAIGuardrailId(String orchestrationAIGuardrailId) {
            this.orchestrationAIGuardrailId = orchestrationAIGuardrailId;
            return this;
        }

        public final List<ToolConfiguration.Builder> getToolConfigurations() {
            List<ToolConfiguration.Builder> result = ToolConfigurationListCopier.copyToBuilder(this.toolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolConfigurations(Collection<ToolConfiguration.BuilderImpl> toolConfigurations) {
            this.toolConfigurations = ToolConfigurationListCopier.copyFromBuilder(toolConfigurations);
        }

        @Override
        public final Builder toolConfigurations(Collection<ToolConfiguration> toolConfigurations) {
            this.toolConfigurations = ToolConfigurationListCopier.copy(toolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolConfigurations(ToolConfiguration... toolConfigurations) {
            toolConfigurations(Arrays.asList(toolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolConfigurations(Consumer<ToolConfiguration.Builder>... toolConfigurations) {
            toolConfigurations(Stream.of(toolConfigurations).map(c -> ToolConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getConnectInstanceArn() {
            return connectInstanceArn;
        }

        public final void setConnectInstanceArn(String connectInstanceArn) {
            this.connectInstanceArn = connectInstanceArn;
        }

        @Override
        public final Builder connectInstanceArn(String connectInstanceArn) {
            this.connectInstanceArn = connectInstanceArn;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public OrchestrationAIAgentConfiguration build() {
            return new OrchestrationAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
