/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source configuration for managed resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedSourceConfiguration.Builder, ManagedSourceConfiguration> {
    private static final SdkField<WebCrawlerConfiguration> WEB_CRAWLER_CONFIGURATION_FIELD = SdkField
            .<WebCrawlerConfiguration> builder(MarshallingType.SDK_POJO).memberName("webCrawlerConfiguration")
            .getter(getter(ManagedSourceConfiguration::webCrawlerConfiguration)).setter(setter(Builder::webCrawlerConfiguration))
            .constructor(WebCrawlerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webCrawlerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WEB_CRAWLER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WebCrawlerConfiguration webCrawlerConfiguration;

    private final Type type;

    private ManagedSourceConfiguration(BuilderImpl builder) {
        this.webCrawlerConfiguration = builder.webCrawlerConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration data for web crawler data source.
     * </p>
     * 
     * @return Configuration data for web crawler data source.
     */
    public final WebCrawlerConfiguration webCrawlerConfiguration() {
        return webCrawlerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webCrawlerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedSourceConfiguration)) {
            return false;
        }
        ManagedSourceConfiguration other = (ManagedSourceConfiguration) obj;
        return Objects.equals(webCrawlerConfiguration(), other.webCrawlerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedSourceConfiguration").add("WebCrawlerConfiguration", webCrawlerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webCrawlerConfiguration":
            return Optional.ofNullable(clazz.cast(webCrawlerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #webCrawlerConfiguration()} initialized to the given value.
     *
     * <p>
     * Configuration data for web crawler data source.
     * </p>
     * 
     * @param webCrawlerConfiguration
     *        Configuration data for web crawler data source.
     */
    public static ManagedSourceConfiguration fromWebCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration) {
        return builder().webCrawlerConfiguration(webCrawlerConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #webCrawlerConfiguration()} initialized to the given value.
     *
     * <p>
     * Configuration data for web crawler data source.
     * </p>
     * 
     * @param webCrawlerConfiguration
     *        Configuration data for web crawler data source.
     */
    public static ManagedSourceConfiguration fromWebCrawlerConfiguration(
            Consumer<WebCrawlerConfiguration.Builder> webCrawlerConfiguration) {
        WebCrawlerConfiguration.Builder builder = WebCrawlerConfiguration.builder();
        webCrawlerConfiguration.accept(builder);
        return fromWebCrawlerConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("webCrawlerConfiguration", WEB_CRAWLER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedSourceConfiguration, T> g) {
        return obj -> g.apply((ManagedSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedSourceConfiguration> {
        /**
         * <p>
         * Configuration data for web crawler data source.
         * </p>
         * 
         * @param webCrawlerConfiguration
         *        Configuration data for web crawler data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration);

        /**
         * <p>
         * Configuration data for web crawler data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebCrawlerConfiguration.Builder} avoiding
         * the need to create one manually via {@link WebCrawlerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebCrawlerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #webCrawlerConfiguration(WebCrawlerConfiguration)}.
         * 
         * @param webCrawlerConfiguration
         *        a consumer that will call methods on {@link WebCrawlerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webCrawlerConfiguration(WebCrawlerConfiguration)
         */
        default Builder webCrawlerConfiguration(Consumer<WebCrawlerConfiguration.Builder> webCrawlerConfiguration) {
            return webCrawlerConfiguration(WebCrawlerConfiguration.builder().applyMutation(webCrawlerConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WebCrawlerConfiguration webCrawlerConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedSourceConfiguration model) {
            webCrawlerConfiguration(model.webCrawlerConfiguration);
        }

        public final WebCrawlerConfiguration.Builder getWebCrawlerConfiguration() {
            return webCrawlerConfiguration != null ? webCrawlerConfiguration.toBuilder() : null;
        }

        public final void setWebCrawlerConfiguration(WebCrawlerConfiguration.BuilderImpl webCrawlerConfiguration) {
            Object oldValue = this.webCrawlerConfiguration;
            this.webCrawlerConfiguration = webCrawlerConfiguration != null ? webCrawlerConfiguration.build() : null;
            handleUnionValueChange(Type.WEB_CRAWLER_CONFIGURATION, oldValue, this.webCrawlerConfiguration);
        }

        @Override
        public final Builder webCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration) {
            Object oldValue = this.webCrawlerConfiguration;
            this.webCrawlerConfiguration = webCrawlerConfiguration;
            handleUnionValueChange(Type.WEB_CRAWLER_CONFIGURATION, oldValue, this.webCrawlerConfiguration);
            return this;
        }

        @Override
        public ManagedSourceConfiguration build() {
            return new ManagedSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ManagedSourceConfiguration#type()
     */
    public enum Type {
        WEB_CRAWLER_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
