/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSpansResponse extends QConnectResponse implements
        ToCopyableBuilder<ListSpansResponse.Builder, ListSpansResponse> {
    private static final SdkField<List<Span>> SPANS_FIELD = SdkField
            .<List<Span>> builder(MarshallingType.LIST)
            .memberName("spans")
            .getter(getter(ListSpansResponse::spans))
            .setter(setter(Builder::spans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Span> builder(MarshallingType.SDK_POJO)
                                            .constructor(Span::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSpansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SPANS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Span> spans;

    private final String nextToken;

    private ListSpansResponse(BuilderImpl builder) {
        super(builder);
        this.spans = builder.spans;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spans property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSpans() {
        return spans != null && !(spans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of span objects for the session
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpans} method.
     * </p>
     * 
     * @return Array of span objects for the session
     */
    public final List<Span> spans() {
        return spans;
    }

    /**
     * <p>
     * Pagination token for retrieving additional results
     * </p>
     * 
     * @return Pagination token for retrieving additional results
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSpans() ? spans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpansResponse)) {
            return false;
        }
        ListSpansResponse other = (ListSpansResponse) obj;
        return hasSpans() == other.hasSpans() && Objects.equals(spans(), other.spans())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSpansResponse").add("Spans", hasSpans() ? spans() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spans":
            return Optional.ofNullable(clazz.cast(spans()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spans", SPANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpansResponse, T> g) {
        return obj -> g.apply((ListSpansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSpansResponse> {
        /**
         * <p>
         * Array of span objects for the session
         * </p>
         * 
         * @param spans
         *        Array of span objects for the session
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(Collection<Span> spans);

        /**
         * <p>
         * Array of span objects for the session
         * </p>
         * 
         * @param spans
         *        Array of span objects for the session
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(Span... spans);

        /**
         * <p>
         * Array of span objects for the session
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.Span.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qconnect.model.Span#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.Span.Builder#build()} is called immediately and its
         * result is passed to {@link #spans(List<Span>)}.
         * 
         * @param spans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.Span.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spans(java.util.Collection<Span>)
         */
        Builder spans(Consumer<Span.Builder>... spans);

        /**
         * <p>
         * Pagination token for retrieving additional results
         * </p>
         * 
         * @param nextToken
         *        Pagination token for retrieving additional results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<Span> spans = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpansResponse model) {
            super(model);
            spans(model.spans);
            nextToken(model.nextToken);
        }

        public final List<Span.Builder> getSpans() {
            List<Span.Builder> result = SpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<Span.BuilderImpl> spans) {
            this.spans = SpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<Span> spans) {
            this.spans = SpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Span... spans) {
            spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<Span.Builder>... spans) {
            spans(Stream.of(spans).map(c -> Span.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSpansResponse build() {
            return new ListSpansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
