/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A knowledge source that provides content for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeSource implements SdkPojo, Serializable, ToCopyableBuilder<KnowledgeSource.Builder, KnowledgeSource> {
    private static final SdkField<List<String>> ASSISTANT_ASSOCIATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assistantAssociationIds")
            .getter(getter(KnowledgeSource::assistantAssociationIds))
            .setter(setter(Builder::assistantAssociationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ASSISTANT_ASSOCIATION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> assistantAssociationIds;

    private final Type type;

    private KnowledgeSource(BuilderImpl builder) {
        this.assistantAssociationIds = builder.assistantAssociationIds;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssistantAssociationIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssistantAssociationIds() {
        return assistantAssociationIds != null && !(assistantAssociationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of assistant association identifiers for the knowledge source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssistantAssociationIds} method.
     * </p>
     * 
     * @return The list of assistant association identifiers for the knowledge source.
     */
    public final List<String> assistantAssociationIds() {
        return assistantAssociationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssistantAssociationIds() ? assistantAssociationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeSource)) {
            return false;
        }
        KnowledgeSource other = (KnowledgeSource) obj;
        return hasAssistantAssociationIds() == other.hasAssistantAssociationIds()
                && Objects.equals(assistantAssociationIds(), other.assistantAssociationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeSource")
                .add("AssistantAssociationIds", hasAssistantAssociationIds() ? assistantAssociationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantAssociationIds":
            return Optional.ofNullable(clazz.cast(assistantAssociationIds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #assistantAssociationIds()} initialized to the given value.
     *
     * <p>
     * The list of assistant association identifiers for the knowledge source.
     * </p>
     * 
     * @param assistantAssociationIds
     *        The list of assistant association identifiers for the knowledge source.
     */
    public static KnowledgeSource fromAssistantAssociationIds(List<String> assistantAssociationIds) {
        return builder().assistantAssociationIds(assistantAssociationIds).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantAssociationIds", ASSISTANT_ASSOCIATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeSource, T> g) {
        return obj -> g.apply((KnowledgeSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeSource> {
        /**
         * <p>
         * The list of assistant association identifiers for the knowledge source.
         * </p>
         * 
         * @param assistantAssociationIds
         *        The list of assistant association identifiers for the knowledge source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationIds(Collection<String> assistantAssociationIds);

        /**
         * <p>
         * The list of assistant association identifiers for the knowledge source.
         * </p>
         * 
         * @param assistantAssociationIds
         *        The list of assistant association identifiers for the knowledge source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationIds(String... assistantAssociationIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> assistantAssociationIds = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeSource model) {
            assistantAssociationIds(model.assistantAssociationIds);
        }

        public final Collection<String> getAssistantAssociationIds() {
            if (assistantAssociationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return assistantAssociationIds;
        }

        public final void setAssistantAssociationIds(Collection<String> assistantAssociationIds) {
            Object oldValue = this.assistantAssociationIds;
            this.assistantAssociationIds = AssistantAssociationIdListCopier.copy(assistantAssociationIds);
            handleUnionValueChange(Type.ASSISTANT_ASSOCIATION_IDS, oldValue, this.assistantAssociationIds);
        }

        @Override
        public final Builder assistantAssociationIds(Collection<String> assistantAssociationIds) {
            Object oldValue = this.assistantAssociationIds;
            this.assistantAssociationIds = AssistantAssociationIdListCopier.copy(assistantAssociationIds);
            handleUnionValueChange(Type.ASSISTANT_ASSOCIATION_IDS, oldValue, this.assistantAssociationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationIds(String... assistantAssociationIds) {
            assistantAssociationIds(Arrays.asList(assistantAssociationIds));
            return this;
        }

        @Override
        public KnowledgeSource build() {
            return new KnowledgeSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see KnowledgeSource#type()
     */
    public enum Type {
        ASSISTANT_ASSOCIATION_IDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
