/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseData implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseData.Builder, KnowledgeBaseData> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseData::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(KnowledgeBaseData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(KnowledgeBaseData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseType").getter(getter(KnowledgeBaseData::knowledgeBaseTypeAsString))
            .setter(setter(Builder::knowledgeBaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KnowledgeBaseData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_CONTENT_MODIFICATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastContentModificationTime")
            .getter(getter(KnowledgeBaseData::lastContentModificationTime))
            .setter(setter(Builder::lastContentModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastContentModificationTime")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField
            .<VectorIngestionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("vectorIngestionConfiguration")
            .getter(getter(KnowledgeBaseData::vectorIngestionConfiguration))
            .setter(setter(Builder::vectorIngestionConfiguration))
            .constructor(VectorIngestionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration")
                    .build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(KnowledgeBaseData::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField
            .<RenderingConfiguration> builder(MarshallingType.SDK_POJO).memberName("renderingConfiguration")
            .getter(getter(KnowledgeBaseData::renderingConfiguration)).setter(setter(Builder::renderingConfiguration))
            .constructor(RenderingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build())
            .build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(KnowledgeBaseData::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(KnowledgeBaseData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(KnowledgeBaseData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionStatus").getter(getter(KnowledgeBaseData::ingestionStatusAsString))
            .setter(setter(Builder::ingestionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionStatus").build()).build();

    private static final SdkField<List<String>> INGESTION_FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ingestionFailureReasons")
            .getter(getter(KnowledgeBaseData::ingestionFailureReasons))
            .setter(setter(Builder::ingestionFailureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionFailureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            KNOWLEDGE_BASE_ARN_FIELD, NAME_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, STATUS_FIELD, LAST_CONTENT_MODIFICATION_TIME_FIELD,
            VECTOR_INGESTION_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD, RENDERING_CONFIGURATION_FIELD,
            SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, INGESTION_STATUS_FIELD,
            INGESTION_FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String knowledgeBaseArn;

    private final String name;

    private final String knowledgeBaseType;

    private final String status;

    private final Instant lastContentModificationTime;

    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private final SourceConfiguration sourceConfiguration;

    private final RenderingConfiguration renderingConfiguration;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final String description;

    private final Map<String, String> tags;

    private final String ingestionStatus;

    private final List<String> ingestionFailureReasons;

    private KnowledgeBaseData(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.name = builder.name;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.status = builder.status;
        this.lastContentModificationTime = builder.lastContentModificationTime;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
        this.ingestionStatus = builder.ingestionStatus;
        this.ingestionFailureReasons = builder.ingestionFailureReasons;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The name of the knowledge base.
     * </p>
     * 
     * @return The name of the knowledge base.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base.
     * @see KnowledgeBaseType
     */
    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(knowledgeBaseType);
    }

    /**
     * <p>
     * The type of knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base.
     * @see KnowledgeBaseType
     */
    public final String knowledgeBaseTypeAsString() {
        return knowledgeBaseType;
    }

    /**
     * <p>
     * The status of the knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the knowledge base.
     * @see KnowledgeBaseStatus
     */
    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the knowledge base.
     * @see KnowledgeBaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content
     * exists in a knowledge base, this value is unset.
     * </p>
     * 
     * @return An epoch timestamp indicating the most recent content modification inside the knowledge base. If no
     *         content exists in a knowledge base, this value is unset.
     */
    public final Instant lastContentModificationTime() {
        return lastContentModificationTime;
    }

    /**
     * <p>
     * Contains details about how to ingest the documents in a data source.
     * </p>
     * 
     * @return Contains details about how to ingest the documents in a data source.
     */
    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return vectorIngestionConfiguration;
    }

    /**
     * <p>
     * Source configuration information about the knowledge base.
     * </p>
     * 
     * @return Source configuration information about the knowledge base.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * Information about how to render the content.
     * </p>
     * 
     * @return Information about how to render the content.
     */
    public final RenderingConfiguration renderingConfiguration() {
        return renderingConfiguration;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
     * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key to
     * invoke Amazon Q in Connect.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     * 
     * @return The configuration information for the customer managed key used for encryption. </p>
     *         <p>
     *         This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
     *         <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the
     *         key to invoke Amazon Q in Connect.
     *         </p>
     *         <p>
     *         For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
     *         your instance</a>.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Status of ingestion on data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link SyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return Status of ingestion on data source.
     * @see SyncStatus
     */
    public final SyncStatus ingestionStatus() {
        return SyncStatus.fromValue(ingestionStatus);
    }

    /**
     * <p>
     * Status of ingestion on data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionStatus}
     * will return {@link SyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionStatusAsString}.
     * </p>
     * 
     * @return Status of ingestion on data source.
     * @see SyncStatus
     */
    public final String ingestionStatusAsString() {
        return ingestionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngestionFailureReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIngestionFailureReasons() {
        return ingestionFailureReasons != null && !(ingestionFailureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of failure reasons on ingestion per file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngestionFailureReasons} method.
     * </p>
     * 
     * @return List of failure reasons on ingestion per file.
     */
    public final List<String> ingestionFailureReasons() {
        return ingestionFailureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastContentModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIngestionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIngestionFailureReasons() ? ingestionFailureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseData)) {
            return false;
        }
        KnowledgeBaseData other = (KnowledgeBaseData) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(name(), other.name())
                && Objects.equals(knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastContentModificationTime(), other.lastContentModificationTime())
                && Objects.equals(vectorIngestionConfiguration(), other.vectorIngestionConfiguration())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(renderingConfiguration(), other.renderingConfiguration())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(ingestionStatusAsString(), other.ingestionStatusAsString())
                && hasIngestionFailureReasons() == other.hasIngestionFailureReasons()
                && Objects.equals(ingestionFailureReasons(), other.ingestionFailureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseData").add("KnowledgeBaseId", knowledgeBaseId())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("Name", name())
                .add("KnowledgeBaseType", knowledgeBaseTypeAsString()).add("Status", statusAsString())
                .add("LastContentModificationTime", lastContentModificationTime())
                .add("VectorIngestionConfiguration", vectorIngestionConfiguration())
                .add("SourceConfiguration", sourceConfiguration()).add("RenderingConfiguration", renderingConfiguration())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("IngestionStatus", ingestionStatusAsString())
                .add("IngestionFailureReasons", hasIngestionFailureReasons() ? ingestionFailureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "knowledgeBaseType":
            return Optional.ofNullable(clazz.cast(knowledgeBaseTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastContentModificationTime":
            return Optional.ofNullable(clazz.cast(lastContentModificationTime()));
        case "vectorIngestionConfiguration":
            return Optional.ofNullable(clazz.cast(vectorIngestionConfiguration()));
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "renderingConfiguration":
            return Optional.ofNullable(clazz.cast(renderingConfiguration()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ingestionStatus":
            return Optional.ofNullable(clazz.cast(ingestionStatusAsString()));
        case "ingestionFailureReasons":
            return Optional.ofNullable(clazz.cast(ingestionFailureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("knowledgeBaseType", KNOWLEDGE_BASE_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastContentModificationTime", LAST_CONTENT_MODIFICATION_TIME_FIELD);
        map.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        map.put("renderingConfiguration", RENDERING_CONFIGURATION_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("ingestionStatus", INGESTION_STATUS_FIELD);
        map.put("ingestionFailureReasons", INGESTION_FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseData, T> g) {
        return obj -> g.apply((KnowledgeBaseData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseData> {
        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The name of the knowledge base.
         * </p>
         * 
         * @param name
         *        The name of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of knowledge base.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(String knowledgeBaseType);

        /**
         * <p>
         * The type of knowledge base.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType);

        /**
         * <p>
         * The status of the knowledge base.
         * </p>
         * 
         * @param status
         *        The status of the knowledge base.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the knowledge base.
         * </p>
         * 
         * @param status
         *        The status of the knowledge base.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(KnowledgeBaseStatus status);

        /**
         * <p>
         * An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content
         * exists in a knowledge base, this value is unset.
         * </p>
         * 
         * @param lastContentModificationTime
         *        An epoch timestamp indicating the most recent content modification inside the knowledge base. If no
         *        content exists in a knowledge base, this value is unset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastContentModificationTime(Instant lastContentModificationTime);

        /**
         * <p>
         * Contains details about how to ingest the documents in a data source.
         * </p>
         * 
         * @param vectorIngestionConfiguration
         *        Contains details about how to ingest the documents in a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration);

        /**
         * <p>
         * Contains details about how to ingest the documents in a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorIngestionConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorIngestionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorIngestionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vectorIngestionConfiguration(VectorIngestionConfiguration)}.
         * 
         * @param vectorIngestionConfiguration
         *        a consumer that will call methods on {@link VectorIngestionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorIngestionConfiguration(VectorIngestionConfiguration)
         */
        default Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return vectorIngestionConfiguration(VectorIngestionConfiguration.builder()
                    .applyMutation(vectorIngestionConfiguration).build());
        }

        /**
         * <p>
         * Source configuration information about the knowledge base.
         * </p>
         * 
         * @param sourceConfiguration
         *        Source configuration information about the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * Source configuration information about the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * 
         * @param renderingConfiguration
         *        Information about how to render the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingConfiguration(RenderingConfiguration renderingConfiguration);

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenderingConfiguration.Builder} avoiding
         * the need to create one manually via {@link RenderingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenderingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #renderingConfiguration(RenderingConfiguration)}.
         * 
         * @param renderingConfiguration
         *        a consumer that will call methods on {@link RenderingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingConfiguration(RenderingConfiguration)
         */
        default Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return renderingConfiguration(RenderingConfiguration.builder().applyMutation(renderingConfiguration).build());
        }

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
         * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key
         * to invoke Amazon Q in Connect.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
         * your instance</a>.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The configuration information for the customer managed key used for encryption. </p>
         *        <p>
         *        This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity
         *        using the key to invoke Amazon Q in Connect.
         *        </p>
         *        <p>
         *        For more information about setting up a customer managed key for Amazon Q in Connect, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect
         *        for your instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
         * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key
         * to invoke Amazon Q in Connect.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
         * your instance</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Status of ingestion on data source.
         * </p>
         * 
         * @param ingestionStatus
         *        Status of ingestion on data source.
         * @see SyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncStatus
         */
        Builder ingestionStatus(String ingestionStatus);

        /**
         * <p>
         * Status of ingestion on data source.
         * </p>
         * 
         * @param ingestionStatus
         *        Status of ingestion on data source.
         * @see SyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncStatus
         */
        Builder ingestionStatus(SyncStatus ingestionStatus);

        /**
         * <p>
         * List of failure reasons on ingestion per file.
         * </p>
         * 
         * @param ingestionFailureReasons
         *        List of failure reasons on ingestion per file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionFailureReasons(Collection<String> ingestionFailureReasons);

        /**
         * <p>
         * List of failure reasons on ingestion per file.
         * </p>
         * 
         * @param ingestionFailureReasons
         *        List of failure reasons on ingestion per file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionFailureReasons(String... ingestionFailureReasons);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String knowledgeBaseArn;

        private String name;

        private String knowledgeBaseType;

        private String status;

        private Instant lastContentModificationTime;

        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private SourceConfiguration sourceConfiguration;

        private RenderingConfiguration renderingConfiguration;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String ingestionStatus;

        private List<String> ingestionFailureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseData model) {
            knowledgeBaseId(model.knowledgeBaseId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            name(model.name);
            knowledgeBaseType(model.knowledgeBaseType);
            status(model.status);
            lastContentModificationTime(model.lastContentModificationTime);
            vectorIngestionConfiguration(model.vectorIngestionConfiguration);
            sourceConfiguration(model.sourceConfiguration);
            renderingConfiguration(model.renderingConfiguration);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            description(model.description);
            tags(model.tags);
            ingestionStatus(model.ingestionStatus);
            ingestionFailureReasons(model.ingestionFailureReasons);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastContentModificationTime() {
            return lastContentModificationTime;
        }

        public final void setLastContentModificationTime(Instant lastContentModificationTime) {
            this.lastContentModificationTime = lastContentModificationTime;
        }

        @Override
        public final Builder lastContentModificationTime(Instant lastContentModificationTime) {
            this.lastContentModificationTime = lastContentModificationTime;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return vectorIngestionConfiguration != null ? vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return renderingConfiguration != null ? renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getIngestionStatus() {
            return ingestionStatus;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(SyncStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final Collection<String> getIngestionFailureReasons() {
            if (ingestionFailureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return ingestionFailureReasons;
        }

        public final void setIngestionFailureReasons(Collection<String> ingestionFailureReasons) {
            this.ingestionFailureReasons = FailureReasonCopier.copy(ingestionFailureReasons);
        }

        @Override
        public final Builder ingestionFailureReasons(Collection<String> ingestionFailureReasons) {
            this.ingestionFailureReasons = FailureReasonCopier.copy(ingestionFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionFailureReasons(String... ingestionFailureReasons) {
            ingestionFailureReasons(Arrays.asList(ingestionFailureReasons));
            return this;
        }

        @Override
        public KnowledgeBaseData build() {
            return new KnowledgeBaseData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
