/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information of the grouping of Amazon Q in Connect users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupingConfiguration.Builder, GroupingConfiguration> {
    private static final SdkField<String> CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("criteria").getter(getter(GroupingConfiguration::criteria)).setter(setter(Builder::criteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(GroupingConfiguration::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String criteria;

    private final List<String> values;

    private GroupingConfiguration(BuilderImpl builder) {
        this.criteria = builder.criteria;
        this.values = builder.values;
    }

    /**
     * <p>
     * The criteria used for grouping Amazon Q in Connect users.
     * </p>
     * <p>
     * The following is the list of supported criteria values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RoutingProfileArn</code>: Grouping the users by their <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing
     * profile ARN</a>. User should have <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
     * >SearchRoutingProfile</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html"
     * >DescribeRoutingProfile</a> permissions when setting criteria to this value.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The criteria used for grouping Amazon Q in Connect users.</p>
     *         <p>
     *         The following is the list of supported criteria values.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RoutingProfileArn</code>: Grouping the users by their <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
     *         routing profile ARN</a>. User should have <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
     *         >SearchRoutingProfile</a> and <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html"
     *         >DescribeRoutingProfile</a> permissions when setting criteria to this value.
     *         </p>
     *         </li>
     */
    public final String criteria() {
        return criteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values that define different groups of Amazon Q in Connect users.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of ARNs of <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing
     * profiles</a> as values of this parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The list of values that define different groups of Amazon Q in Connect users.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of ARNs
     *         of <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon
     *         Connect routing profiles</a> as values of this parameter.
     *         </p>
     *         </li>
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingConfiguration)) {
            return false;
        }
        GroupingConfiguration other = (GroupingConfiguration) obj;
        return Objects.equals(criteria(), other.criteria()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupingConfiguration")
                .add("Criteria", criteria() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Values", values() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("criteria", CRITERIA_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupingConfiguration, T> g) {
        return obj -> g.apply((GroupingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupingConfiguration> {
        /**
         * <p>
         * The criteria used for grouping Amazon Q in Connect users.
         * </p>
         * <p>
         * The following is the list of supported criteria values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RoutingProfileArn</code>: Grouping the users by their <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing
         * profile ARN</a>. User should have <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
         * >SearchRoutingProfile</a> and <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html"
         * >DescribeRoutingProfile</a> permissions when setting criteria to this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param criteria
         *        The criteria used for grouping Amazon Q in Connect users.</p>
         *        <p>
         *        The following is the list of supported criteria values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RoutingProfileArn</code>: Grouping the users by their <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
         *        routing profile ARN</a>. User should have <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html"
         *        >SearchRoutingProfile</a> and <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html"
         *        >DescribeRoutingProfile</a> permissions when setting criteria to this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(String criteria);

        /**
         * <p>
         * The list of values that define different groups of Amazon Q in Connect users.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of ARNs of
         * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
         * routing profiles</a> as values of this parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The list of values that define different groups of Amazon Q in Connect users.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of
         *        ARNs of <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
         *        routing profiles</a> as values of this parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The list of values that define different groups of Amazon Q in Connect users.
         * </p>
         * <ul>
         * <li>
         * <p>
         * When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of ARNs of
         * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
         * routing profiles</a> as values of this parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The list of values that define different groups of Amazon Q in Connect users.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of
         *        ARNs of <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect
         *        routing profiles</a> as values of this parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String criteria;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingConfiguration model) {
            criteria(model.criteria);
            values(model.values);
        }

        public final String getCriteria() {
            return criteria;
        }

        public final void setCriteria(String criteria) {
            this.criteria = criteria;
        }

        @Override
        public final Builder criteria(String criteria) {
            this.criteria = criteria;
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = GroupingValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = GroupingValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public GroupingConfiguration build() {
            return new GroupingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
