/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAiPromptResponse extends QConnectResponse implements
        ToCopyableBuilder<GetAiPromptResponse.Builder, GetAiPromptResponse> {
    private static final SdkField<AIPromptData> AI_PROMPT_FIELD = SdkField.<AIPromptData> builder(MarshallingType.SDK_POJO)
            .memberName("aiPrompt").getter(getter(GetAiPromptResponse::aiPrompt)).setter(setter(Builder::aiPrompt))
            .constructor(AIPromptData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiPrompt").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(GetAiPromptResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_PROMPT_FIELD,
            VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AIPromptData aiPrompt;

    private final Long versionNumber;

    private GetAiPromptResponse(BuilderImpl builder) {
        super(builder);
        this.aiPrompt = builder.aiPrompt;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The data of the AI Prompt.
     * </p>
     * 
     * @return The data of the AI Prompt.
     */
    public final AIPromptData aiPrompt() {
        return aiPrompt;
    }

    /**
     * <p>
     * The version number of the AI Prompt version (returned if an AI Prompt version was specified via use of a
     * qualifier for the <code>aiPromptId</code> on the request).
     * </p>
     * 
     * @return The version number of the AI Prompt version (returned if an AI Prompt version was specified via use of a
     *         qualifier for the <code>aiPromptId</code> on the request).
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAiPromptResponse)) {
            return false;
        }
        GetAiPromptResponse other = (GetAiPromptResponse) obj;
        return Objects.equals(aiPrompt(), other.aiPrompt()) && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAiPromptResponse").add("AiPrompt", aiPrompt()).add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiPrompt":
            return Optional.ofNullable(clazz.cast(aiPrompt()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiPrompt", AI_PROMPT_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAiPromptResponse, T> g) {
        return obj -> g.apply((GetAiPromptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAiPromptResponse> {
        /**
         * <p>
         * The data of the AI Prompt.
         * </p>
         * 
         * @param aiPrompt
         *        The data of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiPrompt(AIPromptData aiPrompt);

        /**
         * <p>
         * The data of the AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptData.Builder} avoiding the need
         * to create one manually via {@link AIPromptData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptData.Builder#build()} is called immediately and its
         * result is passed to {@link #aiPrompt(AIPromptData)}.
         * 
         * @param aiPrompt
         *        a consumer that will call methods on {@link AIPromptData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiPrompt(AIPromptData)
         */
        default Builder aiPrompt(Consumer<AIPromptData.Builder> aiPrompt) {
            return aiPrompt(AIPromptData.builder().applyMutation(aiPrompt).build());
        }

        /**
         * <p>
         * The version number of the AI Prompt version (returned if an AI Prompt version was specified via use of a
         * qualifier for the <code>aiPromptId</code> on the request).
         * </p>
         * 
         * @param versionNumber
         *        The version number of the AI Prompt version (returned if an AI Prompt version was specified via use of
         *        a qualifier for the <code>aiPromptId</code> on the request).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private AIPromptData aiPrompt;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAiPromptResponse model) {
            super(model);
            aiPrompt(model.aiPrompt);
            versionNumber(model.versionNumber);
        }

        public final AIPromptData.Builder getAiPrompt() {
            return aiPrompt != null ? aiPrompt.toBuilder() : null;
        }

        public final void setAiPrompt(AIPromptData.BuilderImpl aiPrompt) {
            this.aiPrompt = aiPrompt != null ? aiPrompt.build() : null;
        }

        @Override
        public final Builder aiPrompt(AIPromptData aiPrompt) {
            this.aiPrompt = aiPrompt;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public GetAiPromptResponse build() {
            return new GetAiPromptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
