/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information of the external data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalSourceConfiguration.Builder, ExternalSourceConfiguration> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ExternalSourceConfiguration::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
            .memberName("configuration").getter(getter(ExternalSourceConfiguration::configuration))
            .setter(setter(Builder::configuration)).constructor(Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final Configuration configuration;

    private ExternalSourceConfiguration(BuilderImpl builder) {
        this.source = builder.source;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The type of the external data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ExternalSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The type of the external data source.
     * @see ExternalSource
     */
    public final ExternalSource source() {
        return ExternalSource.fromValue(source);
    }

    /**
     * <p>
     * The type of the external data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link ExternalSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The type of the external data source.
     * @see ExternalSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The configuration information of the external data source.
     * </p>
     * 
     * @return The configuration information of the external data source.
     */
    public final Configuration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourceConfiguration)) {
            return false;
        }
        ExternalSourceConfiguration other = (ExternalSourceConfiguration) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalSourceConfiguration").add("Source", sourceAsString())
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourceConfiguration, T> g) {
        return obj -> g.apply((ExternalSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalSourceConfiguration> {
        /**
         * <p>
         * The type of the external data source.
         * </p>
         * 
         * @param source
         *        The type of the external data source.
         * @see ExternalSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalSource
         */
        Builder source(String source);

        /**
         * <p>
         * The type of the external data source.
         * </p>
         * 
         * @param source
         *        The type of the external data source.
         * @see ExternalSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalSource
         */
        Builder source(ExternalSource source);

        /**
         * <p>
         * The configuration information of the external data source.
         * </p>
         * 
         * @param configuration
         *        The configuration information of the external data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Configuration configuration);

        /**
         * <p>
         * The configuration information of the external data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configuration.Builder} avoiding the need
         * to create one manually via {@link Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(Configuration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Configuration)
         */
        default Builder configuration(Consumer<Configuration.Builder> configuration) {
            return configuration(Configuration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private Configuration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourceConfiguration model) {
            source(model.source);
            configuration(model.configuration);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(ExternalSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public ExternalSourceConfiguration build() {
            return new ExternalSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
