/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The extended data of a message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtendedMessageTemplateData implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtendedMessageTemplateData.Builder, ExtendedMessageTemplateData> {
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateArn").getter(getter(ExtendedMessageTemplateData::messageTemplateArn))
            .setter(setter(Builder::messageTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build())
            .build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(ExtendedMessageTemplateData::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(ExtendedMessageTemplateData::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ExtendedMessageTemplateData::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ExtendedMessageTemplateData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(ExtendedMessageTemplateData::channel)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelSubtype").getter(getter(ExtendedMessageTemplateData::channelSubtypeAsString))
            .setter(setter(Builder::channelSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(ExtendedMessageTemplateData::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(ExtendedMessageTemplateData::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedBy").getter(getter(ExtendedMessageTemplateData::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()).build();

    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField
            .<MessageTemplateContentProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(ExtendedMessageTemplateData::content)).setter(setter(Builder::content))
            .constructor(MessageTemplateContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ExtendedMessageTemplateData::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(ExtendedMessageTemplateData::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<MessageTemplateSourceConfigurationSummary> SOURCE_CONFIGURATION_SUMMARY_FIELD = SdkField
            .<MessageTemplateSourceConfigurationSummary> builder(MarshallingType.SDK_POJO)
            .memberName("sourceConfigurationSummary")
            .getter(getter(ExtendedMessageTemplateData::sourceConfigurationSummary))
            .setter(setter(Builder::sourceConfigurationSummary))
            .constructor(MessageTemplateSourceConfigurationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfigurationSummary").build())
            .build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(ExtendedMessageTemplateData::groupingConfiguration)).setter(setter(Builder::groupingConfiguration))
            .constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField
            .<MessageTemplateAttributes> builder(MarshallingType.SDK_POJO).memberName("defaultAttributes")
            .getter(getter(ExtendedMessageTemplateData::defaultAttributes)).setter(setter(Builder::defaultAttributes))
            .constructor(MessageTemplateAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributeTypes")
            .getter(getter(ExtendedMessageTemplateData::attributeTypesAsStrings))
            .setter(setter(Builder::attributeTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MessageTemplateAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<MessageTemplateAttachment>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(ExtendedMessageTemplateData::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTemplateAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTemplateAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(ExtendedMessageTemplateData::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(ExtendedMessageTemplateData::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final SdkField<String> MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateContentSha256")
            .getter(getter(ExtendedMessageTemplateData::messageTemplateContentSha256))
            .setter(setter(Builder::messageTemplateContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateContentSha256")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ExtendedMessageTemplateData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TEMPLATE_ARN_FIELD,
            MESSAGE_TEMPLATE_ID_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, CHANNEL_FIELD,
            CHANNEL_SUBTYPE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, CONTENT_FIELD,
            DESCRIPTION_FIELD, LANGUAGE_FIELD, SOURCE_CONFIGURATION_SUMMARY_FIELD, GROUPING_CONFIGURATION_FIELD,
            DEFAULT_ATTRIBUTES_FIELD, ATTRIBUTE_TYPES_FIELD, ATTACHMENTS_FIELD, IS_ACTIVE_FIELD, VERSION_NUMBER_FIELD,
            MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageTemplateArn;

    private final String messageTemplateId;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String name;

    private final String channel;

    private final String channelSubtype;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final String lastModifiedBy;

    private final MessageTemplateContentProvider content;

    private final String description;

    private final String language;

    private final MessageTemplateSourceConfigurationSummary sourceConfigurationSummary;

    private final GroupingConfiguration groupingConfiguration;

    private final MessageTemplateAttributes defaultAttributes;

    private final List<String> attributeTypes;

    private final List<MessageTemplateAttachment> attachments;

    private final Boolean isActive;

    private final Long versionNumber;

    private final String messageTemplateContentSha256;

    private final Map<String, String> tags;

    private ExtendedMessageTemplateData(BuilderImpl builder) {
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateId = builder.messageTemplateId;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.channel = builder.channel;
        this.channelSubtype = builder.channelSubtype;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.content = builder.content;
        this.description = builder.description;
        this.language = builder.language;
        this.sourceConfigurationSummary = builder.sourceConfigurationSummary;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.defaultAttributes = builder.defaultAttributes;
        this.attributeTypes = builder.attributeTypes;
        this.attachments = builder.attachments;
        this.isActive = builder.isActive;
        this.versionNumber = builder.versionNumber;
        this.messageTemplateContentSha256 = builder.messageTemplateContentSha256;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public final String messageTemplateArn() {
        return messageTemplateArn;
    }

    /**
     * <p>
     * The identifier of the message template.
     * </p>
     * 
     * @return The identifier of the message template.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The channel of the message template.
     * </p>
     * 
     * @return The channel of the message template.
     */
    public final String channel() {
        return channel;
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(channelSubtype);
    }

    /**
     * <p>
     * The channel subtype this message template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelSubtype}
     * will return {@link ChannelSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #channelSubtypeAsString}.
     * </p>
     * 
     * @return The channel subtype this message template applies to.
     * @see ChannelSubtype
     */
    public final String channelSubtypeAsString() {
        return channelSubtype;
    }

    /**
     * <p>
     * The timestamp when the message template was created.
     * </p>
     * 
     * @return The timestamp when the message template was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp when the message template data was last modified.
     * </p>
     * 
     * @return The timestamp when the message template data was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the message template data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the message template data.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The content of the message template.
     * </p>
     * 
     * @return The content of the message template.
     */
    public final MessageTemplateContentProvider content() {
        return content;
    }

    /**
     * <p>
     * The description of the message template.
     * </p>
     * 
     * @return The description of the message template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The language code value for the language in which the quick response is written. The supported language codes
     * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
     * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
     * <code>zh_TW</code>
     * </p>
     * 
     * @return The language code value for the language in which the quick response is written. The supported language
     *         codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
     *         <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
     *         <code>zh_CN</code>, <code>zh_TW</code>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The source configuration summary of the message template.
     * </p>
     * 
     * @return The source configuration summary of the message template.
     */
    public final MessageTemplateSourceConfigurationSummary sourceConfigurationSummary() {
        return sourceConfigurationSummary;
    }

    /**
     * Returns the value of the GroupingConfiguration property for this object.
     * 
     * @return The value of the GroupingConfiguration property for this object.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * An object that specifies the default values to use for variables in the message template. This object contains
     * different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The
     * corresponding value defines the default value for that variable.
     * </p>
     * 
     * @return An object that specifies the default values to use for variables in the message template. This object
     *         contains different categories of key-value pairs. Each key defines a variable or placeholder in the
     *         message template. The corresponding value defines the default value for that variable.
     */
    public final MessageTemplateAttributes defaultAttributes() {
        return defaultAttributes;
    }

    /**
     * <p>
     * The types of attributes contain the message template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeTypes} method.
     * </p>
     * 
     * @return The types of attributes contain the message template.
     */
    public final List<MessageTemplateAttributeType> attributeTypes() {
        return MessageTemplateAttributeTypeListCopier.copyStringToEnum(attributeTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeTypes() {
        return attributeTypes != null && !(attributeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of attributes contain the message template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeTypes} method.
     * </p>
     * 
     * @return The types of attributes contain the message template.
     */
    public final List<String> attributeTypesAsStrings() {
        return attributeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The message template attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return The message template attachments.
     */
    public final List<MessageTemplateAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * Whether the version of the message template is activated.
     * </p>
     * 
     * @return Whether the version of the message template is activated.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The version number of the message template version.
     * </p>
     * 
     * @return The version number of the message template version.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The checksum value of the message template content that is referenced by the <code>$LATEST</code> qualifier. It
     * can be returned in <code>MessageTemplateData</code> or <code>ExtendedMessageTemplateData</code>. It’s calculated
     * by content, language, <code>defaultAttributes</code> and <code>Attachments</code> of the message template.
     * </p>
     * 
     * @return The checksum value of the message template content that is referenced by the <code>$LATEST</code>
     *         qualifier. It can be returned in <code>MessageTemplateData</code> or
     *         <code>ExtendedMessageTemplateData</code>. It’s calculated by content, language,
     *         <code>defaultAttributes</code> and <code>Attachments</code> of the message template.
     */
    public final String messageTemplateContentSha256() {
        return messageTemplateContentSha256;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfigurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeTypes() ? attributeTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedMessageTemplateData)) {
            return false;
        }
        ExtendedMessageTemplateData other = (ExtendedMessageTemplateData) obj;
        return Objects.equals(messageTemplateArn(), other.messageTemplateArn())
                && Objects.equals(messageTemplateId(), other.messageTemplateId())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(name(), other.name())
                && Objects.equals(channel(), other.channel())
                && Objects.equals(channelSubtypeAsString(), other.channelSubtypeAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(content(), other.content())
                && Objects.equals(description(), other.description()) && Objects.equals(language(), other.language())
                && Objects.equals(sourceConfigurationSummary(), other.sourceConfigurationSummary())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(defaultAttributes(), other.defaultAttributes())
                && hasAttributeTypes() == other.hasAttributeTypes()
                && Objects.equals(attributeTypesAsStrings(), other.attributeTypesAsStrings())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && Objects.equals(isActive(), other.isActive()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(messageTemplateContentSha256(), other.messageTemplateContentSha256())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtendedMessageTemplateData").add("MessageTemplateArn", messageTemplateArn())
                .add("MessageTemplateId", messageTemplateId()).add("KnowledgeBaseArn", knowledgeBaseArn())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Name", name())
                .add("Channel", channel() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelSubtype", channelSubtypeAsString()).add("CreatedTime", createdTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedBy", lastModifiedBy()).add("Content", content())
                .add("Description", description()).add("Language", language())
                .add("SourceConfigurationSummary", sourceConfigurationSummary())
                .add("GroupingConfiguration", groupingConfiguration()).add("DefaultAttributes", defaultAttributes())
                .add("AttributeTypes", hasAttributeTypes() ? attributeTypesAsStrings() : null)
                .add("Attachments", hasAttachments() ? attachments() : null).add("IsActive", isActive())
                .add("VersionNumber", versionNumber()).add("MessageTemplateContentSha256", messageTemplateContentSha256())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageTemplateArn":
            return Optional.ofNullable(clazz.cast(messageTemplateArn()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "channelSubtype":
            return Optional.ofNullable(clazz.cast(channelSubtypeAsString()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "lastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "sourceConfigurationSummary":
            return Optional.ofNullable(clazz.cast(sourceConfigurationSummary()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "defaultAttributes":
            return Optional.ofNullable(clazz.cast(defaultAttributes()));
        case "attributeTypes":
            return Optional.ofNullable(clazz.cast(attributeTypesAsStrings()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "messageTemplateContentSha256":
            return Optional.ofNullable(clazz.cast(messageTemplateContentSha256()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("channel", CHANNEL_FIELD);
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("sourceConfigurationSummary", SOURCE_CONFIGURATION_SUMMARY_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        map.put("attributeTypes", ATTRIBUTE_TYPES_FIELD);
        map.put("attachments", ATTACHMENTS_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        map.put("messageTemplateContentSha256", MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtendedMessageTemplateData, T> g) {
        return obj -> g.apply((ExtendedMessageTemplateData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtendedMessageTemplateData> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param messageTemplateArn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateArn(String messageTemplateArn);

        /**
         * <p>
         * The identifier of the message template.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param name
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The channel of the message template.
         * </p>
         * 
         * @param channel
         *        The channel of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(String channelSubtype);

        /**
         * <p>
         * The channel subtype this message template applies to.
         * </p>
         * 
         * @param channelSubtype
         *        The channel subtype this message template applies to.
         * @see ChannelSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelSubtype
         */
        Builder channelSubtype(ChannelSubtype channelSubtype);

        /**
         * <p>
         * The timestamp when the message template was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the message template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp when the message template data was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the message template data was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the message template data.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last updated the message template data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * 
         * @param content
         *        The content of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(MessageTemplateContentProvider content);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateContentProvider.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #content(MessageTemplateContentProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link MessageTemplateContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(MessageTemplateContentProvider)
         */
        default Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return content(MessageTemplateContentProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The description of the message template.
         * </p>
         * 
         * @param description
         *        The description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The language code value for the language in which the quick response is written. The supported language codes
         * include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>,
         * <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>,
         * <code>zh_TW</code>
         * </p>
         * 
         * @param language
         *        The language code value for the language in which the quick response is written. The supported
         *        language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>,
         *        <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>,
         *        <code>zh_CN</code>, <code>zh_TW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The source configuration summary of the message template.
         * </p>
         * 
         * @param sourceConfigurationSummary
         *        The source configuration summary of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfigurationSummary(MessageTemplateSourceConfigurationSummary sourceConfigurationSummary);

        /**
         * <p>
         * The source configuration summary of the message template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateSourceConfigurationSummary.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateSourceConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateSourceConfigurationSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sourceConfigurationSummary(MessageTemplateSourceConfigurationSummary)}.
         * 
         * @param sourceConfigurationSummary
         *        a consumer that will call methods on {@link MessageTemplateSourceConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfigurationSummary(MessageTemplateSourceConfigurationSummary)
         */
        default Builder sourceConfigurationSummary(
                Consumer<MessageTemplateSourceConfigurationSummary.Builder> sourceConfigurationSummary) {
            return sourceConfigurationSummary(MessageTemplateSourceConfigurationSummary.builder()
                    .applyMutation(sourceConfigurationSummary).build());
        }

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * @param groupingConfiguration
         *        The new value for the GroupingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultAttributes
         *        An object that specifies the default values to use for variables in the message template. This object
         *        contains different categories of key-value pairs. Each key defines a variable or placeholder in the
         *        message template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAttributes(MessageTemplateAttributes defaultAttributes);

        /**
         * <p>
         * An object that specifies the default values to use for variables in the message template. This object
         * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateAttributes.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultAttributes(MessageTemplateAttributes)}.
         * 
         * @param defaultAttributes
         *        a consumer that will call methods on {@link MessageTemplateAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAttributes(MessageTemplateAttributes)
         */
        default Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return defaultAttributes(MessageTemplateAttributes.builder().applyMutation(defaultAttributes).build());
        }

        /**
         * <p>
         * The types of attributes contain the message template.
         * </p>
         * 
         * @param attributeTypes
         *        The types of attributes contain the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeTypesWithStrings(Collection<String> attributeTypes);

        /**
         * <p>
         * The types of attributes contain the message template.
         * </p>
         * 
         * @param attributeTypes
         *        The types of attributes contain the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeTypesWithStrings(String... attributeTypes);

        /**
         * <p>
         * The types of attributes contain the message template.
         * </p>
         * 
         * @param attributeTypes
         *        The types of attributes contain the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeTypes(Collection<MessageTemplateAttributeType> attributeTypes);

        /**
         * <p>
         * The types of attributes contain the message template.
         * </p>
         * 
         * @param attributeTypes
         *        The types of attributes contain the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeTypes(MessageTemplateAttributeType... attributeTypes);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * 
         * @param attachments
         *        The message template attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<MessageTemplateAttachment> attachments);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * 
         * @param attachments
         *        The message template attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(MessageTemplateAttachment... attachments);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<MessageTemplateAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<MessageTemplateAttachment>)
         */
        Builder attachments(Consumer<MessageTemplateAttachment.Builder>... attachments);

        /**
         * <p>
         * Whether the version of the message template is activated.
         * </p>
         * 
         * @param isActive
         *        Whether the version of the message template is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The version number of the message template version.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the message template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The checksum value of the message template content that is referenced by the <code>$LATEST</code> qualifier.
         * It can be returned in <code>MessageTemplateData</code> or <code>ExtendedMessageTemplateData</code>. It’s
         * calculated by content, language, <code>defaultAttributes</code> and <code>Attachments</code> of the message
         * template.
         * </p>
         * 
         * @param messageTemplateContentSha256
         *        The checksum value of the message template content that is referenced by the <code>$LATEST</code>
         *        qualifier. It can be returned in <code>MessageTemplateData</code> or
         *        <code>ExtendedMessageTemplateData</code>. It’s calculated by content, language,
         *        <code>defaultAttributes</code> and <code>Attachments</code> of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateContentSha256(String messageTemplateContentSha256);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String messageTemplateArn;

        private String messageTemplateId;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String name;

        private String channel;

        private String channelSubtype;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private String lastModifiedBy;

        private MessageTemplateContentProvider content;

        private String description;

        private String language;

        private MessageTemplateSourceConfigurationSummary sourceConfigurationSummary;

        private GroupingConfiguration groupingConfiguration;

        private MessageTemplateAttributes defaultAttributes;

        private List<String> attributeTypes = DefaultSdkAutoConstructList.getInstance();

        private List<MessageTemplateAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private Boolean isActive;

        private Long versionNumber;

        private String messageTemplateContentSha256;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedMessageTemplateData model) {
            messageTemplateArn(model.messageTemplateArn);
            messageTemplateId(model.messageTemplateId);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            name(model.name);
            channel(model.channel);
            channelSubtype(model.channelSubtype);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            content(model.content);
            description(model.description);
            language(model.language);
            sourceConfigurationSummary(model.sourceConfigurationSummary);
            groupingConfiguration(model.groupingConfiguration);
            defaultAttributes(model.defaultAttributes);
            attributeTypesWithStrings(model.attributeTypes);
            attachments(model.attachments);
            isActive(model.isActive);
            versionNumber(model.versionNumber);
            messageTemplateContentSha256(model.messageTemplateContentSha256);
            tags(model.tags);
        }

        public final String getMessageTemplateArn() {
            return messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final String getChannelSubtype() {
            return channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final MessageTemplateSourceConfigurationSummary.Builder getSourceConfigurationSummary() {
            return sourceConfigurationSummary != null ? sourceConfigurationSummary.toBuilder() : null;
        }

        public final void setSourceConfigurationSummary(
                MessageTemplateSourceConfigurationSummary.BuilderImpl sourceConfigurationSummary) {
            this.sourceConfigurationSummary = sourceConfigurationSummary != null ? sourceConfigurationSummary.build() : null;
        }

        @Override
        public final Builder sourceConfigurationSummary(MessageTemplateSourceConfigurationSummary sourceConfigurationSummary) {
            this.sourceConfigurationSummary = sourceConfigurationSummary;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return defaultAttributes != null ? defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        public final Collection<String> getAttributeTypes() {
            if (attributeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeTypes;
        }

        public final void setAttributeTypes(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
        }

        @Override
        public final Builder attributeTypesWithStrings(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypesWithStrings(String... attributeTypes) {
            attributeTypesWithStrings(Arrays.asList(attributeTypes));
            return this;
        }

        @Override
        public final Builder attributeTypes(Collection<MessageTemplateAttributeType> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copyEnumToString(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypes(MessageTemplateAttributeType... attributeTypes) {
            attributeTypes(Arrays.asList(attributeTypes));
            return this;
        }

        public final List<MessageTemplateAttachment.Builder> getAttachments() {
            List<MessageTemplateAttachment.Builder> result = MessageTemplateAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<MessageTemplateAttachment.BuilderImpl> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<MessageTemplateAttachment> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(MessageTemplateAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<MessageTemplateAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> MessageTemplateAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getMessageTemplateContentSha256() {
            return messageTemplateContentSha256;
        }

        public final void setMessageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
        }

        @Override
        public final Builder messageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public ExtendedMessageTemplateData build() {
            return new ExtendedMessageTemplateData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
