/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the EMAIL_RESPONSE AI agent including prompts, locale, and knowledge base associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailResponseAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailResponseAIAgentConfiguration.Builder, EmailResponseAIAgentConfiguration> {
    private static final SdkField<String> EMAIL_RESPONSE_AI_PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailResponseAIPromptId").getter(getter(EmailResponseAIAgentConfiguration::emailResponseAIPromptId))
            .setter(setter(Builder::emailResponseAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailResponseAIPromptId").build())
            .build();

    private static final SdkField<String> EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("emailQueryReformulationAIPromptId")
            .getter(getter(EmailResponseAIAgentConfiguration::emailQueryReformulationAIPromptId))
            .setter(setter(Builder::emailQueryReformulationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailQueryReformulationAIPromptId")
                    .build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(EmailResponseAIAgentConfiguration::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField
            .<List<AssociationConfiguration>> builder(MarshallingType.LIST)
            .memberName("associationConfigurations")
            .getter(getter(EmailResponseAIAgentConfiguration::associationConfigurations))
            .setter(setter(Builder::associationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EMAIL_RESPONSE_AI_PROMPT_ID_FIELD, EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD, LOCALE_FIELD,
            ASSOCIATION_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emailResponseAIPromptId;

    private final String emailQueryReformulationAIPromptId;

    private final String locale;

    private final List<AssociationConfiguration> associationConfigurations;

    private EmailResponseAIAgentConfiguration(BuilderImpl builder) {
        this.emailResponseAIPromptId = builder.emailResponseAIPromptId;
        this.emailQueryReformulationAIPromptId = builder.emailQueryReformulationAIPromptId;
        this.locale = builder.locale;
        this.associationConfigurations = builder.associationConfigurations;
    }

    /**
     * <p>
     * The ID of the System AI prompt used for generating professional email responses based on knowledge base content.
     * </p>
     * 
     * @return The ID of the System AI prompt used for generating professional email responses based on knowledge base
     *         content.
     */
    public final String emailResponseAIPromptId() {
        return emailResponseAIPromptId;
    }

    /**
     * <p>
     * The ID of the System AI prompt used for reformulating email queries to optimize knowledge base search for
     * response generation.
     * </p>
     * 
     * @return The ID of the System AI prompt used for reformulating email queries to optimize knowledge base search for
     *         response generation.
     */
    public final String emailQueryReformulationAIPromptId() {
        return emailQueryReformulationAIPromptId;
    }

    /**
     * <p>
     * The locale setting for language-specific email response generation (for example, en_US, es_ES).
     * </p>
     * 
     * @return The locale setting for language-specific email response generation (for example, en_US, es_ES).
     */
    public final String locale() {
        return locale;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociationConfigurations() {
        return associationConfigurations != null && !(associationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for knowledge base associations used by the email response agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationConfigurations} method.
     * </p>
     * 
     * @return Configuration settings for knowledge base associations used by the email response agent.
     */
    public final List<AssociationConfiguration> associationConfigurations() {
        return associationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailResponseAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(emailQueryReformulationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationConfigurations() ? associationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailResponseAIAgentConfiguration)) {
            return false;
        }
        EmailResponseAIAgentConfiguration other = (EmailResponseAIAgentConfiguration) obj;
        return Objects.equals(emailResponseAIPromptId(), other.emailResponseAIPromptId())
                && Objects.equals(emailQueryReformulationAIPromptId(), other.emailQueryReformulationAIPromptId())
                && Objects.equals(locale(), other.locale())
                && hasAssociationConfigurations() == other.hasAssociationConfigurations()
                && Objects.equals(associationConfigurations(), other.associationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailResponseAIAgentConfiguration").add("EmailResponseAIPromptId", emailResponseAIPromptId())
                .add("EmailQueryReformulationAIPromptId", emailQueryReformulationAIPromptId()).add("Locale", locale())
                .add("AssociationConfigurations", hasAssociationConfigurations() ? associationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "emailResponseAIPromptId":
            return Optional.ofNullable(clazz.cast(emailResponseAIPromptId()));
        case "emailQueryReformulationAIPromptId":
            return Optional.ofNullable(clazz.cast(emailQueryReformulationAIPromptId()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "associationConfigurations":
            return Optional.ofNullable(clazz.cast(associationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("emailResponseAIPromptId", EMAIL_RESPONSE_AI_PROMPT_ID_FIELD);
        map.put("emailQueryReformulationAIPromptId", EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("associationConfigurations", ASSOCIATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailResponseAIAgentConfiguration, T> g) {
        return obj -> g.apply((EmailResponseAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailResponseAIAgentConfiguration> {
        /**
         * <p>
         * The ID of the System AI prompt used for generating professional email responses based on knowledge base
         * content.
         * </p>
         * 
         * @param emailResponseAIPromptId
         *        The ID of the System AI prompt used for generating professional email responses based on knowledge
         *        base content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailResponseAIPromptId(String emailResponseAIPromptId);

        /**
         * <p>
         * The ID of the System AI prompt used for reformulating email queries to optimize knowledge base search for
         * response generation.
         * </p>
         * 
         * @param emailQueryReformulationAIPromptId
         *        The ID of the System AI prompt used for reformulating email queries to optimize knowledge base search
         *        for response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId);

        /**
         * <p>
         * The locale setting for language-specific email response generation (for example, en_US, es_ES).
         * </p>
         * 
         * @param locale
         *        The locale setting for language-specific email response generation (for example, en_US, es_ES).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Configuration settings for knowledge base associations used by the email response agent.
         * </p>
         * 
         * @param associationConfigurations
         *        Configuration settings for knowledge base associations used by the email response agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations);

        /**
         * <p>
         * Configuration settings for knowledge base associations used by the email response agent.
         * </p>
         * 
         * @param associationConfigurations
         *        Configuration settings for knowledge base associations used by the email response agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(AssociationConfiguration... associationConfigurations);

        /**
         * <p>
         * Configuration settings for knowledge base associations used by the email response agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #associationConfigurations(List<AssociationConfiguration>)}.
         * 
         * @param associationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationConfigurations(java.util.Collection<AssociationConfiguration>)
         */
        Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String emailResponseAIPromptId;

        private String emailQueryReformulationAIPromptId;

        private String locale;

        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailResponseAIAgentConfiguration model) {
            emailResponseAIPromptId(model.emailResponseAIPromptId);
            emailQueryReformulationAIPromptId(model.emailQueryReformulationAIPromptId);
            locale(model.locale);
            associationConfigurations(model.associationConfigurations);
        }

        public final String getEmailResponseAIPromptId() {
            return emailResponseAIPromptId;
        }

        public final void setEmailResponseAIPromptId(String emailResponseAIPromptId) {
            this.emailResponseAIPromptId = emailResponseAIPromptId;
        }

        @Override
        public final Builder emailResponseAIPromptId(String emailResponseAIPromptId) {
            this.emailResponseAIPromptId = emailResponseAIPromptId;
            return this;
        }

        public final String getEmailQueryReformulationAIPromptId() {
            return emailQueryReformulationAIPromptId;
        }

        public final void setEmailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
        }

        @Override
        public final Builder emailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier
                    .copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration... associationConfigurations) {
            associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations) {
            associationConfigurations(Stream.of(associationConfigurations)
                    .map(c -> AssociationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EmailResponseAIAgentConfiguration build() {
            return new EmailResponseAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
