/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataDetails implements SdkPojo, Serializable, ToCopyableBuilder<DataDetails.Builder, DataDetails> {
    private static final SdkField<ContentDataDetails> CONTENT_DATA_FIELD = SdkField
            .<ContentDataDetails> builder(MarshallingType.SDK_POJO).memberName("contentData")
            .getter(getter(DataDetails::contentData)).setter(setter(Builder::contentData))
            .constructor(ContentDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentData").build()).build();

    private static final SdkField<GenerativeDataDetails> GENERATIVE_DATA_FIELD = SdkField
            .<GenerativeDataDetails> builder(MarshallingType.SDK_POJO).memberName("generativeData")
            .getter(getter(DataDetails::generativeData)).setter(setter(Builder::generativeData))
            .constructor(GenerativeDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeData").build()).build();

    private static final SdkField<IntentDetectedDataDetails> INTENT_DETECTED_DATA_FIELD = SdkField
            .<IntentDetectedDataDetails> builder(MarshallingType.SDK_POJO).memberName("intentDetectedData")
            .getter(getter(DataDetails::intentDetectedData)).setter(setter(Builder::intentDetectedData))
            .constructor(IntentDetectedDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentDetectedData").build())
            .build();

    private static final SdkField<SourceContentDataDetails> SOURCE_CONTENT_DATA_FIELD = SdkField
            .<SourceContentDataDetails> builder(MarshallingType.SDK_POJO).memberName("sourceContentData")
            .getter(getter(DataDetails::sourceContentData)).setter(setter(Builder::sourceContentData))
            .constructor(SourceContentDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContentData").build()).build();

    private static final SdkField<GenerativeChunkDataDetails> GENERATIVE_CHUNK_DATA_FIELD = SdkField
            .<GenerativeChunkDataDetails> builder(MarshallingType.SDK_POJO).memberName("generativeChunkData")
            .getter(getter(DataDetails::generativeChunkData)).setter(setter(Builder::generativeChunkData))
            .constructor(GenerativeChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeChunkData").build())
            .build();

    private static final SdkField<EmailResponseChunkDataDetails> EMAIL_RESPONSE_CHUNK_DATA_FIELD = SdkField
            .<EmailResponseChunkDataDetails> builder(MarshallingType.SDK_POJO).memberName("emailResponseChunkData")
            .getter(getter(DataDetails::emailResponseChunkData)).setter(setter(Builder::emailResponseChunkData))
            .constructor(EmailResponseChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailResponseChunkData").build())
            .build();

    private static final SdkField<EmailOverviewChunkDataDetails> EMAIL_OVERVIEW_CHUNK_DATA_FIELD = SdkField
            .<EmailOverviewChunkDataDetails> builder(MarshallingType.SDK_POJO).memberName("emailOverviewChunkData")
            .getter(getter(DataDetails::emailOverviewChunkData)).setter(setter(Builder::emailOverviewChunkData))
            .constructor(EmailOverviewChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailOverviewChunkData").build())
            .build();

    private static final SdkField<EmailGenerativeAnswerChunkDataDetails> EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD = SdkField
            .<EmailGenerativeAnswerChunkDataDetails> builder(MarshallingType.SDK_POJO)
            .memberName("emailGenerativeAnswerChunkData")
            .getter(getter(DataDetails::emailGenerativeAnswerChunkData))
            .setter(setter(Builder::emailGenerativeAnswerChunkData))
            .constructor(EmailGenerativeAnswerChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailGenerativeAnswerChunkData")
                    .build()).build();

    private static final SdkField<CaseSummarizationChunkDataDetails> CASE_SUMMARIZATION_CHUNK_DATA_FIELD = SdkField
            .<CaseSummarizationChunkDataDetails> builder(MarshallingType.SDK_POJO)
            .memberName("caseSummarizationChunkData")
            .getter(getter(DataDetails::caseSummarizationChunkData))
            .setter(setter(Builder::caseSummarizationChunkData))
            .constructor(CaseSummarizationChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSummarizationChunkData").build())
            .build();

    private static final SdkField<SuggestedMessageDataDetails> SUGGESTED_MESSAGE_DATA_FIELD = SdkField
            .<SuggestedMessageDataDetails> builder(MarshallingType.SDK_POJO).memberName("suggestedMessageData")
            .getter(getter(DataDetails::suggestedMessageData)).setter(setter(Builder::suggestedMessageData))
            .constructor(SuggestedMessageDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedMessageData").build())
            .build();

    private static final SdkField<NotesDataDetails> NOTES_DATA_FIELD = SdkField
            .<NotesDataDetails> builder(MarshallingType.SDK_POJO).memberName("notesData").getter(getter(DataDetails::notesData))
            .setter(setter(Builder::notesData)).constructor(NotesDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notesData").build()).build();

    private static final SdkField<NotesChunkDataDetails> NOTES_CHUNK_DATA_FIELD = SdkField
            .<NotesChunkDataDetails> builder(MarshallingType.SDK_POJO).memberName("notesChunkData")
            .getter(getter(DataDetails::notesChunkData)).setter(setter(Builder::notesChunkData))
            .constructor(NotesChunkDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notesChunkData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_DATA_FIELD,
            GENERATIVE_DATA_FIELD, INTENT_DETECTED_DATA_FIELD, SOURCE_CONTENT_DATA_FIELD, GENERATIVE_CHUNK_DATA_FIELD,
            EMAIL_RESPONSE_CHUNK_DATA_FIELD, EMAIL_OVERVIEW_CHUNK_DATA_FIELD, EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD,
            CASE_SUMMARIZATION_CHUNK_DATA_FIELD, SUGGESTED_MESSAGE_DATA_FIELD, NOTES_DATA_FIELD, NOTES_CHUNK_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContentDataDetails contentData;

    private final GenerativeDataDetails generativeData;

    private final IntentDetectedDataDetails intentDetectedData;

    private final SourceContentDataDetails sourceContentData;

    private final GenerativeChunkDataDetails generativeChunkData;

    private final EmailResponseChunkDataDetails emailResponseChunkData;

    private final EmailOverviewChunkDataDetails emailOverviewChunkData;

    private final EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData;

    private final CaseSummarizationChunkDataDetails caseSummarizationChunkData;

    private final SuggestedMessageDataDetails suggestedMessageData;

    private final NotesDataDetails notesData;

    private final NotesChunkDataDetails notesChunkData;

    private final Type type;

    private DataDetails(BuilderImpl builder) {
        this.contentData = builder.contentData;
        this.generativeData = builder.generativeData;
        this.intentDetectedData = builder.intentDetectedData;
        this.sourceContentData = builder.sourceContentData;
        this.generativeChunkData = builder.generativeChunkData;
        this.emailResponseChunkData = builder.emailResponseChunkData;
        this.emailOverviewChunkData = builder.emailOverviewChunkData;
        this.emailGenerativeAnswerChunkData = builder.emailGenerativeAnswerChunkData;
        this.caseSummarizationChunkData = builder.caseSummarizationChunkData;
        this.suggestedMessageData = builder.suggestedMessageData;
        this.notesData = builder.notesData;
        this.notesChunkData = builder.notesChunkData;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @return Details about the content data.
     */
    public final ContentDataDetails contentData() {
        return contentData;
    }

    /**
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @return Details about the generative data.
     */
    public final GenerativeDataDetails generativeData() {
        return generativeData;
    }

    /**
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @return Details about the intent data.
     */
    public final IntentDetectedDataDetails intentDetectedData() {
        return intentDetectedData;
    }

    /**
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @return Details about the content data.
     */
    public final SourceContentDataDetails sourceContentData() {
        return sourceContentData;
    }

    /**
     * <p>
     * Details about the generative chunk data.
     * </p>
     * 
     * @return Details about the generative chunk data.
     */
    public final GenerativeChunkDataDetails generativeChunkData() {
        return generativeChunkData;
    }

    /**
     * <p>
     * Streaming chunk data for email response generation containing partial response content.
     * </p>
     * 
     * @return Streaming chunk data for email response generation containing partial response content.
     */
    public final EmailResponseChunkDataDetails emailResponseChunkData() {
        return emailResponseChunkData;
    }

    /**
     * <p>
     * Streaming chunk data for email overview containing partial overview content.
     * </p>
     * 
     * @return Streaming chunk data for email overview containing partial overview content.
     */
    public final EmailOverviewChunkDataDetails emailOverviewChunkData() {
        return emailOverviewChunkData;
    }

    /**
     * <p>
     * Streaming chunk data for email generative answers containing partial knowledge-based response content.
     * </p>
     * 
     * @return Streaming chunk data for email generative answers containing partial knowledge-based response content.
     */
    public final EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData() {
        return emailGenerativeAnswerChunkData;
    }

    /**
     * <p>
     * Details about case summarization chunk data.
     * </p>
     * 
     * @return Details about case summarization chunk data.
     */
    public final CaseSummarizationChunkDataDetails caseSummarizationChunkData() {
        return caseSummarizationChunkData;
    }

    /**
     * <p>
     * Details about suggested message data.
     * </p>
     * 
     * @return Details about suggested message data.
     */
    public final SuggestedMessageDataDetails suggestedMessageData() {
        return suggestedMessageData;
    }

    /**
     * <p>
     * Details about notes data.
     * </p>
     * 
     * @return Details about notes data.
     */
    public final NotesDataDetails notesData() {
        return notesData;
    }

    /**
     * <p>
     * Details about notes chunk data.
     * </p>
     * 
     * @return Details about notes chunk data.
     */
    public final NotesChunkDataDetails notesChunkData() {
        return notesChunkData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentData());
        hashCode = 31 * hashCode + Objects.hashCode(generativeData());
        hashCode = 31 * hashCode + Objects.hashCode(intentDetectedData());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContentData());
        hashCode = 31 * hashCode + Objects.hashCode(generativeChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(emailResponseChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(emailOverviewChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(emailGenerativeAnswerChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(caseSummarizationChunkData());
        hashCode = 31 * hashCode + Objects.hashCode(suggestedMessageData());
        hashCode = 31 * hashCode + Objects.hashCode(notesData());
        hashCode = 31 * hashCode + Objects.hashCode(notesChunkData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDetails)) {
            return false;
        }
        DataDetails other = (DataDetails) obj;
        return Objects.equals(contentData(), other.contentData()) && Objects.equals(generativeData(), other.generativeData())
                && Objects.equals(intentDetectedData(), other.intentDetectedData())
                && Objects.equals(sourceContentData(), other.sourceContentData())
                && Objects.equals(generativeChunkData(), other.generativeChunkData())
                && Objects.equals(emailResponseChunkData(), other.emailResponseChunkData())
                && Objects.equals(emailOverviewChunkData(), other.emailOverviewChunkData())
                && Objects.equals(emailGenerativeAnswerChunkData(), other.emailGenerativeAnswerChunkData())
                && Objects.equals(caseSummarizationChunkData(), other.caseSummarizationChunkData())
                && Objects.equals(suggestedMessageData(), other.suggestedMessageData())
                && Objects.equals(notesData(), other.notesData()) && Objects.equals(notesChunkData(), other.notesChunkData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataDetails").add("ContentData", contentData()).add("GenerativeData", generativeData())
                .add("IntentDetectedData", intentDetectedData()).add("SourceContentData", sourceContentData())
                .add("GenerativeChunkData", generativeChunkData()).add("EmailResponseChunkData", emailResponseChunkData())
                .add("EmailOverviewChunkData", emailOverviewChunkData())
                .add("EmailGenerativeAnswerChunkData", emailGenerativeAnswerChunkData())
                .add("CaseSummarizationChunkData", caseSummarizationChunkData())
                .add("SuggestedMessageData", suggestedMessageData()).add("NotesData", notesData())
                .add("NotesChunkData", notesChunkData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentData":
            return Optional.ofNullable(clazz.cast(contentData()));
        case "generativeData":
            return Optional.ofNullable(clazz.cast(generativeData()));
        case "intentDetectedData":
            return Optional.ofNullable(clazz.cast(intentDetectedData()));
        case "sourceContentData":
            return Optional.ofNullable(clazz.cast(sourceContentData()));
        case "generativeChunkData":
            return Optional.ofNullable(clazz.cast(generativeChunkData()));
        case "emailResponseChunkData":
            return Optional.ofNullable(clazz.cast(emailResponseChunkData()));
        case "emailOverviewChunkData":
            return Optional.ofNullable(clazz.cast(emailOverviewChunkData()));
        case "emailGenerativeAnswerChunkData":
            return Optional.ofNullable(clazz.cast(emailGenerativeAnswerChunkData()));
        case "caseSummarizationChunkData":
            return Optional.ofNullable(clazz.cast(caseSummarizationChunkData()));
        case "suggestedMessageData":
            return Optional.ofNullable(clazz.cast(suggestedMessageData()));
        case "notesData":
            return Optional.ofNullable(clazz.cast(notesData()));
        case "notesChunkData":
            return Optional.ofNullable(clazz.cast(notesChunkData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param contentData
     *        Details about the content data.
     */
    public static DataDetails fromContentData(ContentDataDetails contentData) {
        return builder().contentData(contentData).build();
    }

    /**
     * Create an instance of this class with {@link #contentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param contentData
     *        Details about the content data.
     */
    public static DataDetails fromContentData(Consumer<ContentDataDetails.Builder> contentData) {
        ContentDataDetails.Builder builder = ContentDataDetails.builder();
        contentData.accept(builder);
        return fromContentData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #generativeData()} initialized to the given value.
     *
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @param generativeData
     *        Details about the generative data.
     */
    public static DataDetails fromGenerativeData(GenerativeDataDetails generativeData) {
        return builder().generativeData(generativeData).build();
    }

    /**
     * Create an instance of this class with {@link #generativeData()} initialized to the given value.
     *
     * <p>
     * Details about the generative data.
     * </p>
     * 
     * @param generativeData
     *        Details about the generative data.
     */
    public static DataDetails fromGenerativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
        GenerativeDataDetails.Builder builder = GenerativeDataDetails.builder();
        generativeData.accept(builder);
        return fromGenerativeData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #intentDetectedData()} initialized to the given value.
     *
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @param intentDetectedData
     *        Details about the intent data.
     */
    public static DataDetails fromIntentDetectedData(IntentDetectedDataDetails intentDetectedData) {
        return builder().intentDetectedData(intentDetectedData).build();
    }

    /**
     * Create an instance of this class with {@link #intentDetectedData()} initialized to the given value.
     *
     * <p>
     * Details about the intent data.
     * </p>
     * 
     * @param intentDetectedData
     *        Details about the intent data.
     */
    public static DataDetails fromIntentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
        IntentDetectedDataDetails.Builder builder = IntentDetectedDataDetails.builder();
        intentDetectedData.accept(builder);
        return fromIntentDetectedData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sourceContentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param sourceContentData
     *        Details about the content data.
     */
    public static DataDetails fromSourceContentData(SourceContentDataDetails sourceContentData) {
        return builder().sourceContentData(sourceContentData).build();
    }

    /**
     * Create an instance of this class with {@link #sourceContentData()} initialized to the given value.
     *
     * <p>
     * Details about the content data.
     * </p>
     * 
     * @param sourceContentData
     *        Details about the content data.
     */
    public static DataDetails fromSourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
        SourceContentDataDetails.Builder builder = SourceContentDataDetails.builder();
        sourceContentData.accept(builder);
        return fromSourceContentData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #generativeChunkData()} initialized to the given value.
     *
     * <p>
     * Details about the generative chunk data.
     * </p>
     * 
     * @param generativeChunkData
     *        Details about the generative chunk data.
     */
    public static DataDetails fromGenerativeChunkData(GenerativeChunkDataDetails generativeChunkData) {
        return builder().generativeChunkData(generativeChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #generativeChunkData()} initialized to the given value.
     *
     * <p>
     * Details about the generative chunk data.
     * </p>
     * 
     * @param generativeChunkData
     *        Details about the generative chunk data.
     */
    public static DataDetails fromGenerativeChunkData(Consumer<GenerativeChunkDataDetails.Builder> generativeChunkData) {
        GenerativeChunkDataDetails.Builder builder = GenerativeChunkDataDetails.builder();
        generativeChunkData.accept(builder);
        return fromGenerativeChunkData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailResponseChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email response generation containing partial response content.
     * </p>
     * 
     * @param emailResponseChunkData
     *        Streaming chunk data for email response generation containing partial response content.
     */
    public static DataDetails fromEmailResponseChunkData(EmailResponseChunkDataDetails emailResponseChunkData) {
        return builder().emailResponseChunkData(emailResponseChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #emailResponseChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email response generation containing partial response content.
     * </p>
     * 
     * @param emailResponseChunkData
     *        Streaming chunk data for email response generation containing partial response content.
     */
    public static DataDetails fromEmailResponseChunkData(Consumer<EmailResponseChunkDataDetails.Builder> emailResponseChunkData) {
        EmailResponseChunkDataDetails.Builder builder = EmailResponseChunkDataDetails.builder();
        emailResponseChunkData.accept(builder);
        return fromEmailResponseChunkData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailOverviewChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email overview containing partial overview content.
     * </p>
     * 
     * @param emailOverviewChunkData
     *        Streaming chunk data for email overview containing partial overview content.
     */
    public static DataDetails fromEmailOverviewChunkData(EmailOverviewChunkDataDetails emailOverviewChunkData) {
        return builder().emailOverviewChunkData(emailOverviewChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #emailOverviewChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email overview containing partial overview content.
     * </p>
     * 
     * @param emailOverviewChunkData
     *        Streaming chunk data for email overview containing partial overview content.
     */
    public static DataDetails fromEmailOverviewChunkData(Consumer<EmailOverviewChunkDataDetails.Builder> emailOverviewChunkData) {
        EmailOverviewChunkDataDetails.Builder builder = EmailOverviewChunkDataDetails.builder();
        emailOverviewChunkData.accept(builder);
        return fromEmailOverviewChunkData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailGenerativeAnswerChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email generative answers containing partial knowledge-based response content.
     * </p>
     * 
     * @param emailGenerativeAnswerChunkData
     *        Streaming chunk data for email generative answers containing partial knowledge-based response content.
     */
    public static DataDetails fromEmailGenerativeAnswerChunkData(
            EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData) {
        return builder().emailGenerativeAnswerChunkData(emailGenerativeAnswerChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #emailGenerativeAnswerChunkData()} initialized to the given value.
     *
     * <p>
     * Streaming chunk data for email generative answers containing partial knowledge-based response content.
     * </p>
     * 
     * @param emailGenerativeAnswerChunkData
     *        Streaming chunk data for email generative answers containing partial knowledge-based response content.
     */
    public static DataDetails fromEmailGenerativeAnswerChunkData(
            Consumer<EmailGenerativeAnswerChunkDataDetails.Builder> emailGenerativeAnswerChunkData) {
        EmailGenerativeAnswerChunkDataDetails.Builder builder = EmailGenerativeAnswerChunkDataDetails.builder();
        emailGenerativeAnswerChunkData.accept(builder);
        return fromEmailGenerativeAnswerChunkData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #caseSummarizationChunkData()} initialized to the given value.
     *
     * <p>
     * Details about case summarization chunk data.
     * </p>
     * 
     * @param caseSummarizationChunkData
     *        Details about case summarization chunk data.
     */
    public static DataDetails fromCaseSummarizationChunkData(CaseSummarizationChunkDataDetails caseSummarizationChunkData) {
        return builder().caseSummarizationChunkData(caseSummarizationChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #caseSummarizationChunkData()} initialized to the given value.
     *
     * <p>
     * Details about case summarization chunk data.
     * </p>
     * 
     * @param caseSummarizationChunkData
     *        Details about case summarization chunk data.
     */
    public static DataDetails fromCaseSummarizationChunkData(
            Consumer<CaseSummarizationChunkDataDetails.Builder> caseSummarizationChunkData) {
        CaseSummarizationChunkDataDetails.Builder builder = CaseSummarizationChunkDataDetails.builder();
        caseSummarizationChunkData.accept(builder);
        return fromCaseSummarizationChunkData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #suggestedMessageData()} initialized to the given value.
     *
     * <p>
     * Details about suggested message data.
     * </p>
     * 
     * @param suggestedMessageData
     *        Details about suggested message data.
     */
    public static DataDetails fromSuggestedMessageData(SuggestedMessageDataDetails suggestedMessageData) {
        return builder().suggestedMessageData(suggestedMessageData).build();
    }

    /**
     * Create an instance of this class with {@link #suggestedMessageData()} initialized to the given value.
     *
     * <p>
     * Details about suggested message data.
     * </p>
     * 
     * @param suggestedMessageData
     *        Details about suggested message data.
     */
    public static DataDetails fromSuggestedMessageData(Consumer<SuggestedMessageDataDetails.Builder> suggestedMessageData) {
        SuggestedMessageDataDetails.Builder builder = SuggestedMessageDataDetails.builder();
        suggestedMessageData.accept(builder);
        return fromSuggestedMessageData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notesData()} initialized to the given value.
     *
     * <p>
     * Details about notes data.
     * </p>
     * 
     * @param notesData
     *        Details about notes data.
     */
    public static DataDetails fromNotesData(NotesDataDetails notesData) {
        return builder().notesData(notesData).build();
    }

    /**
     * Create an instance of this class with {@link #notesData()} initialized to the given value.
     *
     * <p>
     * Details about notes data.
     * </p>
     * 
     * @param notesData
     *        Details about notes data.
     */
    public static DataDetails fromNotesData(Consumer<NotesDataDetails.Builder> notesData) {
        NotesDataDetails.Builder builder = NotesDataDetails.builder();
        notesData.accept(builder);
        return fromNotesData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notesChunkData()} initialized to the given value.
     *
     * <p>
     * Details about notes chunk data.
     * </p>
     * 
     * @param notesChunkData
     *        Details about notes chunk data.
     */
    public static DataDetails fromNotesChunkData(NotesChunkDataDetails notesChunkData) {
        return builder().notesChunkData(notesChunkData).build();
    }

    /**
     * Create an instance of this class with {@link #notesChunkData()} initialized to the given value.
     *
     * <p>
     * Details about notes chunk data.
     * </p>
     * 
     * @param notesChunkData
     *        Details about notes chunk data.
     */
    public static DataDetails fromNotesChunkData(Consumer<NotesChunkDataDetails.Builder> notesChunkData) {
        NotesChunkDataDetails.Builder builder = NotesChunkDataDetails.builder();
        notesChunkData.accept(builder);
        return fromNotesChunkData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentData", CONTENT_DATA_FIELD);
        map.put("generativeData", GENERATIVE_DATA_FIELD);
        map.put("intentDetectedData", INTENT_DETECTED_DATA_FIELD);
        map.put("sourceContentData", SOURCE_CONTENT_DATA_FIELD);
        map.put("generativeChunkData", GENERATIVE_CHUNK_DATA_FIELD);
        map.put("emailResponseChunkData", EMAIL_RESPONSE_CHUNK_DATA_FIELD);
        map.put("emailOverviewChunkData", EMAIL_OVERVIEW_CHUNK_DATA_FIELD);
        map.put("emailGenerativeAnswerChunkData", EMAIL_GENERATIVE_ANSWER_CHUNK_DATA_FIELD);
        map.put("caseSummarizationChunkData", CASE_SUMMARIZATION_CHUNK_DATA_FIELD);
        map.put("suggestedMessageData", SUGGESTED_MESSAGE_DATA_FIELD);
        map.put("notesData", NOTES_DATA_FIELD);
        map.put("notesChunkData", NOTES_CHUNK_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataDetails, T> g) {
        return obj -> g.apply((DataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataDetails> {
        /**
         * <p>
         * Details about the content data.
         * </p>
         * 
         * @param contentData
         *        Details about the content data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentData(ContentDataDetails contentData);

        /**
         * <p>
         * Details about the content data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentDataDetails.Builder} avoiding the
         * need to create one manually via {@link ContentDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentDataDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #contentData(ContentDataDetails)}.
         * 
         * @param contentData
         *        a consumer that will call methods on {@link ContentDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentData(ContentDataDetails)
         */
        default Builder contentData(Consumer<ContentDataDetails.Builder> contentData) {
            return contentData(ContentDataDetails.builder().applyMutation(contentData).build());
        }

        /**
         * <p>
         * Details about the generative data.
         * </p>
         * 
         * @param generativeData
         *        Details about the generative data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeData(GenerativeDataDetails generativeData);

        /**
         * <p>
         * Details about the generative data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeDataDetails.Builder} avoiding
         * the need to create one manually via {@link GenerativeDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeDataDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeData(GenerativeDataDetails)}.
         * 
         * @param generativeData
         *        a consumer that will call methods on {@link GenerativeDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeData(GenerativeDataDetails)
         */
        default Builder generativeData(Consumer<GenerativeDataDetails.Builder> generativeData) {
            return generativeData(GenerativeDataDetails.builder().applyMutation(generativeData).build());
        }

        /**
         * <p>
         * Details about the intent data.
         * </p>
         * 
         * @param intentDetectedData
         *        Details about the intent data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentDetectedData(IntentDetectedDataDetails intentDetectedData);

        /**
         * <p>
         * Details about the intent data.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentDetectedDataDetails.Builder}
         * avoiding the need to create one manually via {@link IntentDetectedDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentDetectedDataDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #intentDetectedData(IntentDetectedDataDetails)}.
         * 
         * @param intentDetectedData
         *        a consumer that will call methods on {@link IntentDetectedDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentDetectedData(IntentDetectedDataDetails)
         */
        default Builder intentDetectedData(Consumer<IntentDetectedDataDetails.Builder> intentDetectedData) {
            return intentDetectedData(IntentDetectedDataDetails.builder().applyMutation(intentDetectedData).build());
        }

        /**
         * <p>
         * Details about the content data.
         * </p>
         * 
         * @param sourceContentData
         *        Details about the content data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContentData(SourceContentDataDetails sourceContentData);

        /**
         * <p>
         * Details about the content data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceContentDataDetails.Builder}
         * avoiding the need to create one manually via {@link SourceContentDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceContentDataDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceContentData(SourceContentDataDetails)}.
         * 
         * @param sourceContentData
         *        a consumer that will call methods on {@link SourceContentDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceContentData(SourceContentDataDetails)
         */
        default Builder sourceContentData(Consumer<SourceContentDataDetails.Builder> sourceContentData) {
            return sourceContentData(SourceContentDataDetails.builder().applyMutation(sourceContentData).build());
        }

        /**
         * <p>
         * Details about the generative chunk data.
         * </p>
         * 
         * @param generativeChunkData
         *        Details about the generative chunk data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeChunkData(GenerativeChunkDataDetails generativeChunkData);

        /**
         * <p>
         * Details about the generative chunk data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeChunkDataDetails.Builder}
         * avoiding the need to create one manually via {@link GenerativeChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeChunkDataDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #generativeChunkData(GenerativeChunkDataDetails)}.
         * 
         * @param generativeChunkData
         *        a consumer that will call methods on {@link GenerativeChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeChunkData(GenerativeChunkDataDetails)
         */
        default Builder generativeChunkData(Consumer<GenerativeChunkDataDetails.Builder> generativeChunkData) {
            return generativeChunkData(GenerativeChunkDataDetails.builder().applyMutation(generativeChunkData).build());
        }

        /**
         * <p>
         * Streaming chunk data for email response generation containing partial response content.
         * </p>
         * 
         * @param emailResponseChunkData
         *        Streaming chunk data for email response generation containing partial response content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailResponseChunkData(EmailResponseChunkDataDetails emailResponseChunkData);

        /**
         * <p>
         * Streaming chunk data for email response generation containing partial response content.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailResponseChunkDataDetails.Builder}
         * avoiding the need to create one manually via {@link EmailResponseChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailResponseChunkDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #emailResponseChunkData(EmailResponseChunkDataDetails)}.
         * 
         * @param emailResponseChunkData
         *        a consumer that will call methods on {@link EmailResponseChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailResponseChunkData(EmailResponseChunkDataDetails)
         */
        default Builder emailResponseChunkData(Consumer<EmailResponseChunkDataDetails.Builder> emailResponseChunkData) {
            return emailResponseChunkData(EmailResponseChunkDataDetails.builder().applyMutation(emailResponseChunkData).build());
        }

        /**
         * <p>
         * Streaming chunk data for email overview containing partial overview content.
         * </p>
         * 
         * @param emailOverviewChunkData
         *        Streaming chunk data for email overview containing partial overview content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailOverviewChunkData(EmailOverviewChunkDataDetails emailOverviewChunkData);

        /**
         * <p>
         * Streaming chunk data for email overview containing partial overview content.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailOverviewChunkDataDetails.Builder}
         * avoiding the need to create one manually via {@link EmailOverviewChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailOverviewChunkDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #emailOverviewChunkData(EmailOverviewChunkDataDetails)}.
         * 
         * @param emailOverviewChunkData
         *        a consumer that will call methods on {@link EmailOverviewChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailOverviewChunkData(EmailOverviewChunkDataDetails)
         */
        default Builder emailOverviewChunkData(Consumer<EmailOverviewChunkDataDetails.Builder> emailOverviewChunkData) {
            return emailOverviewChunkData(EmailOverviewChunkDataDetails.builder().applyMutation(emailOverviewChunkData).build());
        }

        /**
         * <p>
         * Streaming chunk data for email generative answers containing partial knowledge-based response content.
         * </p>
         * 
         * @param emailGenerativeAnswerChunkData
         *        Streaming chunk data for email generative answers containing partial knowledge-based response content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData);

        /**
         * <p>
         * Streaming chunk data for email generative answers containing partial knowledge-based response content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EmailGenerativeAnswerChunkDataDetails.Builder} avoiding the need to create one manually via
         * {@link EmailGenerativeAnswerChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailGenerativeAnswerChunkDataDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails)}.
         * 
         * @param emailGenerativeAnswerChunkData
         *        a consumer that will call methods on {@link EmailGenerativeAnswerChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails)
         */
        default Builder emailGenerativeAnswerChunkData(
                Consumer<EmailGenerativeAnswerChunkDataDetails.Builder> emailGenerativeAnswerChunkData) {
            return emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails.builder()
                    .applyMutation(emailGenerativeAnswerChunkData).build());
        }

        /**
         * <p>
         * Details about case summarization chunk data.
         * </p>
         * 
         * @param caseSummarizationChunkData
         *        Details about case summarization chunk data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSummarizationChunkData(CaseSummarizationChunkDataDetails caseSummarizationChunkData);

        /**
         * <p>
         * Details about case summarization chunk data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CaseSummarizationChunkDataDetails.Builder} avoiding the need to create one manually via
         * {@link CaseSummarizationChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseSummarizationChunkDataDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #caseSummarizationChunkData(CaseSummarizationChunkDataDetails)}.
         * 
         * @param caseSummarizationChunkData
         *        a consumer that will call methods on {@link CaseSummarizationChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseSummarizationChunkData(CaseSummarizationChunkDataDetails)
         */
        default Builder caseSummarizationChunkData(Consumer<CaseSummarizationChunkDataDetails.Builder> caseSummarizationChunkData) {
            return caseSummarizationChunkData(CaseSummarizationChunkDataDetails.builder()
                    .applyMutation(caseSummarizationChunkData).build());
        }

        /**
         * <p>
         * Details about suggested message data.
         * </p>
         * 
         * @param suggestedMessageData
         *        Details about suggested message data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedMessageData(SuggestedMessageDataDetails suggestedMessageData);

        /**
         * <p>
         * Details about suggested message data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestedMessageDataDetails.Builder}
         * avoiding the need to create one manually via {@link SuggestedMessageDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestedMessageDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #suggestedMessageData(SuggestedMessageDataDetails)}.
         * 
         * @param suggestedMessageData
         *        a consumer that will call methods on {@link SuggestedMessageDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestedMessageData(SuggestedMessageDataDetails)
         */
        default Builder suggestedMessageData(Consumer<SuggestedMessageDataDetails.Builder> suggestedMessageData) {
            return suggestedMessageData(SuggestedMessageDataDetails.builder().applyMutation(suggestedMessageData).build());
        }

        /**
         * <p>
         * Details about notes data.
         * </p>
         * 
         * @param notesData
         *        Details about notes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notesData(NotesDataDetails notesData);

        /**
         * <p>
         * Details about notes data.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotesDataDetails.Builder} avoiding the
         * need to create one manually via {@link NotesDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotesDataDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #notesData(NotesDataDetails)}.
         * 
         * @param notesData
         *        a consumer that will call methods on {@link NotesDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notesData(NotesDataDetails)
         */
        default Builder notesData(Consumer<NotesDataDetails.Builder> notesData) {
            return notesData(NotesDataDetails.builder().applyMutation(notesData).build());
        }

        /**
         * <p>
         * Details about notes chunk data.
         * </p>
         * 
         * @param notesChunkData
         *        Details about notes chunk data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notesChunkData(NotesChunkDataDetails notesChunkData);

        /**
         * <p>
         * Details about notes chunk data.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotesChunkDataDetails.Builder} avoiding
         * the need to create one manually via {@link NotesChunkDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotesChunkDataDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #notesChunkData(NotesChunkDataDetails)}.
         * 
         * @param notesChunkData
         *        a consumer that will call methods on {@link NotesChunkDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notesChunkData(NotesChunkDataDetails)
         */
        default Builder notesChunkData(Consumer<NotesChunkDataDetails.Builder> notesChunkData) {
            return notesChunkData(NotesChunkDataDetails.builder().applyMutation(notesChunkData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentDataDetails contentData;

        private GenerativeDataDetails generativeData;

        private IntentDetectedDataDetails intentDetectedData;

        private SourceContentDataDetails sourceContentData;

        private GenerativeChunkDataDetails generativeChunkData;

        private EmailResponseChunkDataDetails emailResponseChunkData;

        private EmailOverviewChunkDataDetails emailOverviewChunkData;

        private EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData;

        private CaseSummarizationChunkDataDetails caseSummarizationChunkData;

        private SuggestedMessageDataDetails suggestedMessageData;

        private NotesDataDetails notesData;

        private NotesChunkDataDetails notesChunkData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDetails model) {
            contentData(model.contentData);
            generativeData(model.generativeData);
            intentDetectedData(model.intentDetectedData);
            sourceContentData(model.sourceContentData);
            generativeChunkData(model.generativeChunkData);
            emailResponseChunkData(model.emailResponseChunkData);
            emailOverviewChunkData(model.emailOverviewChunkData);
            emailGenerativeAnswerChunkData(model.emailGenerativeAnswerChunkData);
            caseSummarizationChunkData(model.caseSummarizationChunkData);
            suggestedMessageData(model.suggestedMessageData);
            notesData(model.notesData);
            notesChunkData(model.notesChunkData);
        }

        public final ContentDataDetails.Builder getContentData() {
            return contentData != null ? contentData.toBuilder() : null;
        }

        public final void setContentData(ContentDataDetails.BuilderImpl contentData) {
            Object oldValue = this.contentData;
            this.contentData = contentData != null ? contentData.build() : null;
            handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
        }

        @Override
        public final Builder contentData(ContentDataDetails contentData) {
            Object oldValue = this.contentData;
            this.contentData = contentData;
            handleUnionValueChange(Type.CONTENT_DATA, oldValue, this.contentData);
            return this;
        }

        public final GenerativeDataDetails.Builder getGenerativeData() {
            return generativeData != null ? generativeData.toBuilder() : null;
        }

        public final void setGenerativeData(GenerativeDataDetails.BuilderImpl generativeData) {
            Object oldValue = this.generativeData;
            this.generativeData = generativeData != null ? generativeData.build() : null;
            handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
        }

        @Override
        public final Builder generativeData(GenerativeDataDetails generativeData) {
            Object oldValue = this.generativeData;
            this.generativeData = generativeData;
            handleUnionValueChange(Type.GENERATIVE_DATA, oldValue, this.generativeData);
            return this;
        }

        public final IntentDetectedDataDetails.Builder getIntentDetectedData() {
            return intentDetectedData != null ? intentDetectedData.toBuilder() : null;
        }

        public final void setIntentDetectedData(IntentDetectedDataDetails.BuilderImpl intentDetectedData) {
            Object oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData != null ? intentDetectedData.build() : null;
            handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
        }

        @Override
        public final Builder intentDetectedData(IntentDetectedDataDetails intentDetectedData) {
            Object oldValue = this.intentDetectedData;
            this.intentDetectedData = intentDetectedData;
            handleUnionValueChange(Type.INTENT_DETECTED_DATA, oldValue, this.intentDetectedData);
            return this;
        }

        public final SourceContentDataDetails.Builder getSourceContentData() {
            return sourceContentData != null ? sourceContentData.toBuilder() : null;
        }

        public final void setSourceContentData(SourceContentDataDetails.BuilderImpl sourceContentData) {
            Object oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData != null ? sourceContentData.build() : null;
            handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
        }

        @Override
        public final Builder sourceContentData(SourceContentDataDetails sourceContentData) {
            Object oldValue = this.sourceContentData;
            this.sourceContentData = sourceContentData;
            handleUnionValueChange(Type.SOURCE_CONTENT_DATA, oldValue, this.sourceContentData);
            return this;
        }

        public final GenerativeChunkDataDetails.Builder getGenerativeChunkData() {
            return generativeChunkData != null ? generativeChunkData.toBuilder() : null;
        }

        public final void setGenerativeChunkData(GenerativeChunkDataDetails.BuilderImpl generativeChunkData) {
            Object oldValue = this.generativeChunkData;
            this.generativeChunkData = generativeChunkData != null ? generativeChunkData.build() : null;
            handleUnionValueChange(Type.GENERATIVE_CHUNK_DATA, oldValue, this.generativeChunkData);
        }

        @Override
        public final Builder generativeChunkData(GenerativeChunkDataDetails generativeChunkData) {
            Object oldValue = this.generativeChunkData;
            this.generativeChunkData = generativeChunkData;
            handleUnionValueChange(Type.GENERATIVE_CHUNK_DATA, oldValue, this.generativeChunkData);
            return this;
        }

        public final EmailResponseChunkDataDetails.Builder getEmailResponseChunkData() {
            return emailResponseChunkData != null ? emailResponseChunkData.toBuilder() : null;
        }

        public final void setEmailResponseChunkData(EmailResponseChunkDataDetails.BuilderImpl emailResponseChunkData) {
            Object oldValue = this.emailResponseChunkData;
            this.emailResponseChunkData = emailResponseChunkData != null ? emailResponseChunkData.build() : null;
            handleUnionValueChange(Type.EMAIL_RESPONSE_CHUNK_DATA, oldValue, this.emailResponseChunkData);
        }

        @Override
        public final Builder emailResponseChunkData(EmailResponseChunkDataDetails emailResponseChunkData) {
            Object oldValue = this.emailResponseChunkData;
            this.emailResponseChunkData = emailResponseChunkData;
            handleUnionValueChange(Type.EMAIL_RESPONSE_CHUNK_DATA, oldValue, this.emailResponseChunkData);
            return this;
        }

        public final EmailOverviewChunkDataDetails.Builder getEmailOverviewChunkData() {
            return emailOverviewChunkData != null ? emailOverviewChunkData.toBuilder() : null;
        }

        public final void setEmailOverviewChunkData(EmailOverviewChunkDataDetails.BuilderImpl emailOverviewChunkData) {
            Object oldValue = this.emailOverviewChunkData;
            this.emailOverviewChunkData = emailOverviewChunkData != null ? emailOverviewChunkData.build() : null;
            handleUnionValueChange(Type.EMAIL_OVERVIEW_CHUNK_DATA, oldValue, this.emailOverviewChunkData);
        }

        @Override
        public final Builder emailOverviewChunkData(EmailOverviewChunkDataDetails emailOverviewChunkData) {
            Object oldValue = this.emailOverviewChunkData;
            this.emailOverviewChunkData = emailOverviewChunkData;
            handleUnionValueChange(Type.EMAIL_OVERVIEW_CHUNK_DATA, oldValue, this.emailOverviewChunkData);
            return this;
        }

        public final EmailGenerativeAnswerChunkDataDetails.Builder getEmailGenerativeAnswerChunkData() {
            return emailGenerativeAnswerChunkData != null ? emailGenerativeAnswerChunkData.toBuilder() : null;
        }

        public final void setEmailGenerativeAnswerChunkData(
                EmailGenerativeAnswerChunkDataDetails.BuilderImpl emailGenerativeAnswerChunkData) {
            Object oldValue = this.emailGenerativeAnswerChunkData;
            this.emailGenerativeAnswerChunkData = emailGenerativeAnswerChunkData != null ? emailGenerativeAnswerChunkData.build()
                    : null;
            handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_CHUNK_DATA, oldValue, this.emailGenerativeAnswerChunkData);
        }

        @Override
        public final Builder emailGenerativeAnswerChunkData(EmailGenerativeAnswerChunkDataDetails emailGenerativeAnswerChunkData) {
            Object oldValue = this.emailGenerativeAnswerChunkData;
            this.emailGenerativeAnswerChunkData = emailGenerativeAnswerChunkData;
            handleUnionValueChange(Type.EMAIL_GENERATIVE_ANSWER_CHUNK_DATA, oldValue, this.emailGenerativeAnswerChunkData);
            return this;
        }

        public final CaseSummarizationChunkDataDetails.Builder getCaseSummarizationChunkData() {
            return caseSummarizationChunkData != null ? caseSummarizationChunkData.toBuilder() : null;
        }

        public final void setCaseSummarizationChunkData(CaseSummarizationChunkDataDetails.BuilderImpl caseSummarizationChunkData) {
            Object oldValue = this.caseSummarizationChunkData;
            this.caseSummarizationChunkData = caseSummarizationChunkData != null ? caseSummarizationChunkData.build() : null;
            handleUnionValueChange(Type.CASE_SUMMARIZATION_CHUNK_DATA, oldValue, this.caseSummarizationChunkData);
        }

        @Override
        public final Builder caseSummarizationChunkData(CaseSummarizationChunkDataDetails caseSummarizationChunkData) {
            Object oldValue = this.caseSummarizationChunkData;
            this.caseSummarizationChunkData = caseSummarizationChunkData;
            handleUnionValueChange(Type.CASE_SUMMARIZATION_CHUNK_DATA, oldValue, this.caseSummarizationChunkData);
            return this;
        }

        public final SuggestedMessageDataDetails.Builder getSuggestedMessageData() {
            return suggestedMessageData != null ? suggestedMessageData.toBuilder() : null;
        }

        public final void setSuggestedMessageData(SuggestedMessageDataDetails.BuilderImpl suggestedMessageData) {
            Object oldValue = this.suggestedMessageData;
            this.suggestedMessageData = suggestedMessageData != null ? suggestedMessageData.build() : null;
            handleUnionValueChange(Type.SUGGESTED_MESSAGE_DATA, oldValue, this.suggestedMessageData);
        }

        @Override
        public final Builder suggestedMessageData(SuggestedMessageDataDetails suggestedMessageData) {
            Object oldValue = this.suggestedMessageData;
            this.suggestedMessageData = suggestedMessageData;
            handleUnionValueChange(Type.SUGGESTED_MESSAGE_DATA, oldValue, this.suggestedMessageData);
            return this;
        }

        public final NotesDataDetails.Builder getNotesData() {
            return notesData != null ? notesData.toBuilder() : null;
        }

        public final void setNotesData(NotesDataDetails.BuilderImpl notesData) {
            Object oldValue = this.notesData;
            this.notesData = notesData != null ? notesData.build() : null;
            handleUnionValueChange(Type.NOTES_DATA, oldValue, this.notesData);
        }

        @Override
        public final Builder notesData(NotesDataDetails notesData) {
            Object oldValue = this.notesData;
            this.notesData = notesData;
            handleUnionValueChange(Type.NOTES_DATA, oldValue, this.notesData);
            return this;
        }

        public final NotesChunkDataDetails.Builder getNotesChunkData() {
            return notesChunkData != null ? notesChunkData.toBuilder() : null;
        }

        public final void setNotesChunkData(NotesChunkDataDetails.BuilderImpl notesChunkData) {
            Object oldValue = this.notesChunkData;
            this.notesChunkData = notesChunkData != null ? notesChunkData.build() : null;
            handleUnionValueChange(Type.NOTES_CHUNK_DATA, oldValue, this.notesChunkData);
        }

        @Override
        public final Builder notesChunkData(NotesChunkDataDetails notesChunkData) {
            Object oldValue = this.notesChunkData;
            this.notesChunkData = notesChunkData;
            handleUnionValueChange(Type.NOTES_CHUNK_DATA, oldValue, this.notesChunkData);
            return this;
        }

        @Override
        public DataDetails build() {
            return new DataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataDetails#type()
     */
    public enum Type {
        CONTENT_DATA,

        GENERATIVE_DATA,

        INTENT_DETECTED_DATA,

        SOURCE_CONTENT_DATA,

        GENERATIVE_CHUNK_DATA,

        EMAIL_RESPONSE_CHUNK_DATA,

        EMAIL_OVERVIEW_CHUNK_DATA,

        EMAIL_GENERATIVE_ANSWER_CHUNK_DATA,

        CASE_SUMMARIZATION_CHUNK_DATA,

        SUGGESTED_MESSAGE_DATA,

        NOTES_DATA,

        NOTES_CHUNK_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
