/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSessionRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateSessionRequest.Builder, CreateSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(CreateSessionRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSessionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSessionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(CreateSessionRequest::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<Map<String, AIAgentConfigurationData>> builder(MarshallingType.MAP)
            .memberName("aiAgentConfiguration")
            .getter(getter(CreateSessionRequest::aiAgentConfigurationAsStrings))
            .setter(setter(Builder::aiAgentConfigurationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AIAgentConfigurationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIAgentConfigurationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactArn").getter(getter(CreateSessionRequest::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()).build();

    private static final SdkField<List<OrchestratorConfigurationEntry>> ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField
            .<List<OrchestratorConfigurationEntry>> builder(MarshallingType.LIST)
            .memberName("orchestratorConfigurationList")
            .getter(getter(CreateSessionRequest::orchestratorConfigurationList))
            .setter(setter(Builder::orchestratorConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorConfigurationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrchestratorConfigurationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrchestratorConfigurationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeOrchestratorConfigurationList")
            .getter(getter(CreateSessionRequest::removeOrchestratorConfigurationList))
            .setter(setter(Builder::removeOrchestratorConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("removeOrchestratorConfigurationList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ASSISTANT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, TAG_FILTER_FIELD, AI_AGENT_CONFIGURATION_FIELD,
            CONTACT_ARN_FIELD, ORCHESTRATOR_CONFIGURATION_LIST_FIELD, REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String assistantId;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final TagFilter tagFilter;

    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;

    private final String contactArn;

    private final List<OrchestratorConfigurationEntry> orchestratorConfigurationList;

    private final Boolean removeOrchestratorConfigurationList;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.tagFilter = builder.tagFilter;
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.contactArn = builder.contactArn;
        this.orchestratorConfigurationList = builder.orchestratorConfigurationList;
        this.removeOrchestratorConfigurationList = builder.removeOrchestratorConfigurationList;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The name of the session.
     * </p>
     * 
     * @return The name of the session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions.
     * </p>
     * 
     * @return An object that can be used to specify Tag conditions.
     */
    public final TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(aiAgentConfiguration);
    }

    /**
     * For responses, this returns true if the service returned a value for the AiAgentConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAiAgentConfiguration() {
        return aiAgentConfiguration != null && !(aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return aiAgentConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the email contact in Amazon Connect. Used to retrieve email content and
     * establish session context for AI-powered email assistance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the email contact in Amazon Connect. Used to retrieve email content and
     *         establish session context for AI-powered email assistance.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrchestratorConfigurationList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrchestratorConfigurationList() {
        return orchestratorConfigurationList != null && !(orchestratorConfigurationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of orchestrator configurations for the session being created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrchestratorConfigurationList} method.
     * </p>
     * 
     * @return The list of orchestrator configurations for the session being created.
     */
    public final List<OrchestratorConfigurationEntry> orchestratorConfigurationList() {
        return orchestratorConfigurationList;
    }

    /**
     * <p>
     * The list of orchestrator configurations to remove from the session.
     * </p>
     * 
     * @return The list of orchestrator configurations to remove from the session.
     */
    public final Boolean removeOrchestratorConfigurationList() {
        return removeOrchestratorConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrchestratorConfigurationList() ? orchestratorConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(removeOrchestratorConfigurationList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(tagFilter(), other.tagFilter()) && hasAiAgentConfiguration() == other.hasAiAgentConfiguration()
                && Objects.equals(aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings())
                && Objects.equals(contactArn(), other.contactArn())
                && hasOrchestratorConfigurationList() == other.hasOrchestratorConfigurationList()
                && Objects.equals(orchestratorConfigurationList(), other.orchestratorConfigurationList())
                && Objects.equals(removeOrchestratorConfigurationList(), other.removeOrchestratorConfigurationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateSessionRequest")
                .add("ClientToken", clientToken())
                .add("AssistantId", assistantId())
                .add("Name", name())
                .add("Description", description())
                .add("Tags", hasTags() ? tags() : null)
                .add("TagFilter", tagFilter())
                .add("AiAgentConfiguration", hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null)
                .add("ContactArn", contactArn())
                .add("OrchestratorConfigurationList", hasOrchestratorConfigurationList() ? orchestratorConfigurationList() : null)
                .add("RemoveOrchestratorConfigurationList", removeOrchestratorConfigurationList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "aiAgentConfiguration":
            return Optional.ofNullable(clazz.cast(aiAgentConfigurationAsStrings()));
        case "contactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "orchestratorConfigurationList":
            return Optional.ofNullable(clazz.cast(orchestratorConfigurationList()));
        case "removeOrchestratorConfigurationList":
            return Optional.ofNullable(clazz.cast(removeOrchestratorConfigurationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("aiAgentConfiguration", AI_AGENT_CONFIGURATION_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        map.put("orchestratorConfigurationList", ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        map.put("removeOrchestratorConfigurationList", REMOVE_ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSessionRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The name of the session.
         * </p>
         * 
         * @param name
         *        The name of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * 
         * @param tagFilter
         *        An object that can be used to specify Tag conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the email contact in Amazon Connect. Used to retrieve email content and
         * establish session context for AI-powered email assistance.
         * </p>
         * 
         * @param contactArn
         *        The Amazon Resource Name (ARN) of the email contact in Amazon Connect. Used to retrieve email content
         *        and establish session context for AI-powered email assistance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The list of orchestrator configurations for the session being created.
         * </p>
         * 
         * @param orchestratorConfigurationList
         *        The list of orchestrator configurations for the session being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList);

        /**
         * <p>
         * The list of orchestrator configurations for the session being created.
         * </p>
         * 
         * @param orchestratorConfigurationList
         *        The list of orchestrator configurations for the session being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorConfigurationList(OrchestratorConfigurationEntry... orchestratorConfigurationList);

        /**
         * <p>
         * The list of orchestrator configurations for the session being created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #orchestratorConfigurationList(List<OrchestratorConfigurationEntry>)}.
         * 
         * @param orchestratorConfigurationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestratorConfigurationList(java.util.Collection<OrchestratorConfigurationEntry>)
         */
        Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder>... orchestratorConfigurationList);

        /**
         * <p>
         * The list of orchestrator configurations to remove from the session.
         * </p>
         * 
         * @param removeOrchestratorConfigurationList
         *        The list of orchestrator configurations to remove from the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOrchestratorConfigurationList(Boolean removeOrchestratorConfigurationList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String assistantId;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private TagFilter tagFilter;

        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String contactArn;

        private List<OrchestratorConfigurationEntry> orchestratorConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private Boolean removeOrchestratorConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            clientToken(model.clientToken);
            assistantId(model.assistantId);
            name(model.name);
            description(model.description);
            tags(model.tags);
            tagFilter(model.tagFilter);
            aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            contactArn(model.contactArn);
            orchestratorConfigurationList(model.orchestratorConfigurationList);
            removeOrchestratorConfigurationList(model.removeOrchestratorConfigurationList);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier
                    .copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final List<OrchestratorConfigurationEntry.Builder> getOrchestratorConfigurationList() {
            List<OrchestratorConfigurationEntry.Builder> result = OrchestratorConfigurationListCopier
                    .copyToBuilder(this.orchestratorConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrchestratorConfigurationList(
                Collection<OrchestratorConfigurationEntry.BuilderImpl> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier
                    .copyFromBuilder(orchestratorConfigurationList);
        }

        @Override
        public final Builder orchestratorConfigurationList(
                Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copy(orchestratorConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(OrchestratorConfigurationEntry... orchestratorConfigurationList) {
            orchestratorConfigurationList(Arrays.asList(orchestratorConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(
                Consumer<OrchestratorConfigurationEntry.Builder>... orchestratorConfigurationList) {
            orchestratorConfigurationList(Stream.of(orchestratorConfigurationList)
                    .map(c -> OrchestratorConfigurationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRemoveOrchestratorConfigurationList() {
            return removeOrchestratorConfigurationList;
        }

        public final void setRemoveOrchestratorConfigurationList(Boolean removeOrchestratorConfigurationList) {
            this.removeOrchestratorConfigurationList = removeOrchestratorConfigurationList;
        }

        @Override
        public final Builder removeOrchestratorConfigurationList(Boolean removeOrchestratorConfigurationList) {
            this.removeOrchestratorConfigurationList = removeOrchestratorConfigurationList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
