/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAiPromptRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateAiPromptRequest.Builder, CreateAiPromptRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAiPromptRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(CreateAiPromptRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAiPromptRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateAiPromptRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<AIPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(CreateAiPromptRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(AIPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(CreateAiPromptRequest::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(CreateAiPromptRequest::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CreateAiPromptRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> API_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiFormat").getter(getter(CreateAiPromptRequest::apiFormatAsString)).setter(setter(Builder::apiFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiFormat").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAiPromptRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAiPromptRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AIPromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<AIPromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(CreateAiPromptRequest::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(AIPromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ASSISTANT_ID_FIELD, NAME_FIELD, TYPE_FIELD, TEMPLATE_CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD,
            TEMPLATE_TYPE_FIELD, MODEL_ID_FIELD, API_FORMAT_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, INFERENCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String assistantId;

    private final String name;

    private final String type;

    private final AIPromptTemplateConfiguration templateConfiguration;

    private final String visibilityStatus;

    private final String templateType;

    private final String modelId;

    private final String apiFormat;

    private final Map<String, String> tags;

    private final String description;

    private final AIPromptInferenceConfiguration inferenceConfiguration;

    private CreateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.type = builder.type;
        this.templateConfiguration = builder.templateConfiguration;
        this.visibilityStatus = builder.visibilityStatus;
        this.templateType = builder.templateType;
        this.modelId = builder.modelId;
        this.apiFormat = builder.apiFormat;
        this.tags = builder.tags;
        this.description = builder.description;
        this.inferenceConfiguration = builder.inferenceConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>..
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>..
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The name of the AI Prompt.
     * </p>
     * 
     * @return The name of the AI Prompt.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final AIPromptType type() {
        return AIPromptType.fromValue(type);
    }

    /**
     * <p>
     * The type of this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AIPromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this AI Prompt.
     * @see AIPromptType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration of the prompt template for this AI Prompt.
     * </p>
     * 
     * @return The configuration of the prompt template for this AI Prompt.
     */
    public final AIPromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Prompt.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final AIPromptTemplateType templateType() {
        return AIPromptTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of the prompt template for this AI Prompt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link AIPromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the prompt template for this AI Prompt.
     * @see AIPromptTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The identifier of the model used for this AI Prompt.
     * </p>
     * <note>
     * <p>
     * For information about which models are supported in each Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt">Supported
     * models for system/custom prompts</a>.
     * </p>
     * </note>
     * 
     * @return The identifier of the model used for this AI Prompt.</p> <note>
     *         <p>
     *         For information about which models are supported in each Amazon Web Services Region, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
     *         >Supported models for system/custom prompts</a>.
     *         </p>
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The API Format of the AI Prompt.
     * </p>
     * <p>
     * Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
     * </p>
     * <note>
     * <p>
     * The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API Format of the AI Prompt.</p>
     *         <p>
     *         Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
     *         </p>
     *         <note>
     *         <p>
     *         The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
     *         </p>
     * @see AIPromptAPIFormat
     */
    public final AIPromptAPIFormat apiFormat() {
        return AIPromptAPIFormat.fromValue(apiFormat);
    }

    /**
     * <p>
     * The API Format of the AI Prompt.
     * </p>
     * <p>
     * Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
     * </p>
     * <note>
     * <p>
     * The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiFormat} will
     * return {@link AIPromptAPIFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiFormatAsString}.
     * </p>
     * 
     * @return The API Format of the AI Prompt.</p>
     *         <p>
     *         Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
     *         </p>
     *         <note>
     *         <p>
     *         The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
     *         </p>
     * @see AIPromptAPIFormat
     */
    public final String apiFormatAsString() {
        return apiFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the AI Prompt.
     * </p>
     * 
     * @return The description of the AI Prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The inference configuration for the AI Prompt being created.
     * </p>
     * 
     * @return The inference configuration for the AI Prompt being created.
     */
    public final AIPromptInferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(apiFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiPromptRequest)) {
            return false;
        }
        CreateAiPromptRequest other = (CreateAiPromptRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(modelId(), other.modelId()) && Objects.equals(apiFormatAsString(), other.apiFormatAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description())
                && Objects.equals(inferenceConfiguration(), other.inferenceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAiPromptRequest").add("ClientToken", clientToken()).add("AssistantId", assistantId())
                .add("Name", name()).add("Type", typeAsString()).add("TemplateConfiguration", templateConfiguration())
                .add("VisibilityStatus", visibilityStatusAsString()).add("TemplateType", templateTypeAsString())
                .add("ModelId", modelId()).add("ApiFormat", apiFormatAsString()).add("Tags", hasTags() ? tags() : null)
                .add("Description", description()).add("InferenceConfiguration", inferenceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "apiFormat":
            return Optional.ofNullable(clazz.cast(apiFormatAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("apiFormat", API_FORMAT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiPromptRequest, T> g) {
        return obj -> g.apply((CreateAiPromptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAiPromptRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>..
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The name of the AI Prompt.
         * </p>
         * 
         * @param name
         *        The name of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this AI Prompt.
         * </p>
         * 
         * @param type
         *        The type of this AI Prompt.
         * @see AIPromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptType
         */
        Builder type(AIPromptType type);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration of the prompt template for this AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration of the prompt template for this AI Prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(AIPromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link AIPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(AIPromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Prompt.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Prompt.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of the prompt template for this AI Prompt.
         * </p>
         * 
         * @param templateType
         *        The type of the prompt template for this AI Prompt.
         * @see AIPromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptTemplateType
         */
        Builder templateType(AIPromptTemplateType templateType);

        /**
         * <p>
         * The identifier of the model used for this AI Prompt.
         * </p>
         * <note>
         * <p>
         * For information about which models are supported in each Amazon Web Services Region, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
         * >Supported models for system/custom prompts</a>.
         * </p>
         * </note>
         * 
         * @param modelId
         *        The identifier of the model used for this AI Prompt.</p> <note>
         *        <p>
         *        For information about which models are supported in each Amazon Web Services Region, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/create-ai-prompts.html#cli-create-aiprompt"
         *        >Supported models for system/custom prompts</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The API Format of the AI Prompt.
         * </p>
         * <p>
         * Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
         * </p>
         * <note>
         * <p>
         * The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
         * </p>
         * </note>
         * 
         * @param apiFormat
         *        The API Format of the AI Prompt.</p>
         *        <p>
         *        Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
         *        </p>
         *        <note>
         *        <p>
         *        The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be
         *        deprecated.
         *        </p>
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(String apiFormat);

        /**
         * <p>
         * The API Format of the AI Prompt.
         * </p>
         * <p>
         * Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
         * </p>
         * <note>
         * <p>
         * The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be deprecated.
         * </p>
         * </note>
         * 
         * @param apiFormat
         *        The API Format of the AI Prompt.</p>
         *        <p>
         *        Recommended values: <code>MESSAGES | TEXT_COMPLETIONS</code>
         *        </p>
         *        <note>
         *        <p>
         *        The values <code>ANTHROPIC_CLAUDE_MESSAGES | ANTHROPIC_CLAUDE_TEXT_COMPLETIONS</code> will be
         *        deprecated.
         *        </p>
         * @see AIPromptAPIFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIPromptAPIFormat
         */
        Builder apiFormat(AIPromptAPIFormat apiFormat);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the AI Prompt.
         * </p>
         * 
         * @param description
         *        The description of the AI Prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The inference configuration for the AI Prompt being created.
         * </p>
         * 
         * @param inferenceConfiguration
         *        The inference configuration for the AI Prompt being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * The inference configuration for the AI Prompt being created.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIPromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link AIPromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIPromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfiguration(AIPromptInferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link AIPromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(AIPromptInferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<AIPromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(AIPromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String assistantId;

        private String name;

        private String type;

        private AIPromptTemplateConfiguration templateConfiguration;

        private String visibilityStatus;

        private String templateType;

        private String modelId;

        private String apiFormat;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private AIPromptInferenceConfiguration inferenceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiPromptRequest model) {
            super(model);
            clientToken(model.clientToken);
            assistantId(model.assistantId);
            name(model.name);
            type(model.type);
            templateConfiguration(model.templateConfiguration);
            visibilityStatus(model.visibilityStatus);
            templateType(model.templateType);
            modelId(model.modelId);
            apiFormat(model.apiFormat);
            tags(model.tags);
            description(model.description);
            inferenceConfiguration(model.inferenceConfiguration);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIPromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(AIPromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getApiFormat() {
            return apiFormat;
        }

        public final void setApiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
        }

        @Override
        public final Builder apiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        @Override
        public final Builder apiFormat(AIPromptAPIFormat apiFormat) {
            this.apiFormat(apiFormat == null ? null : apiFormat.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIPromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(AIPromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAiPromptRequest build() {
            return new CreateAiPromptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
