/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A citation that references source content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Citation implements SdkPojo, Serializable, ToCopyableBuilder<Citation.Builder, Citation> {
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(Citation::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Citation::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(Citation::knowledgeBaseId)).setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<CitationSpan> CITATION_SPAN_FIELD = SdkField.<CitationSpan> builder(MarshallingType.SDK_POJO)
            .memberName("citationSpan").getter(getter(Citation::citationSpan)).setter(setter(Builder::citationSpan))
            .constructor(CitationSpan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationSpan").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceURL").getter(getter(Citation::sourceURL)).setter(setter(Builder::sourceURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceURL").build()).build();

    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceType").getter(getter(Citation::referenceTypeAsString)).setter(setter(Builder::referenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ID_FIELD, TITLE_FIELD,
            KNOWLEDGE_BASE_ID_FIELD, CITATION_SPAN_FIELD, SOURCE_URL_FIELD, REFERENCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contentId;

    private final String title;

    private final String knowledgeBaseId;

    private final CitationSpan citationSpan;

    private final String sourceURL;

    private final String referenceType;

    private Citation(BuilderImpl builder) {
        this.contentId = builder.contentId;
        this.title = builder.title;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.citationSpan = builder.citationSpan;
        this.sourceURL = builder.sourceURL;
        this.referenceType = builder.referenceType;
    }

    /**
     * <p>
     * The identifier of the content being cited.
     * </p>
     * 
     * @return The identifier of the content being cited.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The title of the cited content.
     * </p>
     * 
     * @return The title of the cited content.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The identifier of the knowledge base containing the cited content.
     * </p>
     * 
     * @return The identifier of the knowledge base containing the cited content.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the CitationSpan property for this object.
     * 
     * @return The value of the CitationSpan property for this object.
     */
    public final CitationSpan citationSpan() {
        return citationSpan;
    }

    /**
     * <p>
     * The source URL for the citation.
     * </p>
     * 
     * @return The source URL for the citation.
     */
    public final String sourceURL() {
        return sourceURL;
    }

    /**
     * <p>
     * A type to define the KB origin of a cited content
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return A type to define the KB origin of a cited content
     * @see ReferenceType
     */
    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(referenceType);
    }

    /**
     * <p>
     * A type to define the KB origin of a cited content
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return A type to define the KB origin of a cited content
     * @see ReferenceType
     */
    public final String referenceTypeAsString() {
        return referenceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(citationSpan());
        hashCode = 31 * hashCode + Objects.hashCode(sourceURL());
        hashCode = 31 * hashCode + Objects.hashCode(referenceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation) obj;
        return Objects.equals(contentId(), other.contentId()) && Objects.equals(title(), other.title())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(citationSpan(), other.citationSpan()) && Objects.equals(sourceURL(), other.sourceURL())
                && Objects.equals(referenceTypeAsString(), other.referenceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Citation").add("ContentId", contentId())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KnowledgeBaseId", knowledgeBaseId()).add("CitationSpan", citationSpan())
                .add("SourceURL", sourceURL() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReferenceType", referenceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "citationSpan":
            return Optional.ofNullable(clazz.cast(citationSpan()));
        case "sourceURL":
            return Optional.ofNullable(clazz.cast(sourceURL()));
        case "referenceType":
            return Optional.ofNullable(clazz.cast(referenceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentId", CONTENT_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("citationSpan", CITATION_SPAN_FIELD);
        map.put("sourceURL", SOURCE_URL_FIELD);
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Citation, T> g) {
        return obj -> g.apply((Citation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Citation> {
        /**
         * <p>
         * The identifier of the content being cited.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content being cited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The title of the cited content.
         * </p>
         * 
         * @param title
         *        The title of the cited content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The identifier of the knowledge base containing the cited content.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base containing the cited content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the CitationSpan property for this object.
         *
         * @param citationSpan
         *        The new value for the CitationSpan property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citationSpan(CitationSpan citationSpan);

        /**
         * Sets the value of the CitationSpan property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CitationSpan.Builder} avoiding the need
         * to create one manually via {@link CitationSpan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CitationSpan.Builder#build()} is called immediately and its
         * result is passed to {@link #citationSpan(CitationSpan)}.
         * 
         * @param citationSpan
         *        a consumer that will call methods on {@link CitationSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citationSpan(CitationSpan)
         */
        default Builder citationSpan(Consumer<CitationSpan.Builder> citationSpan) {
            return citationSpan(CitationSpan.builder().applyMutation(citationSpan).build());
        }

        /**
         * <p>
         * The source URL for the citation.
         * </p>
         * 
         * @param sourceURL
         *        The source URL for the citation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceURL(String sourceURL);

        /**
         * <p>
         * A type to define the KB origin of a cited content
         * </p>
         * 
         * @param referenceType
         *        A type to define the KB origin of a cited content
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(String referenceType);

        /**
         * <p>
         * A type to define the KB origin of a cited content
         * </p>
         * 
         * @param referenceType
         *        A type to define the KB origin of a cited content
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(ReferenceType referenceType);
    }

    static final class BuilderImpl implements Builder {
        private String contentId;

        private String title;

        private String knowledgeBaseId;

        private CitationSpan citationSpan;

        private String sourceURL;

        private String referenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Citation model) {
            contentId(model.contentId);
            title(model.title);
            knowledgeBaseId(model.knowledgeBaseId);
            citationSpan(model.citationSpan);
            sourceURL(model.sourceURL);
            referenceType(model.referenceType);
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final CitationSpan.Builder getCitationSpan() {
            return citationSpan != null ? citationSpan.toBuilder() : null;
        }

        public final void setCitationSpan(CitationSpan.BuilderImpl citationSpan) {
            this.citationSpan = citationSpan != null ? citationSpan.build() : null;
        }

        @Override
        public final Builder citationSpan(CitationSpan citationSpan) {
            this.citationSpan = citationSpan;
            return this;
        }

        public final String getSourceURL() {
            return sourceURL;
        }

        public final void setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
        }

        @Override
        public final Builder sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        public final String getReferenceType() {
            return referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        @Override
        public Citation build() {
            return new Citation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
