/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation that provides additional context or metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Annotation implements SdkPojo, Serializable, ToCopyableBuilder<Annotation.Builder, Annotation> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Annotation::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<Boolean> DESTRUCTIVE_HINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("destructiveHint").getter(getter(Annotation::destructiveHint)).setter(setter(Builder::destructiveHint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destructiveHint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            DESTRUCTIVE_HINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final Boolean destructiveHint;

    private Annotation(BuilderImpl builder) {
        this.title = builder.title;
        this.destructiveHint = builder.destructiveHint;
    }

    /**
     * <p>
     * The title of the annotation.
     * </p>
     * 
     * @return The title of the annotation.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A hint indicating that the annotation contains potentially destructive content.
     * </p>
     * 
     * @return A hint indicating that the annotation contains potentially destructive content.
     */
    public final Boolean destructiveHint() {
        return destructiveHint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(destructiveHint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(destructiveHint(), other.destructiveHint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Annotation").add("Title", title()).add("DestructiveHint", destructiveHint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "destructiveHint":
            return Optional.ofNullable(clazz.cast(destructiveHint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("destructiveHint", DESTRUCTIVE_HINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Annotation, T> g) {
        return obj -> g.apply((Annotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Annotation> {
        /**
         * <p>
         * The title of the annotation.
         * </p>
         * 
         * @param title
         *        The title of the annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A hint indicating that the annotation contains potentially destructive content.
         * </p>
         * 
         * @param destructiveHint
         *        A hint indicating that the annotation contains potentially destructive content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destructiveHint(Boolean destructiveHint);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private Boolean destructiveHint;

        private BuilderImpl() {
        }

        private BuilderImpl(Annotation model) {
            title(model.title);
            destructiveHint(model.destructiveHint);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Boolean getDestructiveHint() {
            return destructiveHint;
        }

        public final void setDestructiveHint(Boolean destructiveHint) {
            this.destructiveHint = destructiveHint;
        }

        @Override
        public final Builder destructiveHint(Boolean destructiveHint) {
            this.destructiveHint = destructiveHint;
            return this;
        }

        @Override
        public Annotation build() {
            return new Annotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
